Unit credit;
{ Copyright 1999 Sami Silaste   }
{ <samis@aethos.co.uk>
  <sami@semaphore.demon.co.uk>  }

interface

Procedure Credits;

implementation

uses crt,utils;

type
    RGBRec = record
      RVal, GVal, BVal : byte;
    end;
    ptype= array[0..255] of RGBRec;
    disptype = array[0..49,0..79,1..2] of byte;

const
     EGAColours : array[0..15] of record number,redval,greenval,blueval:byte; end = (
       (Number:0;RedVal:$00;GreenVal:$00;BlueVal:$00 ),
       (Number:1;RedVal:$00;GreenVal:$00;BlueVal:$fc ),
       (Number:2;RedVal:$24;GreenVal:$fc;BlueVal:$24 ),
       (Number:3;RedVal:$00;GreenVal:$fc;BlueVal:$fc ),
       (Number:4;RedVal:$fc;GreenVal:$14;BlueVal:$14 ),
       (Number:5;RedVal:$b0;GreenVal:$00;BlueVal:$fc ),
       (Number:20;RedVal:$70;GreenVal:$48;BlueVal:$00 ),
       (Number:7;RedVal:$ec;GreenVal:$ec;BlueVal:$ec ), {c4}
       (Number:56;RedVal:$34;GreenVal:$34;BlueVal:$34 ),
       (Number:57;RedVal:$00;GreenVal:$00;BlueVal:$70 ),
       (Number:58;RedVal:$00;GreenVal:$70;BlueVal:$00 ),
       (Number:59;RedVal:$00;GreenVal:$70;BlueVal:$70 ),
       (Number:60;RedVal:$70;GreenVal:$00;BlueVal:$00 ),
       (Number:61;RedVal:$70;GreenVal:$00;BlueVal:$70 ),
       (Number:62;RedVal:$fc;GreenVal:$fc;BlueVal:$24 ),
       (Number:63;RedVal:$fc;GreenVal:$fc;BlueVal:$fc ));
     { Rasterised colour definitions }
     foce:array[0..63] of byte =
     (8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,
      11,11,11,11,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,14,14,14,14,
      14,14,14,14,15,15,15,15,15);
     back:array[0..63] of byte =
     (0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,
      5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7);
     chra:array[0..63] of byte =
     (32,32,32,176,177,178,219,178,177,176,32,176,177,178,219,178,177,176,32,176,177,
      178,219,178,177,176,32,176,177,178,219,178,177,176,32,176,177,178,219,178,
      177,176,32,176,177,178,219,178,177,176,32,176,177,178,219,178,177,176,32,
      176,177,178,219,219);
      order:array[0..15] of byte = (0,56,1,57,2,58,3,59,4,60,5,61,20,62,7,63);
      dsegment = $B800;   { screen memory }
      doffset  = $0000;
      c1:real=0; c2:real=0; c3:real=0;

var colours:ptype;
    origmode:integer;
    xl,yl:integer;
    dsp: disptype absolute dsegment:doffset;
    coline:array[0..49] of byte;
    l:byte;
    ci,cinc:real;
    ii:shortint;

procedure SetPalette(tp:PType);

procedure waitborder; assembler;
label wbr1,wbr2;
  asm
    mov   dx,3dah
    wbr1: in      al,dx
    test  al,8
    jnz   wbr1
    wbr2: in      al,dx
    test  al,8
    jz    wbr2
end;

var palptr:pointer;
begin
  palptr := addr(tp);
  waitborder;
  asm
    push ds
    mov  si,word ptr palptr
    mov  ax,word ptr palptr+2
    mov  ds,ax
    mov  dx,3c8h
    mov  al,0
    out  dx,al
    inc  dx
    mov  cx,768
    rep  outsb
    pop  ds
  end;
end;

Procedure Restore_Colours;
var p:byte;
begin
  for p := 0 to 15 do with EGAColours[p] do
  begin
    colours[number].rval := redval;
    colours[number].gval := greenval;
    colours[number].bval := blueval;
  end;
  setpalette(colours);
end;

Procedure Set_Colours;
var o,q:byte;
    r1,r2,r3:real;
begin
  for q := 0 to 255 do with colours[q] do
  begin
    rval := 0; gval := 0; bval := 0;
  end;
  r1 := 0; r2 := 0; r3 := 2;
  for q := 0 to 15 do
  begin
    if q=15 then begin r1:=63; r2:=63; r3:=63; end;
    colours[order[q]].rval := trunc(r1);
    colours[order[q]].gval := trunc(r2);
    colours[order[q]].bval := trunc(r3);
    r3 := r3 + 3;
  end;
  setpalette(colours);
end;


Procedure CycleColours;
var i:byte;
begin
 for i := 0 to 48 do
   coline[i] := coline[succ(i)];
end;

Procedure cwriteln(ws:string);
{ Write centred text on screen }
var o,o2:byte;
begin
  xl := wherex; inc(yl); if yl>49 then yl := 49;
  textbackground(trunc(0.14*yl));
  o2 := (80-length(ws)) div 2;
  for o := 1 to length(ws) do
  begin
    if ws[o]<>' ' then
      dsp[pred(yl),pred(o2),1] := ord(ws[o])
    else
      dsp[pred(yl),pred(o2),1] := $FF;
    dsp[pred(yl),pred(o2),2] := dsp[yl,0,2] or $0F;
    inc(o2);
  end;
end;


Procedure CreateBackground;
var j:byte;
procedure cline(ln,pixec:byte);
var i:byte;
begin
  for i := 1 to 80 {-integer(ln=50)} do
  begin
    if dsp[pred(ln),pred(i),1] in [32,176,177,178,219,178] then
    begin
      dsp[pred(ln),pred(i),2] := (foce[pixec] or (back[pixec]*16));
      dsp[pred(ln),pred(i),1] := chra[pixec];
    end;
  end;
end;
begin
  for j := 1 to 50 do
    cline(j,coline[pred(j)]);gotoxy(1,1);
  yl:=2;textcolor(15);
  cwriteln('C64 Turbo Tape Loader V1.3');inc(yl,2);
  cwriteln('Copyright 1999 by Sami Silaste.'); inc(yl,2);
  cwriteln('This program is POSTCARDWARE.');
  cwriteln('You are free to copy it, as long as');
  cwriteln('all the original files are kept with it and');
  cwriteln('no alterations to the program are made and no profit is made.');
  cwriteln('Provided you credit the author, you may use the source code');
  cwriteln('in you own developments.');
  inc(yl,3);
  cwriteln('The author reserves the right to change these');
  cwriteln('conditions without further notice.');
  cwriteln('This software is provided on an ''as is basis'' and');
  cwriteln('whilst running it the user accepts full responsibility.');
  cwriteln('The author accepts no responsibility for');
  cwriteln('any damage, either direct or consequential,');
  cwriteln('to the user''s equipment, data, person, family or pets.');
  inc(yl,3);
  cwriteln('If you like this program, please send');
  cwriteln('a postcard to:');
  inc(yl,3);
  cwriteln('Sami Silaste');
  cwriteln('Clifford House');
  cwriteln('152 Redland Road');
  cwriteln('BRISTOL BS6 6YD');
  cwriteln('UNITED KINGDOM');
  inc(yl);cwriteln('or');inc(yl);
  cwriteln('Email your comments and/or suggestions to:');
  cwriteln('samis@aethos.co.uk or sami@semaphore.demon.co.uk');
  inc(yl,3);cwriteln('Press any key to exit.');
end;


Procedure Stripes(ind:byte);
const il:array[0..6] of real = ( 0.5, 0.317, 0.255, 0.19, 0.125, 0.06, 0 );
var rr:real; l:byte;
begin
  rr:=0.0;
  for l := 0 to 49 do
  begin
     coline[l] := abs(trunc(50*sin(rr)));
     rr := rr + il[ind];
  end;
end;

Function LastS(lmbd:byte; incr:real):boolean;
const rr:real=0;
begin
  rr:=rr+incr;
  coline[49] := abs(trunc(lmbd*sin(rr)));
  LastS := (coline[49]<2);
end;

Procedure Wait;
var ch: word absolute $40:$6C;
    chold:word;
begin
  chold := ch;
  while ch = chold do;
end;

Procedure Credits;
begin
  origmode := lastmode;
  textmode(259);set_cursor(32);
  Set_Colours; ci := 0; cinc := 0.04;
  for l := 1 to 3 do
    for ii := -6 to 6 do
    begin
      Stripes(abs(ii));
      CreateBackground;
      Wait;
    end;
  repeat
    Cyclecolours; { Scroll background colours }
    if LastS(59,ci) then ci := ci + cinc; { Create waves }
    if (ci > 0.5) or (ci < 0.05) then cinc := -cinc; { Reverse wave }
    CreateBackground; { Draw everything }
    Wait;
    with colours[order[15]] do { Cycle text colour }
    begin
      rval := trunc(abs(50*sin(c1)))+10;
      gval := trunc(abs(50*sin(c2)))+10;
      bval := trunc(abs(50*sin(c3)))+10;
    end; c1 := c1 + 0.01; c2 := c2 + 0.15; c3 := c3 + 0.03;
    setpalette(colours);
  until keypressed;
  for l := 1 to 50 do { Fade out }
  begin
    move(mem[dsegment:doffset], { Scroll down }
         mem[dsegment:doffset+160],
         8000-160);
    for yl := 0 to 15 do with colours[order[yl]] do
    begin
      rval := trunc(rval-(rval/50));
      gval := trunc(gval-(gval/50));
      bval := trunc(bval-(bval/50));
    end;
    setpalette(colours);
    Wait;
  end;
  Restore_Colours;
  set_cursor(0);
  textmode(origmode);
end;

end.

