Unit FileSys;

{ File handling for TurboTape Loader V1.3 }
{ Copyright 1999 Sami Silaste }
{ <samis@aethos.co.uk>
  <sami@semaphore.demon.co.uk>     }

interface

uses dos,crt;

type fileb = file of byte;
var buf:pointer;
    endoffile:boolean;
    fl,ftot:longint;
    bytesinbuffer,bufind:word;
    Di: DirStr;
    Na: NameStr;
    Ex: ExtStr;
    ccount : word;
    test_clock : word absolute $40:$6c;
    f2,logfile:fileb;
    name,logname:string;
    sfile:file;

const buflen:word=16384;
      longfilenames:boolean=false;
      fileopen:boolean=false;
      msdosname:string='';

function openfile(var f:file; fn:string):boolean;
Procedure closefile(var f:file);
Function create_file(var ff:fileb; destruct:boolean; lname:string):byte;
Function create_from_file(var ff:fileb; tempname:string; lname:string):boolean;
Function ShortName(ln:string):string;
function readfilebyte(var f:file):byte;
Procedure wait_a_sec(loops:word);
Procedure init_clock;
PROCEDURE BEEP;
Procedure skip(var fp:file; p:longint);

implementation

Procedure init_clock;
begin
  ccount := test_clock;
end;

Procedure wait_a_sec(loops:word);
{ Delay }
var i:word;
begin
  for i := 1 to loops do
    while test_clock = ccount do delay(1);
  ccount := test_clock;
end;

PROCEDURE BEEP;
{ Beeps! }
begin
  init_clock;
  sound(2000);
  wait_a_sec(9999);
  sound(1000);
  wait_a_sec(9999);
  sound(2000);
  wait_a_sec(9999);
  sound(1000);
  wait_a_sec(9999);
  nosound;
end;

function openfile(var f:file; fn:string):boolean;
begin
  getmem(buf,buflen);
  assign (f,fn);
  {$I-}
  reset(f,1);
  {$I+}
  if IOResult <> 0 then
    openfile := false
  else
  begin
    endoffile := false;
    fl := filesize(f);
    openfile := true;
    bytesinbuffer := 0;
  end;
end;

Procedure closefile(var f:file);
begin
  close(f);
  freemem(buf,buflen);
end;

Function ShortName(ln:string):string;
{ Get DOS name of a long Windows name }
var regs:registers;
    lng,shrt:string[255];
begin
  lng := ln + #0;
  fillchar(shrt,255,#255);
  with regs do
  begin
    ax := $7160; { Win95 long filenames file handling }
    cl := 1;
    ch := 0;
    ds := Seg(lng);    { Set DS:SI to addr }
    si := Ofs(lng[1]); { of first Char     }
    es := Seg(shrt);    { Set ES:DI to addr }
    di := Ofs(shrt[1]); { of first Char     }
  end;
  intr($21,regs); { interrupt $21 }
  if (regs.flags and 1) > 0 then
    shrt := '*error*'
  else
  begin
    fsplit(shrt,Di,Na,Ex);
    shrt := Di+Na+Ex;
  end;
  ShortName := shrt;
end;


Function create_file(var ff:fileb; destruct:boolean; lname:string):byte;
{ Windows 95/98 long filename compatible file creation }
const tempname : string = '!1z4x5v9.tmp'#0;
var sname:string;
    regs:registers;
    a:integer;
    lng:string;
begin
  if not longfilenames then { No windows 95 }
  begin
    assign(ff,lname);
    {$i-}
    reset(ff);
    {$i+}
    a := ioresult;
    if ((a = 0) and (destruct)) or (a = 2) then
    begin
      {$i-}
      rewrite(ff);
      {$i+}
      a := ioresult;
    end
    else
      if (a=0) and (not destruct) then a := 5;
    create_file := a;
  end
  else
begin { Yes, we have Windows 95 }
  lng := lname+ #0;
  assign(ff,tempname);
  rewrite(ff);
  close(ff);
  with regs do
  begin
    ax := $7156; { Win95 long filenames file handling }
    ds := Seg(tempname);    { Set DS:DX to addr }
    dx := Ofs(tempname[1]); { of first Char     }
    es := Seg(lng);    { Set ES:DI to addr }
    di := Ofs(lng[1]); { of first Char     }
  end;
  intr($21,regs); { interrupt $21 }

  if (regs.flags and 1) > 0 then { get success status from Carry }
  begin
    if (regs.ax = 5) and (destruct) then { file exists - overwrite}
    begin
      sname := ShortName(lname);
      assign(ff, sname);
      {$i-}
      erase(ff);
      {$i+}
      a:=ioresult;
      if a <> 0 then
        create_file := regs.ax
      else
      begin
        rewrite(ff);
        create_file := 0;
      end;
    end
    else
      create_file := regs.ax;
  end
  else
  begin
    sname := ShortName(lname);
    assign(ff,sname);
    rewrite(ff);
    create_file := 0;
  end;
end;
end;

Function create_from_file(var ff:fileb; tempname:string; lname:string):boolean;
{ Rename DOS file with a long Windows name }
var sname:string;
    regs:registers;
    a:integer;
    lng:string;
begin
  if not longfilenames then { No windows 95 }
  begin
    assign(ff,lname);
    {$i-}
    erase(ff);
    {$i+}
    a := ioresult;
    assign(ff,tempname);
    rename(ff,lname);
    a := ioresult;
    create_from_file := (a=0);
  end
  else
  begin { Yes, we have Windows 95 }
    { overwrite old file, if exists }
    sname := ShortName(lname);
    assign(ff, sname);
    {$i-}
    erase(ff);
    {$i+}
    a:=ioresult;
    tempname := tempname + #0;
    lng := lname+ #0;
    with regs do
    begin
      ax := $7156; { Win95 long filenames file handling }
      ds := Seg(tempname);    { Set DS:DX to addr }
      dx := Ofs(tempname[1]); { of first Char     }
      es := Seg(lng);    { Set ES:DI to addr }
      di := Ofs(lng[1]); { of first Char     }
    end;
    intr($21,regs); { interrupt $21 }
    sname := ShortName(lname);
    assign(ff, sname);
    create_from_file := ((regs.flags and 1)=0); { Get success status from Carry }
  end;
end;

function readfilebyte (var f:file):byte;
{ Returns one physical byte from buffer }
var rbytes:word;
begin
  if bytesinbuffer = 0 then { Buffer is empty }
  begin
    rbytes := buflen;
    if fl-filepos(f) < buflen then
      rbytes := fl-filepos(f);
    blockread(f,buf^,rbytes);
    bytesinbuffer := rbytes;
    bufind := 0;
  end;
  dec(bytesinbuffer);
  if (bytesinbuffer = 0) then
    if eof(f) then endoffile := true;
  readfilebyte := mem[seg(buf^):ofs(buf^)+bufind]; inc(bufind);
  inc(ftot);
end;

Procedure skip(var fp:file; p:longint);
{ Jumps to a position in the file }
begin
  if odd(p) then inc(p); { Adjust border }
  seek(fp,p);
  bytesinbuffer := 0; ftot := 0;
end;


end.