Program C64_Turbo_Tape_Loader_V1_3;
{ Copyright 1999 Sami Silaste   }
{ <samis@aethos.co.uk>
  <sami@semaphore.demon.co.uk>  }

{ Can be compiled with Borland Turbo Pascal 6.0 or 7.0 }

uses crt,dos,waveunit,filesys,utils;

type
    error_index = record ebyte:word; ebit:byte; eval:boolean; end;

var exitnow, hdr_ok, hi, stop, success, serious_errors: boolean;
    bit,prev,bitsum,bitcount,namecounter,
    max,mapcounter,chksum, med_max, med_min,
    med_lo,med_hi,bit0max_vol,bit1max_vol,ecount:byte;
    programcounter, program_size,program_start,program_end,
    temp,c1,d,bits,tot_errors,ofp,oftot:longint;
    mrk,dir,odir:char;
    Program_name:string;
    med_med,med_dif,discriminator:real;
    header : array[0..255] of byte;
    e_ind : array[1..32] of error_index;

const
    chksum_comp : byte = 0;
    prgstep:byte=16;
    step:word=1024;
    extracted:word=0;
    start : longint = 0;
    err:string ='Unknown error';
    b : array[0..7] of byte = ($80,$40,$20,$10,$08,$04,$02,$01);

Procedure assess256bits(st:longint; var mmax,mmin,mlo,mhi,bit0max,bit1max:byte);
{ Read in 256 bits. Used for sound file auto-assessing only. }
{ Returns max/min volumes and max/min peak volumes for 0/1 bits }

var med_mins:array[0..255] of byte;
    med_maxs:array[0..255] of byte;
    med_len:array[0..255] of byte;
    vols:array[0..1,0..255] of byte;
    d,i,i2,bitstart,t1,tt1,t2,tt2,quit:longint;
    dir,odir:char;
    testbits:word;
    prev,bit,chk:byte;
begin
  d := st;
  skip(sfile,d);
  for i := 0 to 255 do
  begin
    med_mins[i] := 0; med_maxs[i] := 0; med_len[i] := 0;
    vols[0,i] := 0; vols[1,i] := 0;
  end;
  dir := '@'; odir := '@'; testbits := 0; prev := 0; bit := 0;
  bitstart := d;
  chk := 0; quit := 0;
  while (not endoffile) and (testbits<255) and (quit < 20000) do
  begin
    inc(quit);
    prev := bit; bit := readbyte; odir := dir;
    if prev > bit then dir := 'd' else dir := 'a';
    if (odir = 'a') and  (dir = 'd') then
      begin inc(med_maxs[bit]); chk := bit; end;
    if (odir = 'd') and  (dir = 'a') and (chk>0) then
    begin
      inc(med_mins[bit]);
      i := d - bitstart;
      if i<256 then
      begin
        inc(med_len[i]);
        vols[0,testbits] := chk;
        vols[1,testbits] := i;
      end;
      inc(testbits);
      bitstart := d;
      chk := 0;
    end;
    inc(d);
  end;

  for i := 0 to 255 do
    if med_len[i] < 16 then med_len[i] := 0;

  mlo := 0; i := 255; bit := 0;
  while (i > 0) and (mlo=0) do
  begin
    for i2 := 0 to 255 do
      if med_len[i2] = i then begin mlo := i2; bit := i2; end;
    dec(i);
  end;
  med_len[pred(bit)] := 0;
  med_len[bit] := 0;
  med_len[succ(bit)] := 0;
  mhi := 0; i := 255;
  while (i > 0) and (mhi=0) do
  begin
    for i2 := 0 to 255 do
      if med_len[i2] = i then mhi := i2;
    dec(i);
  end;

  mmax := 0; mmin := 0; t1 := 0; t2 := 0; tt1 := 0; tt2 := 0;
  for i := 0 to 255 do
  begin
    inc(t1,med_mins[i]*i);inc(tt1,med_mins[i]);
    inc(t2,med_maxs[i]*i);inc(tt2,med_maxs[i]);
  end;
  if tt1 > 0 then mmin := t1 div tt1;
  if tt2 > 0 then mmax := t2 div tt2;

  if mhi > mlo then
  begin
     if mhi-(mlo*1.5) > (abs(mhi-mlo)/2) then
     begin mlo := 0; mhi := 0; end;
  end
  else begin mlo := 0; mhi := 0; end;

  bit1max := 0; bit0max := 0;
  if (mlo>0) and (mhi>0) then
  begin
    t1 := 0; t2 := 0; tt1 := 0; tt2 := 0;
    for i := 0 to 255 do
    begin
      if vols[1,i] = mhi then begin inc(t1,vols[0,i]); inc(tt1); end;
      if vols[1,i] = mlo then begin inc(t2,vols[0,i]); inc(tt2); end;
    end;
    bit1max := round(t1/tt1);
    bit0max := round(t2/tt2);
  end;
end;

Procedure assess(var mmax,mmin,mlo,mhi,b0max,b1max:byte);
{ Auto-assess sound file to determine if the recording volume used }
{ is too high/low. }

const ea=100;
var i,i2,i3,i4 : longint;
    j : byte;
    mx,mn,ml,mh,m0,m1:array[1..ea] of byte;
    t1,t2,t3,t4:array[0..255] of byte;
    mmav,mmiv,mlv,mhv:byte;
begin
  gotoxy(xl,yl);write('Assessing sound file...');
  for j := 1 to ea do
  begin
    assess256bits(trunc(fsize/(ea+1))*j,mx[j],mn[j],ml[j],mh[j],m0[j],m1[j]);
    gotoxy(xl,yl);write('Assessing sound file ',trunc(j/ea*100),'%');
  end; inc(yl);
  for j := 0 to 255 do
    begin t1[j] := 0; t2[j] := 0; t3[j] := 0; t4[j] := 0; end;
  i := 0; i2 := 0; i3 := 0; i4 := 0;
  for j := 1 to ea do
  begin
    inc(i,m0[j]); inc(i2,m1[j]);
    if m0[j] > 0 then inc(i3);
    if m1[j] > 0 then inc(i4);
  end;
  b0max := 0; b1max := 0;
  if i3 > 0 then
    b0max := round(i/i3);
  if i4 > 0 then
    b1max := round(i2/i4);

  for j := 1 to ea do
  begin
    inc(t1[mx[j]]); inc(t2[mn[j]]);
    inc(t3[ml[j]]); inc(t4[mh[j]]);
  end;
  mmax := 0; mmin := 0; mlo := 0; mhi := 0;
  mmav := 0; mmiv := 0; mlv := 0; mhv := 0;
  for j := 1 to 255 do
  begin
    if mmav < t1[j] then begin mmax := j; mmav := t1[j]; end;
    if mmiv < t2[j] then begin mmin := j; mmiv := t2[j]; end;
    if mlv  < t3[j] then begin mlo := j;  mlv  := t3[j]; end;
    if mhv  < t4[j] then begin mhi := j;  mhv  := t4[j]; end;
  end;
  if mmin >= mmax then
  begin
    Xwriteln('Warning: Failed to assess max & min peak volumes.');
    Xwriteln('         If errors are produced, resample and');
    Xwriteln('         check that sample rate is sufficient.');
  end
  else
  begin
    if (mmin > 128) or (mmax > 230) then
    begin
      Xwriteln('Warning: Sampling volume is high. If errors are');
      Xwriteln('         produced, resample with reduced sampling volume.');
    end;
    if (mmin < 32) or (mmax < 128) then
    begin
      Xwriteln('Warning: Sampling volume is low. If errors are');
      Xwriteln('         produced, resample with increased sampling volume.');
    end;
    if mmax-mmin < 20 then
    begin
      Xwriteln('Warning: Minumum-Maximum volume difference is low. If errors are');
      Xwriteln('         produced, check sampling volume and resample.');
    end;
    if not tresholdoverride then treshold:= 0;
  end;
  lwriteln('Mode of 0 bit length: '+WordVal(mlo));
  lwriteln('Mode of 1 bit length: '+WordVal(mhi));
  if (abs(mhi-mlo) < 4) or (abs((mlo*1.5)-mhi)>2) then
  begin
    Xwriteln('Warning: Possible difficulties discovered in differentiating between');
    Xwriteln('         1 and 0 bits. Check that sample rate is sufficient.');
    if automatic then
    begin
      if upper(copy(name,length(name)-2,3)) = 'WAV' then
      begin
        Xwriteln('         Bit lengths set to default values (analysis rejected).');
        mlo := lobit_def; mhi := hibit_def;
        lwriteln('         Defaulted 0 bit length to '+WordVal(mlo)+'.');
        lwriteln('         Defaulted 1 bit length to '+WordVal(mhi)+'.');
      end;
    end;
  end;
  if (b1max>210) then
  begin
    Xwriteln('Warning: Volume is quite high. Check that the peak');
    Xwriteln('         volumes do not go out of the scale.');
  end;
  endoffile := false;
end;

Procedure init_bit_read;
{ Initialise reading bits }
begin
  bit := 0; prev:=0; dir := '@'; bits := 0; odir := '@';
  bitsum := 0; bitcount := 0; mapcounter := 0; max := 0;
end;

Function read_bit:boolean;
{ Read one bit. Returns TRUE for 1 and FALSE for 0. }
const bval : array [false..true] of string = ( '0', '1' );
var hi,bit_read:boolean;
begin
  check_keys(mrk); if upcase(mrk) in['Q',#27] then stop := true;
  bit_read := false; max := 0; c1 := d;
  while (not endoffile) and (not stop) and (not bit_read) do
  begin
    prev := bit; bit := readbyte;
    odir := dir;
    if abs(prev-bit) > treshold then { check if wave is going up or down }
    begin
      if prev > bit then dir := 'd' else dir := 'a';
    end;
    inc(d);
    if (odir = 'a') and  (dir = 'd') and (d-c1>med_dif) then
      begin max := bit; end;
    if (odir = 'd') and  (dir = 'a') and (max>0) and (d-c1>med_dif) then
    begin
      c1 := d - c1; { c1 = wave length }

      if (c1 > 1.2*med_hi) and (hdr_ok) then
      begin
        { too long bit, show warning }
        lwriteln('ERROR: Too long bit sequence:'+wordval(c1));
        lwriteln('  '+WARNING(d,programcounter,bitcount));
        serious_errors := true;
      end;

      if (c1 < 0.8*med_lo) and (hdr_ok) then
      begin { too short bit. show error. }
        lwriteln('ERROR: Too short bit sequence:'+wordval(c1));
        lwriteln('  '+WARNING(d,programcounter,bitcount));
        serious_errors := true;
      end;

      if abs(med_med-c1) < discriminator then { Could not reliably discern 0/1 bit on length alone }
      begin
        if max > abs(bit1max_vol+bit0max_vol)/2 then
          hi := true else hi := false;
        if hdr_ok then
        begin
          if ecount >= 32 then serious_errors := true else
          with e_ind[succ(ecount)] do
          begin
            inc(ecount);
            ebyte := programcounter;
            ebit := bitcount;
            eval := hi;
          end;
          lwriteln('WARNING: Dodgy bit, decided '+bval[hi]+' on volume.');
          lwriteln('  '+WARNING(d,programcounter,bitcount));
        end;
      end
      else
        if (c1 > med_med) then hi := true else hi := false; { hi or lo bit (1/0) }
      bit_read := true;
    end;
  end;
  read_bit := hi;
end;

Function Find_Sync(htype:byte):boolean;
{ Finds segment header and data. Returns TRUE if sync found. }
{ hbyte 1=Header, 0=Program                                  }
type
    syncmap = array[0..79] of boolean;
var
    match : array[0..9] of byte;
    temp:byte;
    sync_ok,match_name:boolean;
    map1 : syncmap;
    map2 : syncmap;

begin
  sync_ok := false;
  for temp := 0 to 8 do match[temp] := 9-temp;
  match[9] := htype;
  for temp := 0 to 31 do header[temp] := 0; { zero header data }
  for temp := 0 to 79 do { zero bitsync data }
    begin map2[temp] := false; map1[temp] := false; end;
  bits := 0;
  for temp := 0 to 9 do { do bitsync for header & program }
  begin
    bitcount := 0;
    while bitcount < 8 do
    begin
      if match[temp] and b[bitcount] > 0 then map2[bits] := true;
      inc(bitcount); inc(bits);
    end;
  end;
  Init_bit_read; match_name := false;
  while (not endoffile) and (not stop) and (not match_name) do
  begin
    alive;
    for temp := 1 to 79 do { shift sync bits left }
      map1[temp-1] := map1[temp];
    map1[79] := read_bit;
    match_name := true;
    for temp := 0 to 79 do
      if map1[temp] <> map2[temp] then match_name := false;
    if match_name then
    begin
      sync_ok := true; hdr_ok := true;
    end;
  end;
  if not stop then err := 'End of file';
  Find_Sync := sync_ok and (not stop) and (not endoffile);
end;

Function read_byte:byte;
{ Reads on C64 byte }
begin
  alive;
  bitcount := 0; bitsum := 0;
  while (not endoffile) and (not stop) and (bitcount < 8) do
  begin
    if read_bit then bitsum := bitsum or b[bitcount];
    inc(bitcount);
  end;
  read_byte := bitsum;
end;

Function read_header:boolean;
{ Reads Turbo Tape header information. }
{ Returns TRUE if header is OK.        }
var header_ok:boolean;
begin
  header_ok := true;
  namecounter := 1;
  err := 'user interrupt';
  while ( namecounter < 32 ) and (not stop) do
  begin { Read in prg header data }
    header[namecounter] := read_byte;
    inc(namecounter);
    if namecounter = 32 then
    begin { Show prg name & start addr & length }
      nosound;
      program_start := word(header[2]*256) + header[1];
      program_end := word(header[4]*256) + header[3];
      program_size := program_end - program_start;
      program_name := '';
      for temp := 6 to 6+15 do { copy prg name from header }
      if header[temp] in [32..95] then
        Program_name := Program_name + chr(header[temp])
      else
        Program_name := Program_name + '~';
      if length(Program_name) > 0 then
        while (Program_name[length(Program_name)] = ' ') and (length(Program_name)>0) do
          Program_name := copy(Program_name,1,length(Program_name)-1);
      Program_name := clean(Program_name);
      if length(Program_name) = 0 then
        Program_name := 'NO_NAME';
      Xwriteln('FOUND:            ');
      Xwriteln('  Program name: '+Program_name);
      lwriteln('  Program begin address: '+WordVal(program_start));
      lwriteln('  Program end address: '+WordVal(program_end));
      Xwriteln('  Program size: '+WordVal(program_size));
      if (Program_name = 'NO_NAME') then
      begin
        Xwriteln('  File was saved without a name.');
        if not Automatic then
        begin
          Xwriteln('  Please enter new file name: ');dec(yl);
          set_cursor(0);
          gotoxy(xl+30,yl);readln(Program_name);
          set_cursor(32); { Make cursor visible }
        end
        else
          Program_name := Program_name + wordval(extracted);
        Xwriteln('');Program_name := upper(Program_name);
        FSplit(Program_name, Di, Na, Ex);
        if Ex <> '' then
          Program_name := copy(Program_name,1,length(Program_name)-length(Ex));
      end;
      if program_size < 0 then
      begin
        header_ok := false;
        err := 'Error whilst reading header';
      end
      else
      begin
        if header[0] = 0 then
          lwriteln('  Program load address: basic start')
        else
          lwriteln('  Program load address: fixed to begin address');
        if msdosname = '' then
        begin
          if not longfilenames then
            msdosname := copy(Program_name,1,8)+'.PRG'
          else
            msdosname := Program_name+'.PRG';
        end;
        mrk := '@'; exitnow := false;
        if create_file(f2,false,msdosname) = 5 then
        begin
          if not automatic then
            while not (upcase(mrk) in['Y','N','S','Q']) do
            begin
              Xwriteln('  File '+msdosname+' exists. Overwrite (y/n/s/q)? ');
              repeat until keypressed; mrk := readkey;
              mrk := upcase(mrk);
            end else mrk := 'Y';
          case mrk of
            'S':begin err := 'File skipped'; header_ok := false; end;
            'Q':begin stop := true; err := 'User interrupt'; exit; end;
            'N':begin
                  Xwriteln('  Please enter new file name: ');dec(yl);
                  set_cursor(0); { make cursor visible }
                  gotoxy(xl+30,yl);readln(msdosname);
                  set_cursor(32); { make cursor invisible }
                  Xwriteln('');
                  if create_file(f2,false, msdosname) <> 0 then
                  begin
                    header_ok:=false; err := 'Could not create MS-DOS file.';
                  end;
                end;
            'Y':begin
                  if create_file(f2, true, msdosname) <> 0 then
                  begin
                    header_ok:=false; err := 'Could not create MS-DOS file.';
                  end;
                end;
          end;
        end;
      end;
      if (header_ok) then
      begin
        { MS-DOS file OK. Write start addr bytes }
        lwriteln('  '+msdosname+' assigned as MS-DOS name.');
        fileopen := true; for temp := 1 to 2 do write(f2,header[temp]);
        Xwriteln('Seeking for program start...');
      end;
    end;
  end;
  Read_Header := header_ok;
end;

Function Read_in(var ppp:pointer; n:string):word;
{ Read C64 file in memory for recovery }
var fr:file;fb:file of byte;
    sz:word;
begin
  if not openfile(fr,n) then
    begin Xwriteln('Error: File ('+n+') to be recovered not found'); halt; end;
  sz := word(filesize(fr)-2);
  reset(fr,1);
  blockread(fr,ppp^,2); { skip disk file header }
  blockread(fr,ppp^,sz);
  close(fr);
  read_in := sz;
end;

Function CalculateChecksum(var ppp:pointer; ss:word):byte;
{ Calculate 8 bit checksum from prg in memory }
var x:byte; cc:word;
begin
  chksum_comp := 0; cc := 0;
  while cc < ss do
  begin
    x := mem[seg(ppp^):ofs(ppp^)+cc]; inc(cc);
    chksum_comp := chksum_comp XOR x;
  end;
  CalculateChecksum := chksum_comp;
end;

function Easy_recovery(var ppp:pointer; cnt,len:word):boolean;
{ Try flipping each suspect bit in turn and see if checksum is recovered }
var i,j:byte;
begin
  i := 1;
  repeat
    begin
      for j := 1 to cnt do with e_ind[j] do
      begin
        mem[seg(ppp^):ofs(ppp^)+ebyte] :=
        mem[seg(ppp^):ofs(ppp^)+ebyte] and (not b[ebit]);
        mem[seg(ppp^):ofs(ppp^)+ebyte] :=
        mem[seg(ppp^):ofs(ppp^)+ebyte] or byte(byte(eval) * b[ebit]);
      end;
      with e_ind[i] do
      begin
        mem[seg(ppp^):ofs(ppp^)+ebyte] :=
        mem[seg(ppp^):ofs(ppp^)+ebyte] xor b[ebit];
        lwriteln('Trying to flip byte '+wordval(ebyte)+' bit '+wordval(ebit)+
        ' from '+wordval(integer(eval))+' to '+wordval(integer(not eval)));
      end;
    end;
    inc(i);
  until (CalculateChecksum(ppp,len)=chksum) or (i>cnt);
  easy_recovery := (CalculateChecksum(ppp,len)=chksum);
end;

Function Hard_recovery(var ppp:pointer; cnt,len:word):boolean;
{ Try all combinations of all suspect bits and see if chekcsum is recovered }
var pows : array[0..31] of longint;
    i:longint; j:byte;
    op:longint;
    original : array[1..32] of error_index;

function pow(t:byte):longint;
var p:longint;t2:byte;
begin
  p := 1;
  for t2 := 1 to t do
    p := p * 2;
  pow := p;
end;

begin
  for i := 0 to 31 do
  begin { Store original bit configuration of suspect bits }
    original[succ(i)].eval := e_ind[succ(i)].eval;
    pows[i] := pow(i);
  end;
  i := 0; op := pows[cnt] div 100; { Initialise progress counter }
  if op > 1000 then op := op div 100; { Shorten counter if likely to take long time }
  Xwriteln('  Attempting hard recovery, '+wordval(pows[cnt])+' permutations to do...');
  Xwriteln('');
  if op = 0 then inc(op);
  for j := 1 to cnt do with e_ind[j] do { Restore original configuration }
  begin                                 { of suspect bits                }
    mem[seg(ppp^):ofs(ppp^)+ebyte] :=
    mem[seg(ppp^):ofs(ppp^)+ebyte] and not b[ebit];
    mem[seg(ppp^):ofs(ppp^)+ebyte] :=
    mem[seg(ppp^):ofs(ppp^)+ebyte] or byte((byte(eval) * b[ebit]));
  end;
  repeat { Loop until checksum OK, all combinations tried or aborted. }
    mrk := '@'; key_read_interval := 0; check_keys(mrk); mrk := upcase(mrk);
    { Set suspect bits for each configuration }
    for j := 1 to cnt do with e_ind[j] do
      eval := (i and pows[pred(j)]) > 0;
    { Write set bits to memory }
    for j := 1 to cnt do with e_ind[j] do
    begin
      mem[seg(ppp^):ofs(ppp^)+ebyte] :=
      mem[seg(ppp^):ofs(ppp^)+ebyte] and not b[ebit];
      mem[seg(ppp^):ofs(ppp^)+ebyte] :=
      mem[seg(ppp^):ofs(ppp^)+ebyte] or byte((byte(eval) * b[ebit]));
    end;
    inc(i);
    if i mod op = 0 then { Update progress }
    begin
      if cnt > 1 then
      begin
        dec(yl);
        NLwriteln('  Attempting hard recovery ('+wordval(i)+') '+
                  wordval(trunc(i/pred(pows[cnt])*100))+'%');
      end;
    end;
  until (CalculateChecksum(ppp,len)=chksum) or (i>pred(pows[cnt])) or (mrk in ['S','Q',#27]);
  if CalculateChecksum(ppp,len)=chksum then
  begin { Success - well, maybe... }
    lwriteln('The winning combination:');
    for i := 1 to cnt do
      if e_ind[i].eval <> original[i].eval then
        lwriteln('byte '+wordval(e_ind[i].ebyte)+
                 ' bit '+wordval(e_ind[i].ebit)+
                 ' flipped from '+wordval(integer(original[i].eval))+
                 ' to '+wordval(integer(e_ind[i].eval)));
  end;
  dec(yl);
  if mrk in ['Q',#27] then stop := true;
  if mrk in ['Q','S',#27] then
    Xwriteln('  Hard recovery interrupted.          ')
  else
    NLwriteln('  Attempting hard recovery 100%       ');
  hard_recovery := (CalculateChecksum(ppp,len)=chksum);
end;

Procedure Recover(fn:string; cnt:byte);
{ Try recovering file by going back to suspect bits and altering them }
var csum:pointer;
    len,fv:word;
    recsuc:boolean;
    fr:file; fb: fileb;
begin
  recsuc := false;
  getmem(csum,$FFFF);
  if longfilenames then fn:= shortname(fn);
  len := read_in(csum,fn);
  if easy_recovery(csum,cnt,len) then
    begin Xwriteln('  Easy recovery was successful - Program is probably OK.'); recsuc := true; end
  else
  begin
    Xwriteln('  Easy recovery was unsuccessful');
    if hard_recovery(csum,cnt,len) then
      begin
        Xwriteln('  Hard recovery was successful'); recsuc := true;
        if cnt > 4 then Xwriteln('  BUT Program is probably corrupted.');
      end
    else
      Xwriteln('  Hard recovery was unsuccessful');
  end;
  if recsuc then { write succesfully recovered file back to disk }
  begin
     if not openfile(fr,fn) then
       begin Xwriteln('Error: File in recovery not found.'); halt; end;
     reset(fr,1);
     move(csum^,mem[seg(csum^):ofs(csum^)+2],$FFFD);
     blockread(fr,csum^,2);
     close(fr);
     if create_file(fb,true,fn) > 0 then
     begin
       Xwriteln('Error: Could not write recovered file.');
       halt;
     end;
     rewrite(fb);
     for fv := 0 to len+1 do { write prg }
       write(fb, mem[seg(csum^):ofs(csum^)+fv]);
     close(fb);
  end;
  freemem(csum,$FFFF);
end;

Function Load_Program:boolean;
{ Loads a Turbo Tape program. }
{ Returns TRUE if succesful   }
var rbyte:byte;
    load_ok:boolean;
begin
  programcounter := 0; chksum_comp := 0; nlwriteln('');
  while (programcounter < program_size) and (not stop) and (not endoffile) do
  begin
    rbyte := read_byte;
    if (programcounter mod prgstep = 0) or (program_size-programcounter<prgstep) then
    begin
      if lastwascounter then dec(yl); { previous line on screen }
      NLwriteln('Saving '+MSDOSNAME+', bytes:'+wordval(succ(programcounter)));
      lastwascounter := true; { can go to prev. line }
    end;
    if programcounter < program_size then
    begin
      write(f2,rbyte); { Write prg byte to file }
      chksum_comp := chksum_comp XOR rbyte; { Update checksum calculation }
    end;
    inc(programcounter);
  end;
  err := 'User interrupt or unexpected end of file';
  load_ok := true;
  if programcounter >= program_size then
  begin
    chksum := read_byte; { Read stored checksum from end of TT file }
    if chksum <> chksum_comp then { Compare checksums }
    begin
      load_ok := false;
      err := 'Failed checksum';
    end;
  end;
  Xwriteln('');
  Load_Program := load_ok and (not endoffile) and (not stop);
end;

{ Main program }

begin
  textmode(259);
  logname := '**no log**';
  params; { Sort & filter params }
  if logname <> '**no log**' then
    if create_file(logfile,true,logname) > 0 then
    begin
      Xwriteln('Error: Could not create log file');
      halt;
    end
    else
      logfileopen := true;

  stop := false; set_cursor(32); { Hide cursor }

  if not openfile(sfile,name) then
  begin
    stop := true; err := 'sound file not found.';
    Xwriteln('Loading was unsuccessful.');
    Xwriteln('Error: '+err);
  end
  else
  begin
    Xwriteln(name);
    if upper(copy(name,length(name)-2,3)) = 'WAV' then
      if CheckWave(name) = 0 then halt; { If wave file then check type }
    fsize := fl;
    if not tresholdoverride then treshold := 0;
    assess(med_max,med_min,med_lo,med_hi,bit0max_vol,bit1max_vol);
    Xwriteln('Using volume treshold: '+wordval(treshold));
    if treshold <> 0 then
      Xwriteln('If loading persistently fails, try volume treshold 0.');
    if stereo then
      case channel of
        'B' : xwriteln('Using left and right stereo channels');
        'L' : xwriteln('Using left channel only');
        'R' : xwriteln('Using right channel only');
      end;
    if inverse=255 then xwriteln('Inversing waveform');
    GetDir(0,tempstr); Xwriteln('Current (save) directory:'+tempstr);
    if longfilenames then
      Xwriteln('Using long (Windows 95/98) filenames')
    else
      Xwriteln('Using short (DOS) filenames (use the -95 option for long WIN95 names)');
    if automatic then Xwriteln('Automatic mode');
    if logfileopen then Xwriteln('Output recorded to log: '+logname);
    med_med := (med_hi + med_lo) / 2;
    med_dif := (med_hi-med_lo)/2;
    discriminator := med_dif/3.4; { used if length 0/1 bit detection fails }
    Xwriteln('Press Q to quit anytime.');
    skip(sfile,start); d := start; { Go to beginning of file }
    Xwriteln('Processing file: '+name);

    while (not stop) and (not endoffile) do
    begin
      hdr_ok := false; serious_errors := false;
      textattr:=textattr or blink;Xwriteln('Seeking...');dec(yl);
      textattr:=textattr and not blink;NLwriteln('Seeking'); dec(yl);
      if Find_Sync(1) then { Look for header }
      begin
        hdr_ok := false; msdosname := '';
        Lwriteln('Header found at '+WordVal(d)+'.');
        if Read_header then { Check header is OK }
          if Find_Sync(0) then { Look for program }
          begin
            Lwriteln('Program found at '+WordVal(d)+'.');
            ecount := 0;
            if Load_Program then { Load program }
              begin XWriteln(Program_name+' - Loading ready - Checksum OK'); success := true; end
            else
              begin XWriteln(Program_name+' - ?Load error: '+err); success:=false;end;
            inc(extracted);
            if fileopen then { Did we write anything? }
            begin
              close(f2); fileopen := false;
            end;
            if (not success) and (not serious_errors) and
               (not stop) and (not endoffile) then
            begin { If load error and recovery seems possible then try... }
              Xwriteln('Attempting to recover...'+msdosname+' press S to skip.');
              ofp := filepos(sfile); close(sfile); oftot := ftot; { Close sound file for recovery }
              Recover(msdosname,ecount); { Do recovery }
              if not openfile(sfile,name) then halt; { Return to sound file }
              skip(sfile,ofp); ftot := ftot + oftot;
            end;
          end else Xwriteln(err) else Xwriteln(err);
      end;
      Xwriteln('-----------');
    end;
    show_end;
  end;
  Xwriteln('END. '+wordval(extracted)+' file(s) extracted or found. Press enter.');{ sound file end. }
  readln;set_cursor(0); { Make cursor visible }
  if logfileopen then close(logfile); { Close log file }
end.