UNIT Utils;
{ Copyright 1999 Sami Silaste   }
{ <samis@aethos.co.uk>
  <sami@semaphore.demon.co.uk>  }

interface

uses dos,crt,filesys,credit;

Procedure check_keys(var m:char);
Function upper (sss:string):string;
function clean(s:string):string;
Procedure Xwriteln(s:string);
Procedure Lwriteln(s:string);
Procedure NLwriteln(s:string);
Function WordVal (n:longint) : string;
Function warning(warning_at:longint; pc:word; bit:byte):string;
Procedure params;
Procedure set_cursor(cm:byte);
Procedure alive;
Procedure show_end;

var tempstr:string;
    fsize:longint;

const
    xl : byte = 1;
    yl : byte = 1;
    ymax : byte = 49;
    logfileopen:boolean=false;
    treshold:byte=1;
    tresholdoverride:boolean=false;
    Automatic:boolean=false;
    lastwascounter:boolean = false;
    key_read_interval : byte = 0;
    channel:char='B';
    inverse:byte=0;


implementation


Procedure check_keys(var m:char);
{ Read keyboard }
begin
  if key_read_interval=0 then { IO routines for this are very slow, so }
    if keypressed then        { only check keyboard every 256 passes.  }
    begin
      m:= readkey;
      if m = #0 then m:= readkey;
    end;
  inc(key_read_interval);
end;

Function upper (sss:string):string;
{ Convert string to Upper Case }
var ss:string;
    i:word;
begin
  ss := sss;
  if not (length(ss) > 0) then begin upper := ''; exit; end;
  for i := 1 to length(ss) do
    ss[i] := upcase(ss[i]);
  upper := ss;
end;

function clean(s:string):string;
{ Clean filename of non-ibm characters }
var r:word;
begin
  if length(s) > 0 then
  for r := 1 to length(s) do
    if not (upcase(s[r]) in ['A'..'Z','0'..'9','~','!']) then s[r] := '_';
  clean := s;
end;

Procedure Xwriteln(s:string); { Write text on screen / log }
{ Write message on screen }
var v:byte;
    v2:word;
begin
  gotoxy(xl,yl);write(s);
  inc(yl); if yl > ymax then
  begin
    yl := ymax;
    gotoxy(xl,yl+1);
    writeln;
  end else writeln;
  if (logfileopen) then
  begin
    for v2 := 1 to length(s) do
      write(logfile,byte(s[v2]));
    v:=13; write(logfile,v); v:=10; write(logfile,v);
  end;
  lastwascounter := false;
end;

Procedure Lwriteln(s:string); { Only log }
var v:byte;
    v2:word;
begin
  if automatic then Xwriteln(s) else { except when in auto-mode }
  if logfileopen then
  begin
    for v2 := 1 to length(s) do
      write(logfile,byte(s[v2]));
    v:=13; write(logfile,v); v:=10; write(logfile,v);
  end;
  lastwascounter := false;
end;

Procedure NLwriteln(s:string); { Only screen }
begin
  gotoxy(xl,yl);write(s);
  inc(yl); if yl > ymax then
  begin
    yl := ymax;
    gotoxy(xl,yl+1);
    writeln;
  end else writeln;
  lastwascounter := false;
end;

Function WordVal (n:longint) : string;
{ Write longint as string }
var s : string[10];
begin
  str(n,s);
  WordVal := s;
end;

Function warning(warning_at:longint; pc:word; bit:byte):string;
{ Construct warning message }
var ws:string;
begin
  ws := WordVal(warning_at);
  if pc >= 0 then
  begin
    ws := ws + '/Prog.pos:' + WordVal(pc) +' bit:'+wordval(bit);
  end;
  warning := ws;
end;


Procedure paramerror(myname:String);
begin
  writeln('Usage:'#10#10);
  writeln(myname,' [-Tn] [-C[l,r,b]] [-I] [-A]');
  writeln(copy('                  ',1,length(myname)),
          ' [-S:Save as name] [-L:Log file name] [-95] INPUTSOUNDFILE.WAV');
  writeln(#10'or'#10);
  writeln(myname,' -info for copyright info and disclaimer');
  writeln(#10#10#10'For example:'#10);
  writeln(myname,' -95 -A mytape.wav'#10);
  writeln('To process mytape.wav and use long (Windows95/98) filenames');
  writeln('and non-interactive (automatic) mode.'#10#10);
  writeln(myname,' -a -95 -S:pacman.prg mytape.wav'#10);
  writeln('To process mytape.wav using long filenames,');
  writeln('automatic mode and save first found program as pacman.prg.'#10#10);
  writeln(myname,' -T1 -Cl -I -95 -L:logfile.txt mytape.wav'#10);
  writeln('To process mytape.wav using threshold 1, only left stereo channel,');
  writeln('inverse waveform, use long filenames and write log to logfile.txt.');
  halt;
end;

Procedure params;
{ Process command line parameters }
type ttype = array[0..10] of string;
var i:word;
    myname:string;
    par : array[1..3] of string;
    para : ttype;
    parc,temp:byte;
    temp6:integer;

Function move_to_beginning_of_param_list (sss:string):string;
{ Prefix actual params with ! so they are at the top of list }
{ after sorting                                              }
var ss:string;
begin
  ss := sss;
  if not (length(ss) > 0) then
    begin move_to_beginning_of_param_list := ''; exit; end;
  if ss[1] = '-' then ss[1] := '!';
  move_to_beginning_of_param_list := ss;
end;

procedure quicksort(var p:ttype; ala,yla:integer);
{ Sort parameters in dictionary order }
var
  down,up : integer;
  kesk,apu: string;
begin
  down:=ala; up:=yla; kesk:=p[(ala+yla) DIV 2];
  repeat
    while p[down] < kesk do down := down + 1;
      while kesk < p[up] do up := up - 1;
        if down <= up then
        begin
          apu := p[down]; p[down] := p[up]; p[up] := apu;
          down := down + 1; up := up - 1;
        end;
  until down > up;
  if ala < up then quicksort(p,ala,up);
  if down<yla then quicksort(p,down,yla);
end;

begin { Begin processing params }
  FSplit(Paramstr(0), Di, Na, Ex);
  myname := Na; { Store name of Tapeload executable }
  for i := 1 to paramcount do
    para[i] := move_to_beginning_of_param_list(upper(paramstr(i)));
  quicksort(para, 1, paramcount);
  parc := 1; tempstr := ''; msdosname := ''; name := '';
  while parc < paramcount+1 do
  begin
    if para[parc] = '!INFO' then
    begin { Show credits screen }
      Credits;
      halt; { exit program }
    end;

    if (copy(para[parc],1,2) = '!T') then
    begin
      tempstr := copy(para[parc],3,length(para[parc])-2);
      temp := 255; val(tempstr,temp,temp6);
      if (temp6 = 0) and (temp<64) then
        begin treshold := temp; tresholdoverride := true; end
          else paramerror(myname);
    end
    else
    begin
        if (copy(para[parc],1,3) = '!S:') then
        begin
          msdosname := copy(para[parc],4,250);
          FSplit(msdosname, Di, Na, Ex);
          if Ex = '' then
            msdosname := msdosname + '.PRG';
        end
        else
          if (para[parc] = '!95') then
            longfilenames := true
          else
            if (copy(para[parc],1,3) = '!L:') then
            begin
              logname := copy(para[parc],4,250);
            end
            else
              if (copy(para[parc],1,2) = '!A') then
                Automatic := true
              else
              if (copy(para[parc],1,2) = '!I') then
                Inverse := 255
              else
              if (copy(para[parc],1,2) = '!C') then
              begin
                Channel := upcase(para[parc][3]);
                if not (channel in ['B','L','R']) then
                  paramerror(myname);
              end
              else
                if (name = '') then
                begin
                  name := para[parc];
                  FSplit(name, Di, Na, Ex);
                  if (length(name)-length(Di+Na+Ex) > 0) or
                   (longfilenames) then name := ShortName(name);
                end
                else paramerror(myname);
    end;
    inc(parc);
  end;
  if name = '' then
  begin
    Writeln('Error: No sound file name.');
    paramerror(myname);
  end;
end;

Procedure set_cursor(cm:byte);
{ Show / Hide / Alter cursor }
var regs:registers;
    ch: byte absolute $0040:$0085;
    a:byte;
begin
  a := ch;
  with regs do
  begin
    ah := 1;
    ch := cm or (a-1);
    cl := a;
    al := byte(lastmode);
  end;
  intr($10,regs); { interrupt $10 }
end;

Procedure alive;
{ Write progress indicator }
const cchar: array[0..5] of char = ('','','','','','');
      cursor:byte=0;
var test_clock : word absolute $40:$6c;
    progr:string[20];b:byte;
begin
  if test_clock = ccount then exit;
  ccount := test_clock;
  gotoxy(49,1);write('Start ');
  inc(cursor); if cursor > 5 then cursor := 0;
  progr := '';
  b := succ(trunc(ftot/fsize*20));if b > 20 then b := 20;
  progr[b] := cchar[cursor];
  write(progr);
  write(' End');
end;

Procedure show_end;
{ Shown at end of file }
begin
  gotoxy(49,1);write('Start  End');
end;

end.