//
//
// NAME:
//   abend.cpp
// TITLE:
//   Abnormal end an of application.
// FUNCTION:
//   This module administers abormal ends.  When a program within our
//   application detects an unrecoverable error, it calls our abend
//   procedure passing it information about the fatal error.  The abend
//   procedure displays a message conveying this error, tidies up any
//   loose ends (such as closing open files) and terminates.
//
// INTERFACE:
//   void abend(char *P, int L, int S, char *M, long V1, char *V2)
//     Abends a program, reporting the abend in program <P> line <L>.
//     ends reporting a fatal error serial number <S>.  The error is
//     described by <M>.  Optional parameters are an integer value V1
//     and a string V2.
// PREREQUISITES:
//   -
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (C) Copyright Brendan Jones,   1992-1999.
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   April 9, 1992.
//
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
// MODIFICATIONS:
//   NAME  MODNO  DATE       DESCRIPTION
//   bj        1   7/Sep/92  The abend() procedure was renamed abended().
//			     Instead, abend() is now a macro that calls
//			     abended(), first inserting the file and line
//			     number from where the abend() call is made.
//			     All the programmer need do now is provide the
//		             error serial number and message.
//   bj        1   29jan95   Added optional string and integer argument.
//   bj        2   14oct96   Windows version.
//
//
#include "implemen.h"

#ifdef COMMON_MSW
#include <windows.h>
#endif

#include "common.h"
#include "abend.h"


#ifdef COMMON_MSW16
#include <toolhelp.h>
#endif


static
boolean print_MIME_header = false;


void	abend_MIME_header(boolean Enable)
{
  print_MIME_header = Enable;
}



/*
 * PROCEDURE abend.
 *
 * Print a short error message describing the fatal error, then shut
 * down our application tidying up any loose ends.  Open files are
 * closed automatically with the exit call.  There are no other loose
 * ends at the moment, but later this could involve returning the display
 * from graphics mode to text mode and so on.
 *
 */
void abend(
  const char   *program,	// Name of program that detected error
  int		line,           // Line number on which abend occured
  int		serial,         // Unique number assigned to this error
  const char   *message,	// Message
  long		value,          // Optional numeric value
  const char   *string)		// Optional string value
{
  #ifdef COMMON_MSW32
  LPVOID lpMsgBuf;

  FormatMessage( 
    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
    NULL,
    GetLastError(),
    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
    (LPTSTR) &lpMsgBuf,
    0,
    NULL);
  #endif


  #if defined(COMMON_MSW) && !defined(_CONSOLE)

  static char token[10];
  static char caption[40];
  strcpy(caption, program);
  strcat(caption, ":");
  strcat(caption, ltoa(line, token, 10));

  char blurb[2048];
  sprintf(blurb, "%s %s\n%ld %s",
    message != NULL ? message : "<NULL>",
    #ifdef COMMON_MSW32
    lpMsgBuf,
    #else
    "",
    #endif
    value,
    string != NULL ? string : "");

  MessageBox(NULL, blurb, caption, MB_SYSTEMMODAL);

//TerminateApp(NULL, UAE_BOX);
//TerminateApp(NULL, NO_UAE_BOX);     // Only works on Win16

  exit(8);

  /*
  static char caption[200];
  static char msg[512];
  static char token[32];

  strcpy(caption, "Abend ");
  strcat(caption, program);
  strcat(caption, ":");
  strcat(caption, ltoa(line, token, 10));

  strcpy(msg, message);
  if (value)
    {
    strcat(msg, "\nvalue=");
    strcat(msg, ltoa(value, token, 10));
    }
  if (string)
    {
    strcat(msg, "\n\"");
    strcat(msg, string);
    strcat(msg, "\"");
    }

  if (MessageBox(NULL, msg, caption, MB_ICONHAND|MB_TASKMODAL) == 0)
    TerminateApp(NULL, UAE_BOX);
  else
    TerminateApp(NULL, NO_UAE_BOX);

  exit(8);
  */
  #endif


  #ifdef COMMON_DOS
  /*
  // Force a screen clear
  asm {
    mov ah, 0x00        // AH = Set BIOS display mode
    mov al, 0x03        // AL = Mode Number (VGA Mode 3 hex)
    int 0x10            // Call BIOS
  };
  */
  #endif

  if (print_MIME_header)
  {
  cout  << "Content-type: text/plain\n\n"
	<< "Forced screen clear to report:\n\nAbend.\n\n"
	<< "  Reported by " << program << " at " << line << nl
	<< "  Error Serial Number: " << serial << nl
	<< "  Message: " << message << nl << flush;

  if (value != 0)
    cout << "    Error Value: " << value << nl;
  if (string != 0)
    cout << "    Error String: \"" << string << "\"\n";

  #ifdef COMMON_MSW32
  if (lpMsgBuf != NULL)
    cout << "Alternate System Error Message: " << (const char *)lpMsgBuf << endl;
  #endif
  }

  cerr	<< "\n\nAbend.\n\n"
	<< "  Reported by " << program << " at " << line << nl
	<< "  Error Serial Number: " << serial << nl
	<< "  Message: " << message << nl;

  if (value != 0)
    cerr << "    Error Value: " << value << nl;
  if (string != 0)
    cerr << "    Error String: \"" << string << "\"\n";

  cerr << "Application terminated.\n";
  perror("System Error Message");

  #ifdef COMMON_MSW32
  if (lpMsgBuf != NULL)
    {
    cerr << "Alternate System Error Message: " << (const char *)lpMsgBuf << endl;
    LocalFree(lpMsgBuf);
    }
  #endif

  cerr	<< flush;
  cout	<< flush;

  // COUT: for debugging only. [bj 09oct2006] assert(false);


  exit(8);
}
