//
// NAME:
// abend.h
// TITLE:
//   Common: Abend. (COMMON2)
// FUNCTION:
//   Terminates program execution, reporting an error.  An optional
//   number and/or string with error information can also be included.
//   
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1995-2006.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   April 9, 1992.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//   bj    1    29jan95	 Added fields for additional error information.
//			 Only enabled WHERE macro under COMMON1.
//
//
#ifndef ABEND_H
#define ABEND_H
#include "common.h"

// Report an error and terminate.
//
void abend(
	const char     *Program,	  // The source file name
	int		Line,		  // The line in the source file
	int		Serial,		  // Optional unique error code
	const char     *Message,	  // Error Description
	long		Value	= 0,	  // Optional number
	const char     *String	= NULL);  // Optional string


// Instruct abend to print a MIME header when it abends.
//
void abend_MIME_header(boolean	Enable);



// These macros expand to report where the error occured in the source.
#ifndef WHEREFILE
#define WHEREFILE       __FILE__
#endif
#ifndef WHERE
#define WHERE           WHEREFILE, __LINE__
#endif
#define WHERE0          WHERE, 0
#define	BAD_CASE	abend(WHERE0, "Bad case");
#define	NOT_YET 	abend(WHERE0, "Not yet");
#endif
