//
// NAME:
//   btree.h
// TITLE:
//   B-Tree. (Templates)
// FUNCTION:
//   -
//   -
//   -
// METHODS:
//   -
// PREREQUISITES:
//   Common.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1997-2006.  All Rights Reserved.
// SECURITY:
//   Unclassified.
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   April 13, 1997.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//   bj    1    18aug97  Added pragmas to support GNU C++.
//
//
#ifndef BTREE_H
#define BTREE_H
#ifdef	__GNUC__
#pragma interface
#endif
#include "common.h"
#include "rays.h"




template <class Element_type>
class Btree_node
{
  public:
    Element_type	*before,
			*after;

  public:
    Btree_node(void)
      {
      before = after = NULL;
      }

    #ifdef COMMON_BC
   ~Btree_node(void);
    #else
   ~Btree_node(void)
      {
      if (before)
	delete before;

      if (after)
	delete after;
      }
    #endif


    void print_recursive(ostream& Str, const boolean Newline) const;
};




template <class Element_type>
void Btree_node<Element_type>::print_recursive(
	ostream& Str, const boolean Newline) const
  {
  if (before != NULL)
    ((Btree_node<Element_type> *)before)->print_recursive(Str, Newline);

  Str << (Element_type *)this;

  if (Newline)
    Str << nl;

  if (after != NULL)
    ((Btree_node<Element_type> *)before)->print_recursive(Str, Newline);

  };




#ifdef COMMON_BC
template <class Element_type>
Btree_node<Element_type>::~Btree_node(void)
{
  if (before)
    delete before;

  if (after)
    delete after;
};
#endif




template <class Element_type, class Key_type>
class Btree
{
  protected:
    Element_type	*root;

  public:
    Btree(void)
      {
      root = NULL;
      }

   ~Btree(void)
     {
     if (root)
       delete root;
     }


    Element_type *get(const Key_type&	     Key);
    const Element_type *get(const Key_type&  Key) const;

    boolean insert(Element_type  	*Data);
    boolean remove(const Key_type&  	 Key);

    Element_type *get_root(void) {return root;}
    const Element_type *get_root(void) const {return root;}

    boolean empty(void) const {return root == NULL;}

    void purge(void) {if (root) delete root; root = NULL;}

    void print_recursive(ostream& Str, const boolean Newline) const
      {
      if (root)
	root->print_recursive(Str, Newline);
      }
};




template <class Element_type, class Key_type>
const Element_type
  *Btree<Element_type, Key_type>::get(const Key_type& Key) const
{
  Element_type const *N = root;


  while (N != NULL)
    Select(*N > Key)
	N = N->before;

      when(*N < Key)
	N = N->after;

      otherwise
	return N;
    endsel


  return NULL;
}




template <class Element_type, class Key_type>
Element_type *Btree<Element_type, Key_type>::get(const Key_type& Key)
{
  Element_type *N = root;


  while (N != NULL)
    Select(*N > Key)
	N = N->before;

      when(*N < Key)
	N = N->after;

      otherwise
	return N;
    endsel


  return NULL;
}




template <class Element_type, class Key_type>
boolean Btree<Element_type, Key_type>::insert(Element_type *Data)
{
  Element_type	 *N		= root,
		**last_ptr	= &root;


  while (N != NULL)
    Select(*Data < N->key())
	last_ptr = &N->before;
	N = *last_ptr;

      when(*Data > N->key())
	last_ptr = &N->after;
	N = *last_ptr;

      otherwise
	assert(*Data == N->key());
	return false;
    endsel


  *last_ptr = Data;
  return true;
};




template <class Element_type, class Key_type>
boolean	Btree<Element_type, Key_type>::remove(const Key_type& Key)
{
  Element_type	 *N		= root,
		**last_ptr	= &root,
		 *before_tail;


  while (N != NULL)
    Select(*N > Key)
	last_ptr = &N->before;
	N = *last_ptr;

      when(*N < Key)
	last_ptr = &N->after;
	N = *last_ptr;

      otherwise
	break;
    endsel


  if (N != NULL)
    {
    if (N->before == NULL)
      *last_ptr = N->after;
    else
      {
      before_tail = N->before;

      while (before_tail != NULL)
	if (before_tail->after != NULL)
	  before_tail = before_tail->after;
	else
	  break;

      assert(before_tail->after == NULL);

      *last_ptr		  = N->before;
      before_tail->after  = N->after;
      }

    N->before = N->after = NULL;

    assert(N);
    delete N;

    return true;
    }
  else
    return false;

};
#endif
