//
// NAME:
//   btreenod.h
// TITLE:
//   Btree: Nodes (Templates)
// FUNCTION:
//   -
//   -
//   -
// OBJECTS:
//   -
// METHODS:
//   -
// PREREQUISITES:
//   Common: Btree.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1997-2006.  All Rights Reserved.
// SECURITY:
//   Unclassified.
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   December 10, 1997.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#ifndef BTREENOD_H
#define BTREENOD_H
#include "common.h"
#include "btree.h"


template <class Key_type>
class Btree_node_id
{
  public:
    Key_type	id;


  public:
    //
    // GROUP Btree methods.
    //
    // These methods are used to store this object in a btree.
    //
    boolean operator <  (const Key_type Key) const {return id <  Key;}
    boolean operator >  (const Key_type Key) const {return id >  Key;}
    boolean operator == (const Key_type Key) const {return id == Key;}
    const   Key_type key(void) 		     const {return id;}
};
#endif
