//
// NAME:
//   co_keys.h
// TITLE:
//   Common Keys.
// FUNCTION:
//   -
//   -
//   -
// OBJECTS:
//   -
// METHODS:
//   -
// PREREQUISITES:
//   Common.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1997-2006.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   May 20, 1997.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#ifndef CO_KEYS_H
#define CO_KEYS_H
#include "btree.h"




class common_Key_node
	: public Btree_node<common_Key_node>
{
  public:
    long	 id;
    char	*name;

  public:
    common_Key_node(const char *Name, long Id)
      {
      mcheck(name = strdup(Name));
      id = Id;
      }

   ~common_Key_node(void)
      {
      if (name)
	free(name);
      }

    boolean operator < (const char *Name) const
      {return strcmp(name, Name) < 0;}

    boolean operator > (const char *Name) const
      {return strcmp(name, Name) > 0;}

    boolean operator == (const char *Name) const
      {return strcmp(name, Name) == 0;}

    char *key(void) const {return name;}

//    void print_recursive(ostream& Str) {};
};




class common_Keys
	: public Btree<common_Key_node, char *>
{
  public:
    boolean insert(const char *Name, long Id)
      {
      common_Key_node *N;

      mcheck(N = new common_Key_node(Name, Id));

      return Btree<common_Key_node, char *>::insert(N);
      }


    long get(const char *Name)
      {
      common_Key_node *N = Btree<common_Key_node, char *>::get((char *)Name);

      if (N)
	return N->id;
      else
	return -1;
      }
};
#endif
