//
// NAME:
//   crc.h
// TITLE:
//   Common: Cyclic Redundancy Check.
// FUNCTION:
//   This module creates 16 bit cyclic redundancy checksums from
//   byte data streams.
//
// OBJECTS:
//   crc16      The 16 bit checksum.
//   CRC16      The object that finds the checksums.
//
// METHODS:
//   open       Start processing.
//   process    Process each byte in the data stream.
//   close      End processing, returning the calculated CRC.
// PREREQUISITES:
//   -
//
// AUTHOR:
//   Anonymous, from CRC.ZIP on the Walnut Creek 1992 Source CD-ROM.
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   Conversion (c) Copyright Brendan Jones, 1995.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   August 20, 1995.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE       DESCRIPTION
//
//
#ifndef CRC16_H
#define CRC16_H
#include "common.h"




// TYPE crc16.
//
// This type holds a 16 bit checksum.
//
//
typedef unsigned short crc16;



// OBJECT CRC16.
//
// This object creates 16 bit checksums from a byte data stream.
//
//
class CRC16 {
  protected:
    //
    // The 16 bit cyclic redundancy checksum.
    //
    crc16       crc;


  public:
    // PROCEDURE open.
    //
    // Prepare to process a fresh stream of byte data, from which a
    // checksum will be generated.
    //
    void open(void);


    // PROCEDURE process.
    //
    // This procedure processes the next byte in the byte data stream
    // for which the CRC is to be generated.
    //
    void process(byte crc_char);


    // FUNCTION close.
    //
    // This function returns the crc.
    //
    crc16 close(void);
};
#endif
