//
// NAME:
//   filehead.h
// TITLE:
//   Common: File Header.
// FUNCTION:
//   -
//   -
//   -
// OBJECTS:
//   common_File_header.
// METHODS:
//   -
// PREREQUISITES:
//   -
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// COPYRIGHT:
//   (c) Copyright Brendan Jones, 1995-2006.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   November 16, 1995.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//   bj    1    8apr96   Created from <dwm_file.h>
//
//
#ifndef FILEHEAD_H
#define FILEHEAD_H
#include "security.h"

#define CO_MAGIC        0x27a89391

class co_File_header {
  public:
    char        copyright[KESTREL_COPYRIGHT_SIZE];

#ifdef GCC
    byte        ready;
#else
    byte        ready   :  1;
    byte        filler  :  7;
#endif
    co_security security;

    ulong       co_magic;
    ulong       magic;
    ulong       version;

  public:
    co_File_header(const char *Copyright = KESTREL_COPYRIGHT)
      {
      memcpy(copyright, Copyright, KESTREL_COPYRIGHT_SIZE);
      security  = co_security_none;
      co_magic  = CO_MAGIC;
      ready     = true;
#ifndef GCC
      filler    = 0;
#endif
      }
};
#endif
