/* Martin Haring <xxxxxxxx@xxxxxx.xxxxxx.xx> || use gcc to play mastermind */
/* converted from .sig to readable C for Quetzalcoatl by Harry Dodgson     */

byte i,j;					// loop counters
byte e,p;					// correct counts
byte a[4];					// peg array
byte b;						// input character

byte rand(void) {
	static byte offset;

	if (offset == 0)
		offset = memory[0xdf];		// pick something that changes
	offset = memory[0xf100+offset];		// get a random byte from ROM
	return memory[offset];
}

void main(void) {

	cout << "Mastermind Game" << endl;
	// srand(time(0));
	for (i=0;i<4;i++){			// 4 pegs
		a[i]=rand() and 7;		// get a random number (8 possibles)
		for (j=0;j<i;j++)		// no duplicates
			if (a[i]==a[j]) i--;	// if match any previous, do this one again
	}
	cout << "A B C D GP\n";			// print header

	ioctl(cin,ioctl_set,ioctl_raw_wait);	// set char mode
	do {
		e=0;
		p=0;
		for (i=0;i<4;i++) {		// get 4 entries
			b=getch() and 7;
			cout << " ";
			if (b==a[i]) p++;	// see if exact match
			for (j=0;j<4;j++)	// see if not-exact match
				if (b==a[j]) e++;
		}
		//system("stty cooked");
		//printf("%d%d\n",e-p,p);
		put(e-p);			// prints matches
		put(p);
		cout << endl;
	} while (p<4);				// loop until it's right
}


