//
// NAME:
//   im_pcx.h
// TITLE:
//   Image: PCX Object.
// FUNCTION:
//   -
//   -
//   -
// OBJECTS:
//   im_PCX		A PCX Image Object.
// METHODS:
//   -
// PREREQUISITES:
//   -
//
// AUTHOR:
//   Kent J. Quirk, from a Dr. Dobbs tutorial.
//   C++ Conversion for Image Library by Brendan Jones.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
//
// RIGHTS:
//   (c) Copyright Kent J. Quirk, 1994.  All Rights Reserved.
//   Conversion (c) Copyright Brendan Jones, 1994.  All Rights Reserved.
// SECURITY:
//   Unclassified.  For Public Release.
// DATE:
//   November 30, 1994.
//
// MODIFICATIONS:
//   NAME  MOD  DATE       DESCRIPTION
//
//
#ifndef IM_PCX_H
#define IM_PCX_H
#include "common.h"


// CONSTANTS
//
// These two definitions are used to decompress data in the PCX file.
// (The compressed count byte has the top two bits set).
//
//
#define PCX_COMPRESSED 0xC0
#define PCX_MASK 0x3F


// OBJECT Image PCX Header.
//
// This object appears at the head of a PCX file.  It contains the
// specifications for the image that follows.
//
//
class im_PCX_header {
  public:
    byte pcx_id;                        /* Always 0x0A for PCX files */
    byte version;                       /* Version of the PCX format */
    byte encoding;                      /* 1 = RLE (RLL) compression */
    byte bpp;                           /* Number of bits per pixel */
    word upleftx, uplefty;              /* position of upper left corner */
    word lorightx, lorighty;            /* lower right corner (inclusive) */
    word display_xres, display_yres;    /* resolution in dpi of display */
    byte palette[48];                   /* palette data if it fits */
    byte reserved;
    byte nplanes;                       /* number of bit planes of data */
    word bytesperline;                  /* # bytes in an uncompressed line */
    word palletteinfo;
    byte reserved2[58];
};


class im_PCX {
  public:
    im_PCX_header	header;		// General information about image.
    byte	       *line;		// Current line.
    word		lines;		// Lines remaining to be read.

    // Pointer to palette array.
    byte	       *palette;
    boolean		static_palette;

  protected:
    // We read the file contents from this stream.
    FILE	       *pcx_f;

  public:
    im_PCX(char *filename);
   ~im_PCX(void);

    // Read each line of the image, one by one, into buffer.
    // Returns true iff EOF.
    boolean next_line(void);

    friend ostream& operator << (ostream& str, im_PCX& PCX);

    word columns(void)
      {return header.lorightx - header.upleftx + 1;}

    word rows(void)
      {return header.lorighty - header.uplefty + 1;}

  protected:
    // These are Kent Quirk's original routines.  Rather than rewrite
    // them we call them from the public object methods.
    //

    // Reads the header from file <f> into buffer <hdr>.  Must be at
    // start of file when this is called.
    //
    im_PCX_header *pcx_read_header(im_PCX_header *hdr, FILE *f);

    // Create a buffer large enough to hold a full line from the image.
    //
    byte *pcx_alloc_line(im_PCX_header *hdr);

    // Read the next line into buffer <line>.
    //
    byte *pcx_next_line(im_PCX_header *hdr, byte *line, FILE *f);

    // Print information about the file (the header information)
    // on stream <f>.
    //
    void pcx_print_header(im_PCX_header *hdr, FILE *f);
};
#endif
