//
// NAME:
//   implemen.h
// TITLE:
//   Implementation.
// FUNCTION:
//   This header declares macros indicating the target system
//   that the application is being compiled for.
// MACROS:
//   COMMON_LOW_ENDIAN	Target computer is low endian. (The way God intended)
//			Also COMMON_LITTLE_ENDIAN
//			Also COMMON_ORDER_DCBA
//   COMMON_BIG_ENDIAN	Target computer is big endian. (The way Cthulu likes it).
//   			Also COMMON_HIGH_ENDIAN
//			Also COMMON_ORDER_ABCD
//   COMMON_VAX_ENDIAN	Target computer is vax endian. (Bizzareo)
//			Also COMMON_ORDER_BADC
//   COMMON_MSW		Target is MS Windows.
//   COMMON_MSW16	Target is MS Windows 16-bit.
//   COMMON_MSW32	Target is MS Windows 32-bit.
//   COMMON_DOS		Target is DOS.
//   COMMON_UNIX	Target is UNIX.
//   COMMON_POSIX	Target is a POSIX compliant system.
//   COMMON_OS2		Target is OS/2.  (TODO).
//   COMMON_INTEL86	Target is an Intel *86 or *88 processor.
//   COMMON_PENTIUM	Target is an Intel Pentium processor.
//			(You can declare this yourself if you know your target
//			is a Pentium, since under old compilers there may be
//			no way to otherwise detect this.)
//   COMMON_VAX		Target is a VAX.
//   COMMON_SUN		Target is a SUN.
//   COMMON_SGI		Target is an SGI.
//   COMMON_MSVC	Compiler is Microsoft Visual C++.
//   COMMON_BC		Compiler is Borland C++.
//   COMMON_GNU	        Compiler is GNU G++.  (TODO).
//   FARPTR		An alias for "far" if that is an appropriate pointer
//			type for the target OS.  If it isn't (eg. for most flat
//		        address mode targets) it's aliased to nothing.
//   COMMON_NOREACHED   Compiler doesn't support any sort of NOTREACHED hint,
//			yet insists all functions must return a value.
//			If true wherever you have a NOTREACHED follow it by
//			a dummy return (It will never be called but will
//			compile correctly).
//   FIXEND		If defined will nake .OBJ files comaptible between Intel
//			and SPARC CPUs.  The final .BIN files do not require this
//			except when using the 2 byte VIC/C-64 header.
//   NDEBUG		turns off bounds checking in rays.h
//
// PREREQUISITES:
//   Common.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1997-2006.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   February 2, 1997.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//   bj    1     8jan98  Added macros to determine byte order in Linux
//			 and other platforms.  Added VAX endian.
//
//
#ifndef IMPLEMEN_H
#define IMPLEMEN_H
// Determine Operating System.
//
#ifdef  _WIN32
#define	COMMON_MSW32
#define	COMMON_MSW
#define	FARPTR
#elif	defined(_Windows)
#define	COMMON_MSW16
#define	COMMON_MSW
#define	FARPTR		far
#elif	defined(__MSDOS__)
#define	COMMON_DOS
#define	FARPTR		far
#elif	defined(__unix__)
#define	COMMON_UNIX
#define	COMMON_POSIX
#define	FARPTR
#endif
// Determine CPU.
//
#if	_M_IX86 == 500  || defined(__i586__)
#define	COMMON_PENTIUM
#define	COMMON_INTEL86
#elif	defined(_M_IX86) || defined(__BORLANDC__) || defined(__i386__)
#define	COMMON_INTEL86
#elif   defined(__mc68000__)
#define	COMMON_MC68000
#elif	defined(__vax__)
#define	COMMON_VAX
#elif	defined(__sun__)
#define	COMMON_SUN
#define GCC
#define COMMON_NOREACHED
#define NO_WARNINGS
#elif	defined(sgi)
#define	COMMON_SGI
#endif
// Determine the Endian based on the CPU.
//
#ifdef	COMMON_INTEL86
#define	COMMON_LOW_ENDIAN
#define	COMMON_LITTLE_ENDIAN
#define	COMMON_ORDER_DCBA
#elif	defined(__vax__)
#define	COMMON_VAX_ENDIAN
#define	COMMON_ORDER_BADC
#else
#define	COMMON_BIG_ENDIAN
#define	COMMON_HIGH_ENDIAN
#define	COMMON_ORDER_ABCD
#endif
// Determine Compiler.
//
#ifdef	_MSC_VER
#define	COMMON_MSVC
#elif	defined(DJGPP)
#define NDEBUG
#define GCC
#define NO_WARNINGS
#define COMMON_NOREACHED
#elif	defined(__BORLANDC__)
#define	COMMON_BC
#elif	defined(__GNUC__)
#define	COMMON_GNUC
#endif
// Compiler Quirks.
//
#ifdef	COMMON_MSVC
#define	COMMON_NOREACHED
#endif
#ifdef	LINUX
#define GCC
#define COMMON_NOREACHED
#define NO_WARNINGS
#define NEWCPP
#endif
#endif
