// make 7800 rom from Quetzalcoatl C ouput + header file
//
// Current reductions in generality
// 1) hdr file has 128 byte .A78 header + 4K of data loading at $C000
// 2) C output file loads above hdr file at $D000
//

#define UNIX

#ifdef UNIX
#include <malloc.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <strings.h>
#include <malloc.h>
#include <sys/ddi.h>
#include <sys/stat.h>
#else
#include <unixio.h>
#include <stat.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#ifndef O_BINARY
#define O_BINARY 0
#endif
#ifndef O_RDONLY
#define O_RDONLY 0
#endif
#ifndef O_WRONLY
#define O_WRONLY 1
#endif


unsigned long	f_size;		// file size
unsigned long	r_len;
int		in_hand, out_hand;

int main(int argc, char *argv[]) {

int		in_hand, out_hand;
struct stat	*fbuf = malloc(sizeof(struct stat));
char		*inbyte;
char		vectors[8] = { 0xff, 0xc7, 0,0,0,0,0,0 };
char		*fill;

	if (argc != 4) {
		printf("Usage: make7800 <header file> <program file> <output file>\n");
		exit (-1);
	}

// open output file
#ifndef UNIX
	out_hand = creat(argv[3], 0666);
	close(out_hand);
	out_hand = open(argv[3], O_WRONLY | O_BINARY);
#else
	out_hand = open(argv[3], O_WRONLY | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
#endif

// open hdr file
	in_hand = open(argv[1], O_RDONLY | O_BINARY);
#ifndef UNIX
	stat(argv[1], fbuf);
#else
	fstat(in_hand, fbuf);
#endif
	f_size = fbuf->st_size;
	inbyte = malloc(f_size+1);
        r_len = read(in_hand, inbyte, f_size);
	printf("Read %ld bytes from header\n", r_len);
// copy to output file

	write(out_hand, inbyte, r_len);
	free(inbyte);
	close(in_hand);

// open C output file
	in_hand = open(argv[2], O_RDONLY | O_BINARY);
#ifndef UNIX
	stat(argv[2], fbuf);
#else
	fstat(in_hand, fbuf);
#endif
	f_size = fbuf->st_size;
	inbyte = malloc(f_size+1);
        r_len = read(in_hand, inbyte, f_size);
	printf("Read %ld bytes from program\n", r_len);

// write from +4 bytes to output
	write(out_hand, &inbyte[4], r_len-4);
	close(in_hand);

// write $FF up to last 8 bytes
	f_size = (0xfff8 - 0xd000 - r_len) + 4;
	fill = malloc(f_size);
	memset(fill, 0xff, f_size);
	write(out_hand, fill, f_size);
	printf("Writing %ld fill bytes\n", f_size);

// write c[0f,10]
// write c[05,06]
// write c[0d,0e]
	vectors[2] = inbyte[0x0f];
	vectors[3] = inbyte[0x10];
	vectors[4] = inbyte[0x05];
	vectors[5] = inbyte[0x06];
	vectors[6] = inbyte[0x0d];
	vectors[7] = inbyte[0x0e];
	write(out_hand, &vectors[0], 8);
	free (inbyte);

// close output file
	close(out_hand);
	return 0;
}

// EOF
