// Tests for the Quetzal... compiler (mostly syntax)


#define WSTAT 0x40

#include "shift.h"

bool sub1(void);	// external subroutines

int sub2(int a, int b);

// ERR cannot use same parameter names for external routines
// int sub3(int a);


byte	k;
char	l;
uint	h = 10;
uint	i = 20;
int	j;
bool	b;
char	msg1[] = "Set at compile time message.  \r\n";
char    msg2[] = "Copy went okay\r\n";
char	*m;
int	*n;
int	very_long_name_one = 171, very_long_name_two = 2019;
int	aa = 171, bb = 2019;
uint	uaa = 2019;
int	iee;
int	irr;
bool	run = true;
byte	ll, hh;
uint	kk, jj;
int	pp, ii, nn;
int	mm;
byte	tn = 10;
int	wt1 = 5;
char	chv = 'A';
char	chw;
byte	ss;
uint	pt;

// only global - goes into data segment
byte	fun[5] = { 1, 2, 3, 4, 5 };

byte	a, x;
int	ia, ix, iy;

// compiler "not supported" error
// uint *p;

byte	*r = WSTAT;
byte	powers[8] = { 1,2,4,8,16,32,64,128 };
uint	bigger[6] = { 1000, 2000, 3000, 4000, 5000, 6000 };

// do not change the order of declarations for these four variables
int	*ptp;
int	ptk[3] = { 780, 781, 782 };
byte	*ptp2;
byte	ptk2[3] = { 100, 150, 200 };

//   these don't work - but it would be nice if they did
//   for those times that data can stay in ROM
// const char msg2[] = " Message stays in ROM space\r\n";
// const byte list[9] = { 0,1,2,3,4,5,6,7,8 };

// large array test
byte	large_array[550];

/* possible array speedups
1. arrays smaller than 256 bytes can just load CL,CH and set Y
*/

enum direction {
E, NE, N, NW, W, SW, S, SE
} tdir, mdir;


// this is a compile-time assignment to a label, not data RAM
const byte Wsync = 0x24;


const int cls = (int) Wsync;

// pointer pass by reference test
int ptrtst(int *ccp) {

	*ccp = *ccp + 1000;

	return *ccp + 50;
}

void results(bool ra) {

	if (ra)
		cout << " Success";
	else
		cout << " FAILURE!";
}

// don't reuse variable names here either
// it doesn't error, but makes changes to first one
void vartst(void) {

	static byte pt;

	pt = 57;
}

uint div3(uint dd) {

	static uint th;
	static uint tv;

// cout << " div3 rx= " << dd << endl;

	th = 3;
	tv = dd / th;
	return tv;
}

// don't reuse variable names here either
// it doesn't error, but will take the first definition
uint test_subroutine(uint t1a, uint t1b, uint t1c, uint t1d, uint t1e, uint t1f, uint t1g, uint t1h) {

	auto uint t1k;
	auto uint t1l;

	t1k = 3000;
	t1l = 1000;

	return t1a+t1b+t1c+t1d+t1e+t1f+t1g+t1h+t1k-t1l;
}

void divide(void) {

	static int ia, ib, ic;
	static uint ua, ub, uc;
	static byte ba, bb, bc;
	static char cb;
	static uint ur;

	// int/char int/byte works
	ia = 210;
	ib = 30;
	ic = ia / ib;
	results(ic == 7);

	// large uint/char works
	ua = 2800;
	cb = 50;
	uc = ua / cb;
	results(uc==56);

	// small uint/char works
	ua = 250;
	cb = 50;
	uc = ua / cb;
	results(uc==5);
//	-------------------------
	// byte/byte works
	ba = 250;
	bb = 10;
	bc = ba/bb;
	results(bc==25);

	// uint/256 works (special case)
	ua = 0x7800;
	ib = 256;
	uc = ua/ib;
	results(uc==0x78);

	// uint/256 constant
	ua = 0x8800;
	uc = ua/256;
	results(uc==0x88);
	cout << endl;

	// constant/256 constant
	uc = 0x9800/256;
	results(uc==0x98);

	// uint/byte works
	ua = 2600;
	bb = 35;
	uc = ua / bb;
	results(uc==74);

	// uint/small int works
	ua = 9000;
	ib = 30;
	uc = ua/ib;
	results(uc==300);

	// uint/small uint works
	ua = 9000;
	ub = 30;
	uc = ua/ub;
	results(uc==300);

	// uint/large int works
	ua = 19000;
	ib = 280;
	uc = ua/ib;
	ur = getrmdr();
	results(uc==67 and ur==240);

	// uint/large uint works
	ua = 10000;
	ub = 500;
	uc = ua/ub;
	results(uc==20);
}

void pokes(void) {

	static uint mem45;
	static uint mem46;
	static uint cc;

	mem45 = 0x0080;
	mem46 = 0x0081;

	memory[0x0008] = 0x13;
	memory[0x0009] = 0x13;
	cc = 8;
	jj = memory.int[cc];
	results(jj == 4883);

	cc = 300;
	// these work
	memory.byte[mem45] = 1;
	memory.byte[mem46] = 1;

	// this is okay - reads both bytes
	mm = memory.int[mem45];
	results(mm == 257);

	// these work now
	mm = memory.int[0x4500];
	jj = memory.int[0x0008];

	// this does work
	memory.int[mem45] = memory.int[mem45] + cc;
	results(memory.int[mem45] == 557);

	// this works too
	memory.byte[0x30] = 10;
	memory.byte[0x30] = memory.byte[0x30] + 5;
	results(memory[0x30] == 15);

	// this works okay (byte -> byte)
	hh = memory.byte[pp];

	// so does this (byte -> int)
	ii = memory.byte[pp];

	// this reads a word (int -> int)
	ii = memory.int[kk];
	results(ii == 11);

	// this works
	memory.int[kk] = 3579;
	results(h == 3579);

	// this doesn't work
	ii = memory.int[cc] + memory.int[mem45];
	results(ii == 5440);
	cout << endl;

}

void ptrtest2(void) {

	auto uint ptr_addr1;

	// pointer fixup code - harmless when fixed
	ptr_addr1 = hl(&ptk) - 2;
	mem.int[ptr_addr1] = ptr_addr1;

	// this one works
	// int pointer to int arry
	*ptp = &ptk;
	ptp[0] = 4700;
	ptp[2] = 2000;
	results(ptk[0] == 4700 and ptk[2] == 2000);

	// I think real C takes into account the data size, but this works
	ptp = ptp + 2;
	results(*ptp == 781);

	// this one is a tiny bit more efficent (plus it works)
	// byte pointer to byte array
	ptr_addr1 = hl(&ptk2) - 2;
	mem.int[ptr_addr1] = ptr_addr1 + 2;

	ptp2[1] = 50;
	ptp2[0] = 129;
	results(ptk2[0] == 129 and ptk2[1] == 50);

	// this works
	ptp2 = ptp2 + 2;
	results(*ptp2 == 200);

	// this doesn't work at all
	// byte pointer to int array
//	mem.int[ptr_addr1] = ptr_addr1;
//	*ptp2 = &ptk;			// this line fails to execute - pokes byte
}

void multiply(void) {

	static uint	mui1, mui2, mui3;
	static int	mii1, mii2, mii3;
	static byte	mb1, mb2, mb3;
	static char	mc1, mc2, mc3;
	static bool	prt_char;

	mui1 = 400;
	mui2 = 150;
	mui3 = mui1 * mui2;
	results(mui3 == 60000);

	mui3 = mui2 * 256;
	results(mui3 == 38400);

	mii1 = 125;
	mii2 = 75;
	mii3 = mii1 * mii2;
	results (mii3 == 9375);

	mii2 = -90;
	mii3 = mii1 * mii2;
	results (mii3 == -11250);

	mii3 = mii1 * -32;
	results(mii3 == -4000);

	cout << endl;

	// negative * negative

	mii3 = mii2 * -80;
	results(mii3 == 7200);

	mii3 = mii2 * -320;
	results(mii3 == 28800);

	mb1 = 50;
	mb2 = 5;
	mb3 = mb1 * mb2;
	results(mb3 == 250);

	mb3 = mb2 * 17;
	results(mb3 == 85);

	mb3 = mb2 * 32;
	results(mb3 == 160);

	mc1 = 25;
	mc2 = -5;
	mc3 = mc1 * mc2;
	results(mc3 == -125);

	// negative * negative
	// ERR returns -15 ... int/byte confusion again
	mc3 = mc2 * -15;
	results(mc3 == 75);
	prt_char = mc3;
	
}

void divide2(void) {

	iee = -500;
	iee = iee / 33;
	irr = getsrmdr();
	results(iee == -15 and irr == -5);

	iee = -500;
	iee = iee % 33;
	results(iee == -5);

	iee = -790;
	irr = -33;
	iee = iee/irr;
	irr = getsrmdr();
	results(iee == 23 and irr == -31);

	iee = 950;
	irr = -30;
	iee = iee/irr;
	irr = getsrmdr();
	results(iee == -31 and irr==20);
}

void main(void) {

	// these have to be first
	static int stale;
	auto  uint fresh;

	cout << "Beginning\r\n";

	cout << "Subroutine calls\r\n";
	kk = div3(uaa);
	results(kk == 673);
	results(div3(uaa) == 673);

	uaa = 2019/3;
	results(uaa == 673);

	b = true;
	b = sub1();
	results(b);
	l = sub2(a,x);
	results(l == 0);
	// endl handled by defined CRLF runtime routine

	uaa = test_subroutine(100,200,300,400,500,600,700,800);
	results(5600==uaa);


	// this is bad as reuses variable name
	pt = 0x1200;
	vartst();
	results(pt == 0x1200);

	// this is bad as all the casts are wrong
	uaa = test_subroutine((uint)100,(uint)200,300,400,500,600,700,800);
	results(5600==uaa);
	// endl handled by defined CRLF runtime routine
	cout << endl;

	// ERR garbage in, more garbage out - see .lst file
	// p[1] = 35;
	// this looks better
	// *r = 22;

	cout << "Direct memory tests\r\n";

	//m = 0x4600;	// ERR looks ok in listing but...
			// gets set as relocatable in .objreg[reg_i]
			// if the above worked, these next ones would
	//m[0] = 78;	// this one gets translated to ASM
			// could be optimized to zh=mh zl=ml; LDA #78; Y=0; STA(zp),Y since 0 < 255
			// But how can I declare my pointers to be in page zero?
			// then it would get even faster
	// *m = 78;	// this one calls stack-based subroutines instead

	// but how can I do this at compile time?
	h = 0x1234;
	//ERR has side effect of writing to $00 and $01
//	*n = &h;			// points to h
	kk = hl(&h);			// gets the full address of h
	ll = lo(&h);			// gets the low byte of the address of h
	hh = hi(&h);			// gets the high byte of the address of h
	results(kk == (256*hh)+ll);
	results(mem.int[kk]==0x1234);

	memory.int[kk] = 0;
	memory.int[kk] = memory.int[kk] + 300;
	memory.int[kk] = memory.int[kk] + 5;
	results(memory.int[kk] == 305);

	memory.int[0x80] = 0;
	memory.int[0x80] = memory.int[0x80] + 300;
	memory.int[0x80] = memory.int[0x80] + 5;
	results(memory.int[0x80] == 305);
	cout << endl;

	cout << "Conditional tests\r\n";
	k = 5;
	if (k < 6)
		k ++;
	else
		k --;
	results(k == 6);
	if (k < 6)
		k ++;
	else
		k --;
	results(k == 5);

	// this doesn't work
	b = false;
	b = not b;
	results(b);
	cout << endl;

	cout << "pre-loop...  ";

	// this doesn't compile
	// while (wt1 == 5);

	// but this way does
	//while (run) { }

	// pre-test loop
	while (k >= 2)
		k --;
	results(k == 1);
	cout << endl;

	cout << "post-loop... ";

	// post-test loop
	do {
		k ++;
	} while (k < 10);
	results(k == 10);
	cout << endl;

	cout << "set loops...  ";
	// integer counter
	a = 5; x = 3;
	ia = 2000; ix=300;
	// set size loop
	for (j=0;j<5;j++) {
		a = a + x;
		ia = ia + ix;
		}
	results(j==5 and a==20 and ia==3500);

	// byte counter
	for (a=0;a<15;a++)
		ia = ia + ix;
	results(ia==8000);
	cout << endl;

	cout << "Simple math tests\r\n";
	// multiply
	x = 5;
	a = 20;
	stale = x * a;
	results(stale==100);

	i = aa / tn;
	results(i == 17);

	l = 2;
	// prints "RERROR 0" and stops program as desired
	// l = 0;
	k = h / l;
	h = 11;
	a = h % l;

	results(a == 1);
	i = 20;
	i = i / 4;
	results(i == 5);

	i = i * 3;
	results(i == 15);

	i = 125;
	i = i % 12;	cout << endl;

	results(i == 5);

	i = 5120;
	ss = sqrt(i);
	results(ss == 71);

	ss = sqrt(65000);
	results(ss == 254);
	cout << endl;

	cout << "enumeration test...";
	mdir = NE;
	tdir = W;
	results(mdir==1 and tdir==4);
	cout << endl;

	cout << "Bit operation tests... ";
	// runtime/C doesn't have exclusive-or yet
	// runtime/C doesn't have shifts yet

	j = ia and ix;
	results(j == 256);
	j = ia or ix;
	results(j == 8044);

	// this does
	ss = x or a;
	results(ss == 5);

	a = h and l;
	results(a == 2);

	// this doesn't work - does cast_w2b instead of b2w
	j = 32700;
	j = (int)(x or a);
	results(j == 5);
	cout << endl;


	cout << "Increment/decrement tests... ";
	j = 950;
	l = 47;

	inc j;
	l --;
	results(j==951 and l == 46);

	l ++;
	dec j;
	results(j == 950 and l == 47);
	cout << endl;

	cout << "Peek & Poke tests" << endl;
	pokes();
	cout << endl;


	// this prints numbers
	cout << "Printing tests" << endl;
	put(1234);
	putln(-5678);
	put(j);
	// this works differently though
	put(endl);

	// prints nothing for msg1 - should it?
	// cout << "Pointer tests" << endl;
	// cout << "cout with var string=" << msg1 << endl;

	// sets pointer to that address
	m = msg1;
	// now this works
	cout << "cout with pointer to var string= "<< m;

	cout << endl;
	cout << "Multiplication tests\r\n";
	multiply();
	cout << endl;

	cout << "Unsigned division\r\n";
	divide();
	cout << endl;

	cout << "Signed division\r\n";
	divide2();
	cout << endl;

	cout << "Memset test...   ";	// set bottom of stack to 0xff
	memset(256, 255, 25);
	jj = 0;
	for (kk=256;kk<256+25;kk++)
		jj = jj + memory.byte[kk];
	results(jj == 6375);
	cout << endl;

	cout << "Memmove test...  ";	// copy msg1 to msg2

	memmove(&msg1, &msg2, 17);
	cout << m;

	// gets non-relocated address
	iee = &irr;
	cout << "Address direct: " << iee;
	// gets relocated address
	iee = hl(&irr);
	cout << " using hl(): " << iee << endl;

	cout << "Pointer tests...";
	iee = 2222;
	irr = ptrtst(&iee);
	results(iee == 3222 and irr == 3272);

	ptrtest2();
	cout << endl;

	cout << "Integer array tests...";
	iee = 1000;
	results(bigger[3] == 4000);

	bigger[4] = 9000;
	bigger[5] = bigger[4] + iee;
	results(bigger[4] == 9000 and bigger[5] == 10000);
	cout << "\r\nEnd.\r\n";


//	this works
//	call 0x4000;
//	this works too
//	call 0x4000 with reg in out;

}

/* EOF
*/
