// 7800 test program

// todo IRQ/NMI support
// todo - data before and after paste program (see myrom.c)
//   read in .a78 header file
//   read in pre-data (sprites)
//   read in .bin file created from this
//   create top 10 bytes (vectors)
//   write resultant file
//   How about .BMP(s) -> .ROM converter

// new header
// ----------
// load address (gets stripped off by rom-maker)
// JMP start address
// data reloc addresses


#include "hdwe.h"

#include "const.h"

enum direction {
E, NE, N, NW, W, SW, S, SE
} tdir;

// routines in runtime library
uint lo(uint vara);
uint hi(uint varb);
uint getrmdr(void);
int getsrmdr(void);
void memset(uint us_a, byte bs_b, uint us_c);
void memmove(uint um_a, uint um_b, uint um_c);

#define	BCKCOL	0x08
#define	LTBLU	0x75

static char TANKS = 8;
static char ZONES = 12;


// arrays to create (mostly) at compile time
// the runtime module relocates these to RAM
byte DLX[7]	= {
		0xc0,0x40,mtofst,0x1f,0,0,0
};					// 0 1 hp 0 0
byte DLb1[18]	= {
		0xc0,0,onesofst,   0,
		0xc0,0,onesofst,  40,	
		0xc0,0,onesofst,  80,	
		0xc0,0,onesofst, 120,	
		0,0
};					// $C000+ones 2 10 #
byte DLE[6]	= {
		0xc0,0,mtofst,170,0,0
};					// $C000+mt 0 1 170
byte DLL[48]	= {
		ctl1, 0, 0,		/* &DLX  >> 8, &DLX  & 0xff, */
		ctl2, 0, 0,		/* &DLb1 >> 8, &DLb1 & 0xff, */
		ctl2, 0x22, 0x00,
		ctl2, 0x22, 0x80,	/* NMI was on here */
		ctl2, 0x23, 0x00,
		ctl2, 0x23, 0x80,
		ctl2, 0x24, 0x00,
		ctl2, 0x24, 0x80,
		ctl2, 0x25, 0x00,
		ctl2, 0x25, 0x80,
		ctl2, 0x26, 0x00,
		ctl2, 0x26, 0x80,
		ctl2, 0x27, 0x00,
		ctl2, 0x27, 0x80,
		ctl2, 0, 0,		/* &DLb1 >> 8, &DLb1 & 0xff, */
		ctl4, 0, 0		/* &DLE  >> 8, &DLE  & 0xff  */
};


// would be nicer not to move this to RAM then to Maria
byte colors[8]	= {
		0x27, 0x45, 0x00, 0x0f, 0x38, 0xa4, 0x71, 0x04
};


// I would really like these in page 0

bool Tank_status[8];
bool Saucer_status;
uint Missile_time[10];
uint Tank_H_pos[8];
uint Saucer_H_pos;
uint Missile_H_pos[10];
uint Tank_V_pos[8];
uint Saucer_V_pos;
uint Missile_V_pos[10];
char Tank_rotation[8];
char Saucer_rotation;
char Missile_rotation[10];

bool Fire_enable[8];
bool Attract_flg	= true;
bool Reset_flg;
bool Select_flg;
bool Pause_flg;
bool running		= true;
bool Two_players	= true;

byte DLptrM1;
byte DLptr[12];
byte DLptr13;

// these can be anywhere
char Explode_time[8];
char Explode_color[8];
char Explode_H_pos[8];
char Explode_V_pos[8];

uint respawn[8];

uint Frame_count;

uint Energy[2];
byte score1[3];
byte score2[3];


byte rzshufl[8];
byte rzptr;
char index		= 0;
int  VSPD, HSPD;

char Msg_color;
char Msg_count;
char P4_shadow;
char P5_shadow;


// clear pointers and put Null headers for the 12 onscreen DLs
void clearDLs(void) {

	auto byte count_i;	// temp variable

	// set DLs to Null Headers - this isn't efficient - but faster than a loop
	mem[0x2201] = 0;
	mem[0x2281] = 0;
	mem[0x2301] = 0;
	mem[0x2381] = 0;
	mem[0x2401] = 0;
	mem[0x2481] = 0;
	mem[0x2501] = 0;
	mem[0x2581] = 0;
	mem[0x2601] = 0;
	mem[0x2681] = 0;
	mem[0x2701] = 0;
	mem[0x2781] = 0;

	for (count_i=0;count_i<ZONES;count_i++)
		DLptr[count_i] = 0;
}

// setup Maria and TIA registers
void init_Maria(void) {

mem[Swcha]  = 0xff;			// enable joystick
mem[Ctlswb] = 0x14;			// enable 7800 fire buttons
mem[Swchb]  = not 0x14;
mem[Inpctl] = 0;			// turn on fire buttons
mem[Offset] = 0;			// just because
mem[Ctlswa] = 0;

// move colors to Maria registers - this is efficient
mem[P0c2]   = colors[0];
mem[P1c2]   = colors[1];
mem[P2c2]   = colors[2];
mem[P3c2]   = colors[3];
mem[P4c2]   = colors[4];
mem[P5c2]   = colors[5];
mem[P6c2]   = colors[6];
mem[P7c2]   = colors[7];
mem[Bckgrd] = BCKCOL;

// set DLL address in Maria
mem[Dpph] = hi(&DLL); 			// &DLL >> 8
mem[Dppl] = lo(&DLL); 			// &DLL & 0xff

mem[Chrbas] = 0xc0;			// unused, but set

}

// put a sprite into a DL
void place1(uint H_pos, uint V_pos, byte graph_offset, byte ctrl) {

	static byte zone, rmdr;	// we use these a lot
	static uint addr;
	static byte tmp;

// to put something onscreen
// -------------------------
// determine zone(s)
// set address lo
// set control (palette/width)
// set address hi
// set xposition
// set nullheader for next DL

	zone = V_pos/ZONES;	// determine zone
	rmdr = getrmdr();	// get distance into zone

	addr = (uint)zone*128 + 0x2200 + (uint)DLptr[zone];

	mem[addr] = graph_offset;
	addr ++;
	mem[addr] = ctrl;
	addr ++;
	mem[addr] = 0xc0 + rmdr;
	addr ++;
	tmp = (byte)(hi(H_pos));
	mem[addr] = tmp;
	addr = addr + 2;
	mem[addr] = 0;
	DLptr[zone] = DLptr[zone] + 4;

	if (rmdr != 0) {
		zone ++;
		addr = (uint)zone*128 + 0x2200 + (uint)DLptr[zone];
		mem[addr] = graph_offset;
		addr ++;
		mem[addr] = ctrl;
		addr ++;
		mem[addr] = 0xb0 + rmdr;
		addr ++;
		mem[addr] = tmp;
		addr = addr + 2;
		mem[addr] = 0;
		DLptr[zone] = DLptr[zone] + 4;
	}
}

// bounce object off screen borders
void check_border(char which) {

	static uint H_pos, V_pos;

	H_pos = Tank_H_pos[which];
	V_pos = Tank_V_pos[which];

	if (V_pos < 255) {
		Tank_rotation[which] = 16 - Tank_rotation[which];
		VSPD = 5;
	}
	if (H_pos < 127) {
		Tank_rotation[which] = (24 - Tank_rotation[which]) and 0x0f;
		HSPD = 5;
	}
	if (V_pos > 191*256) {
		Tank_rotation[which] = 16 - Tank_rotation[which];
		VSPD = -5;
	}
	if (H_pos > 319*128) {
		Tank_rotation[which] = (24 - Tank_rotation[which]) and 0x0f;
		HSPD = -5;
	}
}

// here it is
void main(void) {

					// always nice to have a few counters
	static byte count_i;
	static int count_j, count_k;

					// we get control in 7800 mode with DMA off
					// and variables located in RAM

	init_Maria();

					// now we do touchup to the DLL
					// would like to do this at compile time
	DLL[1]  = hi(&DLX);   DLL[2]  = lo(&DLX);
	DLL[4]  = hi(&DLb1);  DLL[5]  = lo(&DLb1);
	DLL[43] = hi(&DLb1);  DLL[44] = lo(&DLb1);
	DLL[46] = hi(&DLE);   DLL[47] = lo(&DLE);

	while ((char)mem[Mstat] > 0)	// Wait for Vertical Blanking
		mem[Wsync] = 0;

	clearDLs();

	mem[Ctrl] = 0x53;		// turn DMA back on %01010011

					// set initial positions for all the sprites
	for (count_i=0;count_i<8;count_i++) {
		Tank_status[count_i] = -127;
		Tank_H_pos[count_i] = MIDX;
		Tank_V_pos[count_i] = MIDY;
	}
	Saucer_status = true;
	Saucer_H_pos = MIDX;
	Saucer_V_pos = MIDY;
	
	Tank_status[index] = true;	// enable 1 sprite
	VSPD = -5;
	HSPD =  5;

	while (running) {		// videogames never end

		while ((char)mem[Mstat] > 0)	// Wait for Vertical Blanking
			mem[Wsync] = 0;

		clearDLs();

		if (Tank_status[index] > 0)
			place1(Tank_H_pos[index], Tank_V_pos[index], tankofst, pal_1_wid_2);

					// move it forward
		Tank_V_pos[index] = Tank_V_pos[index] + VSPD;
		Tank_H_pos[index] = Tank_H_pos[index] + HSPD;
	
		check_border(index);	// bounce it off the edges of the screen


	}
}

// END

