
		// SEGMENT Static Data.
		//

		// Runtime Error String.
		//
rerror_string:
		db "RERROR "
		db  0


		save_y = datastacks

		// SEGMENT Code.
		//

		// PROCEDURE init.
		//
		// Initialise the runtime library.
		//
init:
		cld			// Don't use BCD mode.

		if (target == target_7800)
		lda #0x07
		sta 0x08		// lock system to 7800 mode
_i1:
		sta 0x24
		bit 0x28
		bpl _i1			// wait for VBLANK
		lda #0x73
		sta 0x3c		// turn off DMA
		jsr movemem
		endif

		ldy #0x00		// Reset the data stack pointer.
		sty save_y		// save it (just because)
		sty bp			// Reset the base pointer.
		lda #charmode_raw_wait
		sta charmode		// Begin in raw wait ioctl mode.

		if (target == target_vicg)
		//
		// vicg mode.
		//
		// Move character generator to       0x1000 (4096).
		// Move framebuffer to         	     0x1800 (6144).
		// Runtime proper must then start at 0x1a00 (6656).
		//
		lda #(224+12)
		sta [36869]		// VIC Register #6
		lda [36866]             // VIC Register #3
		and #0x7f
		sta [36866]             // VIC Register #3
		lda #0x18		// MSB of new video buffer address.
		sta [648]		// Tell the kernel it's moved.
		lda #147		// The clear character
		jmp print_ch_a		// Print clear character and rts.

		elif (target == target_vich)
		//
		// vich mode.
		//
		// Leave framebuffer at        	     0x1000 (4096).
		// Move character generator to       0x1400 (5120).
		// Runtime proper must then start at 0x2400 (9216).
		//
		lda #(192+13)
		sta [36869]		// VIC Register #6

		lda [36866]             // VIC Register #3
		and #0x7f
		sta [36866]             // VIC Register #3

		lda [36867]             // VIC Register #4
		ora #0x01		// Double-height characters.
		sta [36867]             // VIC Register #4

		lda #0x10		// MSB of new video buffer address.
		sta [648]		// Tell the kernel it's moved.
		lda #147		// The clear character
		jmp print_ch_a		// Print clear character and rts.
		else
		rts
		endif



		// GROUP Push/Pop.
		//

		datalo = datastack
		datahi = datastack + 0x80
		datahi_m1 = datahi - 1
		datalo_m1 = datalo - 1

		// PROCEDURE push_b.
		//
		// NOTE: push_b is stored in the Operator Group
		// 	 to allow relative branches to it


		// PROCEDURE cast_w2b.
		//
		// Change the word on the top of the stack into a byte.
		// (Simply discard the high byte; equivalent to pop_b).
		//
cast_w2b:
		/*FALLTHROUGH*/


		// PROCEDURE pop_b.
		//
		// Pop a byte from the stack into <A>.
		//
pop_b:
		ldy save_y
_pop_b_y:
		lda datalo,y
		dey
		sty save_y
a_rts:
		rts


		// PROCEDURE push_w.
		//
		// Push the word <A,X> on the stack.
		//
		// By convention when we store a word in the registers
		// <A=LSB, X=MSB>.
		//
		// The low byte is pushed first, the high byte second.
		// Thus we get: [under] = <A>, [top] = <X>.
		//
push_w:
		ldy save_y
_push_w_y:
		iny
		sta datalo,y
		txa
		sta datahi,y
		sty save_y
		rts


		// PROCEDURE pop_w.
		//
		// Pop a word from the stack into <A,X>.
		//
pop_w:
		ldy save_y
_pop_w_y:
		ldx datahi,y
		lda datalo,y
		dey
		sty save_y
		rts


		// PROCEDURE push_w_c.
		//
		// Push the word <C> on the stack.
		//
push_w_c:
		ldy save_y
		iny
		lda ch
		sta datahi,y
		lda cl
		sta datalo,y
		sty save_y
		rts


		// PROCEDURE pop_w_c.
		//
		// Pop a word from the stack into <C>.
		//
pop_w_c:
		ldy save_y
		lda datahi,y
		sta ch
		lda datalo,y
		sta cl
		dey
		sty save_y
		rts


		// PROCEDURE push_b_c.
		//
		// Push the byte <CL> on the stack.
		//
push_b_c:
		ldy save_y
		lda cl
		sta datalo,y
		iny
		sty save_y
		rts


		// PROCEDURE pop_w_c.
		//
		// Pop a byte from the stack into <CL>.
		//
pop_b_c:
		ldy save_y
		lda datalo,y
		sta cl
		dey
		sty save_y
		rts


		// PROCEDURE pop_b_cr.
		//
		// Pop two bytes from the stack into <A> and <CL>.
		//
		// <A> = [under]. <CL> = [top].
		//
pop_b_cr:
		jsr pop_b_c
		jmp _pop_b_y	// rts


		// PROCEDURE pop_w_cr.
		//
		// Pop two words from the stack into <A, X> and <C>.
		//
		// <A, X> = [under]. <C> = [top].
		//
pop_w_cr:
		jsr pop_w_c
		jmp _pop_w_y	// rts


		// PROCEDURE pop_w_dc
		//
		// Pop two words from the stack into <D> and <C>.
		//
		// <C> = [under]. <D> = [top].
		//
pop_w_dc:
		jsr pop_w
		sta dl
		stx dh
		jmp pop_w_c	// rts





		// GROUP Cast.
		//

		// PROCEDURE cast_b2w.
		//
		// NOTE: cast_b2w is stored in the Operator Group
		//	 where it is identical to push_b #0.
		//


		// PROCEDURE cast_c2w.
		//
		// Change the signed byte (eg. char) on the top of the stack
		// into a word.
		//
		// MOD2: [bj 22sep1998] Wasn't looking at stack.
		//cast_b2w
cast_c2w:
		ldy save_y
		lda #0		// preset A for positive
		ldx datalo,y	// Peek at [top]; copy into <X>.
		bpl _cpos
		lda #0xff
_cpos:
		sta datahi,y
		rts




		// GROUP Swap.
		//


		// PROCEDURE swap_ww.
		//
		// Swap words [under] and [top].
		//
swap_ww:
		ldy save_y
		lda datahi_m1,y
		tax
		lda datahi,y
		sta datahi_m1,y
		txa
		sta datahi,y

		// fallthrough

		// PROCEDURE swap_bb.
		//
		// Swap bytes [under] and [top].
		//
swap_bb:
		ldy save_y
		lda datalo_m1,y
		tax
		lda datalo,y
		sta datalo_m1,y
		txa
		sta datalo,y
		rts




		// GROUP Operators.
		//


		// PROCEDURE extend.
		//
		// Extend signed byte a <A> into signed word <A, X>.
		// If <A> is negative <X> is set to 0xffu.
		// If <A> is zero or positive<X> is set to 0x00.
		//
extend_ax:
		cmp #0
		bmi _extend_neg
		ldx #0
		rts
_extend_neg:	ldx #0xff
		rts


		// PROCEDURE and_ww.  (Logical/Bit And with word operands).
		//
		// [top] = [top] bitand [under].
		//
and_ww:
		ldy save_y
		lda datahi,y		; Semicolon forces end of statement.
		and datahi_m1,y		;
		sta datahi_m1,y

		// fallthrough

		// PROCEDURE and_bb.  (Logical/Bit And with byte operands).
		//
		// [top] = [top] bitand [under].
		//
and_bb:
		ldy save_y
		lda datalo,y		; Semicolon forces end of statement.
		and datalo_m1,y		;
		sta datalo_m1,y
		dey
		sty save_y
		rts



		// PROCEDURE or_ww.  (Logical/Bit Or with word operands).
		//
		// [top] = [top] bitor [under].
		//
or_ww:
		ldy save_y
		lda datahi,y
		ora datahi_m1,y
		sta datahi_m1,y

		// fallthrough

		// PROCEDURE or_bb.  (Logical/Bit Or with byte operands).
		//
		// [top] = [top] bitor [under].
		//
or_bb:
		ldy save_y
		lda datalo,y
		ora datalo_m1,y
		sta datalo_m1,y
		dey
		sty save_y
		rts




		// PROCEDURE pop_b_cr_cmp.
		//
		// Pop two bytes into <C> and <A>, then compare them
		// setting the carry/minus/zero flags as appropriate.
		//
pop_b_cr_cmp:
		jsr pop_b_cr
		cmp cl
		rts



		// PROCEDURE pop_w_cmp_cm.
		//
		// Pop two words into <C> and <AX>, then compare them
		// setting the carry/minus flags as appropriate.
		//
_pop_w_cmp_cm:
		jsr pop_w_cr		// al,xh = [under].  c = [top].
		sec
		sbc cl
		txa
		sbc ch			// [under] - [top]
		rts


		// PROCEDURE pop_w_cmp_eq.
		//
		// Pop two words into <C> and <AX>, then compare them
		// setting the zero flag as appropriate.
		//
_pop_w_cmp_eq:
		jsr pop_w_cr		// al,xh = [under].  c = [top].
		cmp cl
		bne _leave20
		cpx ch
_leave20:
		rts


		// PROCEDURE pop_w_cmp_all.
		//
		// Pop two words into <C> and <X>, then compare them
		// setting the carry/minus/zero flags as appropriate.
		//
_pop_w_cmp_all:
		jsr pop_w_cr		// al,xh = [under].  c = [top].

		cmp cl
		bne _set_nonzero
		cpx ch
		sec			// For upcoming subtraction
		beq _set_zero
_set_nonzero:
		sbc cl
		txa
		sbc ch			// [under] - [top]
		php
		pla		;
		and #253	;	// Clear the Z flag
		jmp _cont22     ;

_set_zero:
		sbc cl
		txa
		sbc ch			// [under] - [top]
		php
		pla
		ora #2			// Set Z flag.

_cont22:
		pha
		plp
		rts




		// PROCEDURE eq_ww.  [top] = [under] == [top] (words)
		//
eq_ww:
		jsr 	_pop_w_cmp_eq
		jmp	_res_eq

		// PROCEDURE ne_ww.  [top] = [under] != [top] (words)
		//
ne_ww:
		jsr 	_pop_w_cmp_eq
		jmp	_res_ne



		// PROCEDURE lt_ww.  [top] = [under] <  [top] (signed words)
		//
lt_ww:
		jsr 	_pop_w_cmp_cm	// [underneath] - [top]
		jmp	_res_lt


		// PROCEDURE le_ww.  [top] = [under] <= [top] (signed words)
		//
le_ww:
		jsr 	_pop_w_cmp_all
		jmp	_res_le


		// PROCEDURE gt_ww.  [top] = [under] >  [top] (signed words)
		//
gt_ww:
		jsr 	_pop_w_cmp_all
		jmp	_res_gt


		// PROCEDURE ge_ww.  [top] = [under] >= [top] (signed words)
		//
ge_ww:
		jsr 	_pop_w_cmp_cm
		jmp	_res_ge


		// PROCEDURE ult_ww. [top] = [under] <  [top] (unsigned words)
		//
ult_ww:
		jsr 	_pop_w_cmp_cm
		jmp	_res_ult


		// PROCEDURE ule_ww. [top] = [under] <= [top] (unsigned words)
		//
ule_ww:
		jsr 	_pop_w_cmp_all
		jmp	_res_ule


		// PROCEDURE ugt_ww. [top] = [under] >  [top] (unsigned words)
		//
ugt_ww:
		jsr 	_pop_w_cmp_all
		jmp	_res_ugt


		// PROCEDURE uge_ww. [top] = [under] >= [top] (unsigned words)
		//
uge_ww:
		jsr 	_pop_w_cmp_cm
		jmp	_res_uge




		// PROCEDURE push_b_1.
		//
		// Push true (-1).
		//
		// NOTE:
		//   We use -1 to represent true rather than 1,
		//   since -1 allows logical and bitwise
		//   boolean operations to be done by the
		//   same algorithm.  This is also faster.
		//   [bj 21sep1998].
		//
		//
push_b_1:
		lda #0xff
		/*FALLTHROUGH*/



		// PROCEDURE push_b.
		//
		// Push the byte <A> on the stack.
		//
push_b:
		ldy save_y
		iny
		sta datalo,y
		sty save_y
		rts



		// PROCEDURE cast_b2w.
		//
		// Change the unsigned byte on the top of the stack
		// into a word.  (Set the high byte to zero).
		//
cast_b2w:
		ldy save_y
		lda #0
		sta datahi,y
		rts


		// PROCEDURE push_b_0.
		//
		// Push false (0).
		//
push_b_0:
		lda #0
		beq push_b	// BRA


		// PROCEDURE eq_bb.  [top] = [under] == [top] (bytes)
		//
eq_bb:
		jsr pop_b_cr_cmp
_res_eq:
		beq push_b_1
		bne push_b_0		// rts
		//NOTREACHED


		// PROCEDURE ne_bb.  [top] = [under] != [top] (bytes)
		//
ne_bb:
		jsr pop_b_cr_cmp
_res_ne:
		bne push_b_1
		beq push_b_0		// rts
		//NOTREACHED


// Unsigned Greater than: true iff [under] > [top]
//
ugt_bb:
		jsr pop_b_cr_cmp	// lda [under], cmp [top]
_res_ugt:
		beq push_b_0		// =  fails.
		bcs push_b_1		// >= suceeds.
		bcc push_b_0		// <  fails.
		//NOTREACHED


// Unsigned Greater than or equal: true iff [under] >= [top]
//
uge_bb:
		jsr pop_b_cr_cmp	// lda [under], cmp [top]
_res_uge:
		bcs push_b_1		// >= suceeds
		bcc push_b_0		// *  fails.
		//NOTREACHED


// Unsigned Less than: true iff [under] < [top]
//
ult_bb:
		jsr pop_b_cr_cmp	// lda [under], cmp [top]
_res_ult:
		bcc push_b_1		// < suceeds.
		bcs push_b_0		// * fails.
		//NOTREACHED


// Unsigned Less than or equal: true iff [under] <= [top]
//
ule_bb:
		jsr pop_b_cr_cmp	// lda [under], cmp [top]
_res_ule:
		bcc push_b_1		// < succeeds.
		beq push_b_1		// = succeeds.
		bne push_b_0		// * fails.
		//NOTREACHED


// Signed Greater than: true iff [under] > [top]
//				 [under] - [top] > 0
//
gt_bb:
		jsr pop_b_cr_cmp	// lda [under], cmp [top]
_res_gt:
		beq push_b_0		// =  fails.
		bpl push_b_1		// >= suceeds.
		bmi push_b_0		// <  fails.
		//NOTREACHED


// Signed Greater than or equal: true iff [under] >= [top]
//					  [under] -  [top] >= 0
//
ge_bb:
		jsr pop_b_cr_cmp	// lda [under], cmp [top]
_res_ge:
		bpl push_b_1		// >= suceeds
		bmi push_b_0		// <  fails.
		//NOTREACHED


// Signed Less than: true iff [under] < [top]
//			      [under] - [top] < 0
//
lt_bb:
		jsr pop_b_cr_cmp	// lda [under], cmp [top]
_res_lt:
		bmi push_b_1		// <  suceeds.
		bpl push_b_0		// *  fails.
		//NOTREACHED


// Signed Less than or equal: true iff [under] <= [top]
//				    [under] - [top] <= 0
//
le_bb:
		jsr pop_b_cr_cmp	// lda [under], cmp [top]
_res_le:
		bmi push_b_1		// <  suceeds
		beq push_b_1		// =  suceeds.
		bne push_b_0		// *  fails.
		//NOTREACHED




		// PROCEDURE add_bb.  [top] = [under] + [top] (bytes)
		//
add_bb:

		ldy save_y
		lda datalo,y
		clc
		adc datalo_m1,y
		sta datalo_m1,y
		dey
		sty save_y
		rts


		// PROCEDURE sub_bb.  [top] = [under] - [top] (bytes)
		//
sub_bb:

		ldy save_y
		lda datalo_m1,y
		sec
		sbc datalo,y
		sta datalo_m1,y
		dey
		sty save_y
		rts



		// PROCEDURE add_ww.  [top] = [under] + [top] (words)
		//
add_ww:
		ldy save_y
		clc
		lda datalo,y
		adc datalo_m1,y
		sta datalo_m1,y
		lda datahi,y
		adc datahi_m1,y
		sta datahi_m1,y
		dey
		sty save_y
		rts


		// PROCEDURE sub_ww.  [top] = [under] - [top] (words)
		//
sub_ww:
		ldy save_y
		sec
		lda datalo,y
		sbc datalo_m1,y
		sta datalo_m1,y
		lda datahi,y
		sbc datahi_m1,y
		sta datahi_m1,y
		dey
		sty save_y
		rts



		// PROCEDURE not_w.   [top] = ~[top] 	(words)
		//
not_w:
		ldy save_y
		lda datahi,y
		eor #0xff
		sta datahi,y

		// fallthrough

		// PROCEDURE not_b.   [top] = ~[top] 	(bytes)
		//
not_b:			
		ldy save_y
		lda datalo,y
		eor #0xff
		sta datalo,y
		rts


		// PROCEDURE neg_b.   [top] = -[top] 	(bytes)
		//
neg_b:
		ldy save_y
		sec
		lda #0
		sbc datalo,y
		sta datalo,y
		rts

		// PROCEDURE neg_w.   [top] = -[top] 	(words)
		//
neg_w:
		ldy save_y
		sec
		lda #0
		sbc datalo,y
		sta datalo,y
		lda #0
		sbc datahi,y
		sta datahi,y
		rts
		

		// PROCEDURE mul_ww. [top] = [under] / [top] (signed word)
		//
mul_ww:
		jsr _pop_w_cd_abs
		jsr umul_ww_cd
		lda is_negative
		beq _skip20
		jmp neg_w
_skip20:
		rts


		// PROCEDURE mul_ww.  [top] = [under] * [top] (unsigned word)
		//
umul_ww:
		jsr pop_w_cd		// Order doesn't matter...

		// ALTERNATE ENTRY mul_ww_cd.  [top] = <C> * <D>.
		//
umul_ww_cd:
		lda #0
		sta el
		sta eh

		ldx #16

_loop0:
		asl el
		rol eh

		bit ch
		bpl _skip0

		clc
		lda el
		adc dl
		sta el
		lda eh
		adc dh
		sta eh

_skip0:
		asl cl
		rol ch

		dex
		bne _loop0

		lda el
		ldx eh
		jmp push_w		// rts.



		// PROCEDURE pop_w_cd.
		//
		// Pop two words from the stack into <C>, <D>.
		//
		// <D> = [top]; <C> = [underneath]
pop_w_cd:
		jsr pop_w
		sta dl
		stx dh
		jmp pop_w_c		// rts.




		// LOCAL PROCEDURE _abs_cx_flag.
		//
		// Set <C> to the absolute value of itself.
		// If <C> was negative, then increment the
		// <is_negative> counter.
		//
		// NOTE:
		//   The <is_negative> counter can be used to count the
		//   total number of negative operands to an operator.
		//   If this number is odd, we know we need to negate
		//   the result of the operator.
		//
_abs_cx_flag:
		lda ch
		bpl _skip6

		// ALTERNATE ENTRY _neg_cx_flag.
		//
_neg_cx_flag:
		inc is_negative
_neg_cx:
		sec
		lda #0
		sbc cl
		sta cl
		lda #0
		sbc ch
		sta ch
_skip6:
		rts



		// PROCEDURE pop_w_cd_abs.
		//
		// Pop two words from the stack into <C>, <D>.
		//
		// <D> = [top]; <C> = [underneath];
		// <is_negative> = number of negative operands.
		//
_pop_w_cd_abs:
		lda #0
		sta is_negative
		jsr pop_w_c
		jsr _abs_cx_flag
		lda cl
		sta dl
		lda ch
		sta dh
		jsr pop_w_c
		jmp _abs_cx_flag

_push_w_abs:
		sta cl			// have to save this now
		lda is_negative         ;
		and #1			;
		beq _skip7              ;
		stx ch
		jsr _neg_cx
_skip7:
		jmp push_w_c		; rts



		// PROCEDURE mod_ww. [top] = [under] % [top] (signed word)
		//
mod_ww:
		jsr _pop_w_cd_abs
		jsr div_mod_w
_mod_ww_rt:
		lda el
		ldx eh
		jmp _push_w_abs		; rts,


		// PROCEDURE div_ww. [top] = [under] / [top] (signed word)
		//
div_ww:
		jsr _pop_w_cd_abs
		jsr div_mod_w
		lda fl
		ldx fh
		jmp _push_w_abs		; rts,



		// PROCEDURE umod_ww. [top] = [under] % [top] (unsigned word)
		//
umod_ww:
		jsr pop_w_dc
		jsr div_mod_w
		lda el
		ldx eh
		jmp push_w		// rts


		// PROCEDURE udiv_ww. [top] = [under] / [top] (unsigned word)
		//
udiv_ww:
		jsr pop_w_dc
		jsr div_mod_w
		jmp push_w_c		// rts

		// PROCEDURE div_mod_w.
		//
		// Divides <C> by <D>.
		//
		// IN:
		//   C		dividend (number)
		//   D		divisor
		// OUT:
		//   F          Quotient.
		//   E		Remainder.
		//   C		also Quotient.
		//
		//
div_mod_w:
		lda dl		// check for div/0
		bne _okdiv
		lda dh
		bne _qdiv
		// lda #0
		jmp rerror
_qdiv:
		cmp #1		// fast divide by 256
		bne _okdiv
		lda cl
		sta el		// low byte is remainder
		lda ch
		sta cl		// high byte is quotient
		lda #0
		sta eh
		sta ch
		rts

// 1 byte smaller - but can do 32 bits/16bits  as well - probably a lot slower

// N+0, N+1 = divisor                (dl/dh)
// N+2, N+3 starts as 0 (32 bit high word) -> remainder (el/eh)
// N+4, N+5 is number & quotient     (cl/ch)
// N+6 = extra    (fl)
// carry = extra  (fh)
_okdiv:
	LDA	#0
	STA	el
	STA	eh
			; We will loop 16 times; but since we shift the dividend
	LDX     #17	; over at the same time as shifting the answer in, the
			; operation must start AND finish with a shift of the
			; low cell of the dividend (which ends up holding the
			; quotient), so we start with 17 (11H) in X.
	CLC
_loop:
	ROL     cl	; Move low cell of dividend left one bit, also shifting
	ROL     ch	; answer in. The 1st rotation brings in a 0, which later
			; gets pushed off the other end in the last rotation.
	DEX
	BEQ     _end    ; Branch to the end if finished.
	
	ROL     el	; Shift high cell of dividend left one bit, also
	ROL     eh	; shifting next bit in from high bit of low cell.
	LDA	#0
	STA     fh	; Zero old bits of CARRY so subtraction works right.
	ROL     fh	; Store old high bit of dividend in CARRY.
	SEC             ; See if divisor will fit into high 17 bits of dividend
	LDA     el	; by subtracting and then looking at carry flag.
	SBC     dl	; First do low byte.
	STA     fl	; Save difference low byte until we know if we need it.
	LDA     eh
	SBC     dh	; Then do high byte.
	TAY             ; Save difference high byte until we know if we need it.
	LDA     fh	; Bit 0 of CARRY serves as 17th bit.
	SBC     #0      ; Complete the subtraction by doing the 17th bit before
	BCC     _loop	; determining if the divisor fit into the high 17 bits
			; of the dividend.  If so, the carry flag remains set.
	LDA     fl	; If divisor fit into dividend high 17 bits, update
	STA     el	; dividend high cell to what it would be after
	STY     eh	; subtraction.
	BCS     _loop	; Always branch.
_end:
	LDA cl
	STA fl
	LDA ch
	STA fh
	RTS





		// GROUP Console I/O.
		//


		// PROCEDURE ioctl.
		//
		// Set the ioctl standard input mode from [top].
		//
ioctl:
		jsr pop_b
		sta charmode
		rts


		// PROCEDURE print_ch_b.
		//
		// Print [top] as a character.
		//
print_ch_b:
		jsr pop_b

		// ALTERNATE ENTRY print_ch_a.
		//
		// Print <A> as a character.
		//
print_ch_a:
		if (target != target_aim)
		 cmp #10			// convert '\n' to '\r'
		 bne _skip4
		 lda #13
_skip4:
		endif
		jmp call_print_ch_a	// rts

print_nl:
		if (target == target_aim)
		  jmp 0xea13
		else
		  lda #13		// convert '\n' to '\r'
		  bne _skip4	// small cut saves us a byte.
		endif
		//NOTREACHED


		// PROCEDURE print_string_ax.
		//
		// Print the null-terminated string pointed at by <A, X>.
		//
		// Two strings walk into a bar.
		// The first says, "I'll have a beer."
		// The second says, "I'll have a beer too1r380*)@$(C@&unrd3c"
		// The first says, "You'll have to excuse my friend;
		// He isn't null terminated."  :)
		//
		//
print_string_ax:
		sta cl
		stx ch
		jmp print_string_c

		// ALTERNATE ENTRY print_string_w.
		//
		// Print the null-terminated string pointed at by [top].
		//
print_string_w:
		jsr pop_w_c

		// ALTERNATE ENTRY print_string_w.
		//
		// Print the null-terminated string pointed at by <C>.
		//
print_string_c:
_loop5:		ldy #0
		lda (cl),y
		beq _leave5
		jsr print_ch_a
		inc cl
		bne _loop5
		inc ch
		jmp _loop5
_leave5:
		rts


		// PROCEDURE print_integer_ax_signed.
		//
		// Print the signed word <A, X> as an integer.
		//
print_integer_ax_signed:
		sta cl
		stx ch
		ldx #0			// Address <C>
		stx is_negative		// Clear <is_negative>.
		jsr _abs_cx_flag	// Make absolute; update <is_negative>
		ldx is_negative		// Test <is_negative>.
		beq print_integer_c	// Not set, so Positive; print as is.
		lda #45			// Set, so Negative; print '-'.
		jsr print_ch_a
		jmp print_integer_c	// Now print it.

		// PROCEDURE print_integer_ax.
		//
		// Print the unsigned word <A, X> as an integer.
		//
print_integer_ax:
		sta cl
		stx ch
		jmp print_integer_c

		// ALTERNATE ENTRY print_integer_w.
		//
		// Print the unsigned word [top] as an integer.
		//
print_integer_w:
		jsr pop_w_c

		// ALTERNATE ENTRY print_integer_c.
		//
		// Print the unsigned word <C> as an integer.
		//
print_integer_c:
		lda #10
		sta dl
		lda #0
		sta dh
		sta buffer_count
_loop2:
		jsr div_mod_w
		lda el
		adc #48			// '0'
		ldx buffer_count
		sta buffer, x
		inc buffer_count

		lda fl
		sta cl
		lda fh
		sta ch

		cmp #0
		bne _loop2
		lda cl
		cmp #0
		bne _loop2


		dec buffer_count
_loop3:
		ldx buffer_count
		lda buffer, x
		jsr call_print_ch_a
		dec buffer_count
		bpl _loop3

__rts1:
		rts

		// PROCEDURE get_ch_a.
		//
		// Get a character from standard input.
		// Return the character in 'A'.
		//
		// This applies the ioctl standard input mode
		// before calling the appropriate kernel routines.
		//
get_ch_a:	lda charmode
		beq _get_cooked
		bmi _get_nowait

_get_wait:	jsr call_get_ch_raw_a
		cmp #0
		beq _get_wait
		bne __rts1

_get_nowait:	jmp call_get_ch_raw_a

_get_cooked:	jmp call_get_ch_cooked_a


get_ch_b:	jsr get_ch_a
		jmp push_b




		// GROUP Stack Management.
		//

		// PROCEDURE push_n.
		//
		// Push <A> bytes on the stack.
		// Their contents are undefined.
		//
push_n:
		clc
		adc datastacks
		sta datastacks
		rts


		// PROCEDURE pop_n.
		//
		// Pop <A> bytes off the stack and discard them.
		//
pop_n:
		sta el
		sec
		lda datastacks
		sbc el
		sta datastacks
		rts


		// PROCEDURE prolog.
		//
		// Start a new stack frame.  A stack frame is
		// needed when a subroutine is called that has
		// either parameters or local "automatic" variables.
		// When we return from the subroutine the stack
		// frame is discarded.
		//
		// Subroutines with none of these do not need a stack frame.
		//
		// A stack frame lives on the datastack.
		// It consists of local storage;
		// Parameters followed by local "automatic" variables.
		// The base pointer <BP> points to the first byte
		// underneath the the current stack frame.
		//
		//   datastack[BP+1] points to the first  byte of the frame.
		//   datastack[BP+2] points to the second byte of the frame.
		//   datastack[BP+3] points to the third  byte of the frame.
		//   etc.
		//
		// The prolog subroutine is called from the application
		// before calling the subroutine.  It should be called
		// immediately before the first parameter is pushed on
		// the stack.
		//
		// On entering the subroutine the bytes needed for
		// storage of local "automatic" variables needs to be
		// pushed on the stack (by calling push_n).  This is the
		// size of the stack frame, minus the size of the parameters.
		//
prolog:
		lda bp
		jsr push_b	// Saved old <BP> on stack.
		ldy save_y
		sty bp		// Current stack pointer becomes new <BP>.
		rts



		// PROCEDURE epilog.
		//
		// This subroutine is called before returning from
		// a stack-framed subroutine.  <A> is set to the size
		// of the local stack frame.
		//
		// Subroutines that return a value do so in <A, X>;
		// <A> (and <Y>) are destroyed by this subroutine,
		// and so <A> should be saved before calling it.
		//
epilog:
		jsr pop_n	// Discard local stack frame.
		jsr _pop_b_y    // Retrieve the previous <BP>.
		sta bp          // Restore  the previous <BP>.
		rts


		// GROUP Memory Management.
		//

		// PROCEDURE peek_w.
		//
		// [top] = memory[[top]]
		//
		// Peek at the address in [top], returning the byte
		// of the value at that address on the stack.
		//
peek_w_b:
		jsr pop_w_c
_peek_w_b_c:
		ldy #0
		lda (cl),y
		jmp push_b



		// PROCEDURE peek_w.
		//
		// [top] = memory[[top]]
		//
		// Peek at the address in [top], returning the word
		// of the value at that address on the stack.
		//
peek_w_w:
		jsr pop_w_c
		ldy #0
		lda (cl),y
		pha
		iny
		lda (cl),y
		tax
		pla
		jmp push_w


		// PROCEDURE poke_w_b.
		//
		// memory[[under]] = [top]
		//
		// Set the address at [under] to the byte [top].
		//
poke_w_b:
		jsr pop_b
		pha
		jsr pop_w_c
		pla
_poke_w_b_c:
		ldy #0
_poke_w_b_y:
		sta (cl),y
		rts


		// PROCEDURE poke_w_w.
		//
		// memory[[under]] = [top]
		//
		// Set the address at [under] to the word [top].
		//
poke_w_w:
		jsr pop_w
		sta dl
		stx dh
		jsr pop_w_c
		lda dl
		jsr _poke_w_b_c
		lda dh
		iny
		jmp _poke_w_b_y


		// previous instruction is always a push so safe to skip ldy
"hl(u)u":
		ldx datahi,y
		lda datalo,y
		jmp _full_end

		// HFD return high or low byte of uint
		// faster than var/256 or var%256
		// have to adjust the datastack pointer though
		// would be much better if done in compiler
"hi(u)u":
		lda datahi,y
		jmp _hilo_end

"lo(u)u":
		lda datalo,y
_hilo_end:
		ldx #0
_full_end:
		dey
		sty save_y
		rts

		// returns remainder from last division
		// -- if used right after division --
"getrmdr()u":
		jsr _mod_ww_rt		// set sign on remainder
		jmp pop_w		// returns in AX, not stack

		
		if (target == target_7800)

		// HFD
		// PROCEDURE movemem
		//
		// moves data segment from ROM space to RAM
		//
movemem:
		ldx #5			// copy to e,f,c pseudo-registers
_lp1:
		lda params,x
		sta el,x
		dex
		bpl _lp1

					// e= start  f= end  c= size
					// then move data
		LDY #0
		LDX ch
		BEQ _MD2
_MD1:
		LDA (el),y		// move a page at a time
		STA (fl),y
		INY
		BNE _MD1
		INC eh
		INC fh
		DEX
		BNE _MD1
_MD2:
		LDX cl
		BEQ _MD4
_MD3:
		LDA (el),y		// move the remaining bytes
		STA (fl),y
		INY
		DEX
		BNE _MD3
_MD4:
		RTS
		endif


		// GROUP Runtime Error.
		//


		// PROCEDURE rerror (report runtime error).
		//
		// Terminate reporting runtime error <A>.
		//
rerror:
		pha
                lda #(rerror_string % 256)
                ldx #(rerror_string / 256)
		jsr print_string_ax		// Print "RERROR "
		pla
		ldx #0
		jsr print_integer_ax		// Print the error #.
		if (target == target_aim)
		jmp 0xe1a1
		else
		jsr call_get_ch_cooked_a	// Wait for an Enter.
		brk				// Soft break.
		endif

		// HFD
		// set this so no data relocation at runtime

		if (target == target_vicx 	or
		    target == target_vicg 	or
		    target == target_vich 	or
		    target == target_vicu 	or
		    target == target_generic 	or
		    target == target_c64)
		  org	0xffff
dataseg:
		endif
		end
