//
// NAME:
//   upl_asm.h
// TITLE:
//   UPL/Quetzalcoatl: Assembler.
// FUNCTION:
//   -
//   -
//   -
// OBJECTS:
//   -
// METHODS:
//   -
// PREREQUISITES:
//   Common.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1998.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   July 17, 1998.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#ifndef UPL_ASM_H
#define UPL_ASM_H
#include "common.h"


typedef	byte	asm_opcode;


#define ASM_BRK		0
#define ASM_ORA_IX	1
#define ASM_ORA_Z	5
#define ASM_ASL_Z	6
#define ASM_PHP		8
#define ASM_ORA_IMM	9
#define ASM_ASL_A	10
#define ASM_ORA		13
#define ASM_ASL		14
#define ASM_BPL		16
#define ASM_ORA_IY	17
#define ASM_ORA_ZX	21
#define ASM_ASL_ZX	22
#define ASM_CLC		24
#define ASM_ORA_Y	25
#define ASM_ORA_X	29
#define ASM_ASL_X	30
#define ASM_JSR		32
#define ASM_AND_IX	33
#define ASM_BIT_Z	36
#define ASM_AND_Z	37
#define ASM_ROL_Z	38
#define	ASM_PLP		40
#define	ASM_AND_IMM	41
#define ASM_BIT		44
#define ASM_AND		45
#define ASM_ROL		46
#define ASM_BMI		48
#define ASM_AND_IY	49
#define ASM_AND_ZX	53
#define ASM_ROL_ZX	54
#define ASM_SEC		56
#define ASM_AND_Y	57
#define ASM_AND_X	61
#define ASM_ROL_X	62
#define ASM_RTI		64
#define ASM_EOR_IX	65
#define ASM_EOR_Z	69
#define ASM_LSR_Z	70
#define ASM_PHA		72
#define ASM_EOR_IMM	73
#define ASM_LSR_A	74
#define ASM_JMP		76
#define ASM_EOR		77
#define ASM_LSR		78
#define ASM_BVC		80
#define ASM_EOR_IY	81
#define ASM_EOR_ZX	85
#define ASM_LSR_ZX	86
#define ASM_CLI		88
#define ASM_EOR_Y	89
#define ASM_EOR_X	93
#define ASM_LSR_X	94
#define ASM_RTS		96
#define ASM_ADC_IX	97
#define ASM_ADC_Z	101
#define ASM_RCR_Z	102
#define ASM_PLA		104
#define ASM_ADC_IMM	105
#define ASM_RCR_A	106
#define ASM_JMP_I	108
#define ASM_ADC		109
#define ASM_ROR		110
#define ASM_BVS		112
#define ASM_ADC_IY	113
#define ASM_ADC_ZX	117
#define ASM_ROR_ZX	118
#define ASM_SEI		120
#define ASM_ADC_Y	121
#define ASM_ADC_X	125
#define ASM_ROR_X	126
#define ASM_STA_IX	129
#define ASM_STY_Z	132
#define ASM_STA_Z	133
#define ASM_STX_Z	134
#define ASM_DEY		136
#define ASM_TXA		138
#define ASM_STY		140
#define ASM_STA		141
#define ASM_STX		142
#define ASM_BCC		144
#define ASM_STA_IY	145
#define ASM_STY_ZX	148
#define ASM_STA_ZX	149
#define ASM_STX_ZY	150
#define ASM_TYA		152
#define ASM_STA_Y	153
#define ASM_TXS		154
#define ASM_STA_X	157
#define ASM_LDY_IMM	160
#define ASM_LDA_IX	161
#define ASM_LDX_IMM	162
#define ASM_LDY_Z	164
#define ASM_LDA_Z	165
#define ASM_LDX_Z	166
#define ASM_TAY		168
#define ASM_LDA_IMM	169
#define ASM_TAX		170
#define ASM_LDY		172
#define ASM_LDA		173
#define ASM_LDX		174
#define ASM_BCS		176
#define ASM_LDA_IY	177
#define ASM_LDY_ZX	180
#define ASM_LDA_ZX	181
#define ASM_LDX_ZY	182
#define ASM_CLV		184
#define ASM_LDA_Y	185
#define ASM_TSX		186
#define ASM_LDY_X	188
#define ASM_LDA_X	189
#define ASM_LDX_Y	190
#define ASM_CPY_IMM	192
#define ASM_CMP_IX	193
#define ASM_CPY_Z	196
#define ASM_CMP_Z	197
#define ASM_DEC_Z	198
#define ASM_INY		200
#define ASM_CMP_IMM	201
#define ASM_DEX		202
#define ASM_CPY		204
#define ASM_CMP		205
#define ASM_DEC		206
#define ASM_BNE		208
#define ASM_CMP_IY	209
#define ASM_CMP_ZX	213
#define ASM_DEC_ZX	214
#define ASM_CLD		216
#define ASM_CMP_Y	217
#define ASM_CMP_X	221
#define ASM_DEC_X	222
#define ASM_CPX_IMM	224
#define ASM_SBC_IX	225
#define ASM_CPX_Z	228
#define ASM_SBC_Z	229
#define ASM_INC_Z	230
#define ASM_INX		232
#define ASM_SBC_IMM	233
#define ASM_NOP		234
#define ASM_CPX		236
#define ASM_SBC		237
#define ASM_INC		238
#define ASM_BEQ		240
#define ASM_SBC_IY	241
#define ASM_SBC_ZX	245
#define ASM_INC_ZX	246
#define ASM_SED		248
#define ASM_SBC_Y	249
#define ASM_SBC_X	253
#define ASM_INC_X	254

typedef	enum
	{
	asm_imp,
	asm_imm,
	asm_ix,
	asm_iy,
	asm_zx,
	asm_zy,
	asm_x,
	asm_y,
	asm_z,
	asm_abs,
	asm_ind,
	asm_rel
	}
	asm_addr_mode;
#endif
