//
// NAME:
//   upl_cont.cpp
// TITLE:
//   UPL/Quetzalcoatl: Context.
// FUNCTION:
//   See header.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1998.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   July 6, 1998.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#include "implemen.h"
#include "upl.h"


#define		UPL_RETURN_PATCH_CHUNK		8


upl_Context::upl_Context(void)
{
  errors 		=
  warnings 		= 0;

  types	 		= upl_value_types;

  next_external_id	= RUNTIME_END+1;

  verbose		= 0;

  in_subroutine		= false;
  return_patches	= 0;
  subroutine_local_addr	= 0;


  string_conversion	=
  char_conversion	= upl_char_conversion_none;

  know_alignment	= false;
  page_align_bytes	= 0;
  needed_alignment	= false;

  has_auto_variables		= false;
  subroutine_local_addr 	=
  max_subroutine_local_addr	=
  auto_variable_addr		= 0;

  optimise_level	= 0;
  optimise_peephole	=
  optimise_flow		= false;

  list_file		= NULL;
};




void upl_Context::predefine_types(Flex& L)
{
  upl_Symbol	*S;


  S = symbols.declare(NULL, L, "void",    upl_void, 	 	upl_type, 0);
  S = symbols.declare(NULL, L, "byte",    upl_byte, 	 	upl_type, 0);
  S = symbols.declare(NULL, L, "boolean", upl_boolean, 	 	upl_type, 0);
  S = symbols.declare(NULL, L, "char",    upl_char, 	 	upl_type, 0);
  S = symbols.declare(NULL, L, "ushort",  upl_ushort,	 	upl_type, 0);
  S = symbols.declare(NULL, L, "short",   upl_short,	 	upl_type, 0);
  S = symbols.declare(NULL, L, "int",     upl_short,	 	upl_type, 0);
  S = symbols.declare(NULL, L, "byte*",   upl_pointer_byte,	upl_type, 0);
  S = symbols.declare(NULL, L, "char*",   upl_pointer_byte,	upl_type, 0);
  S = symbols.declare(NULL, L, "boolean*",upl_pointer_boolean,	upl_type, 0);
  S = symbols.declare(NULL, L, "ushort*", upl_pointer_ushort,	upl_type, 0);
  S = symbols.declare(NULL, L, "short*",  upl_pointer_short,	upl_type, 0);
  S = symbols.declare(NULL, L, "int*",    upl_pointer_short,	upl_type, 0);

  S = symbols.declare(NULL, 	L, "ioctl_cooked",     upl_byte, upl_constant, 0x00);
  S = symbols.declare(NULL, 	L, "ioctl_raw_wait",   upl_byte, upl_constant, 0x01);
  S = symbols.declare(NULL, 	L, "ioctl_raw_nowait", upl_byte, upl_constant, 0x80);

  S = symbols.declare(NULL, 	L, "true", 	     upl_char, upl_constant, 0xff);
  S = symbols.declare(NULL, 	L, "false", 	     upl_char, upl_constant,  0x0);
  S = symbols.declare(NULL, 	L, "endl", 	     upl_char, upl_constant, '\n');
}





void upl_Context::mark(upl_Context_state& Mark) const
{
  code.mark(Mark.code);
  data.mark(Mark.data);
}




void upl_Context::rollback(const upl_Context_state& Mark)
{
  code.rollback(Mark.code);
  data.rollback(Mark.data);
}




upl_value_type upl_Context::allocate_type(void)
{

#ifdef DJGPP
  long t = (long)types;
  types  = (upl_value_type)(t+1);
  return   (upl_value_type)t;
#elif defined(COMMON_DOS)
  return types++;
#else
  long t = (long)types;
  types  = (upl_value_type)(t+1);
  return   (upl_value_type)t;
#endif
}




void upl_Context::subroutine_begin(
	upl_value_type 	Return_value,
	boolean 	Return_immediate)
{
  return_patches     	= 0;

  in_subroutine	     	= true;

  return_value	     	= Return_value;
  return_immediate   	= Return_immediate;


  has_auto_variables		= false;
  subroutine_local_addr 	=
  max_subroutine_local_addr	=
  auto_variable_addr		= 0;
}




void upl_Context::subroutine_return(upl_addr Return_from_addr)
{
  if (return_patches >= return_patch.size())
    return_patch.size(return_patch.size()+UPL_RETURN_PATCH_CHUNK);

  return_patch[return_patches++] = Return_from_addr;
}




void upl_Context::subroutine_end(Flex& L, upl_addr Return_addr)
{
  for (long i=0; i<return_patches; i++)
    code.set_word(return_patch[i], Return_addr, upl_code_word);

  in_subroutine		= false;


  if (has_auto_variables)
    {
    code.set_byte(
	auto_variable_addr,
	max_subroutine_local_addr - local_parm_bytes);  // Literal value.

    if (max_subroutine_local_addr >= 255)
      L.parse_error("Too many parameters/auto variables in this subroutine");
    else
      if (max_subroutine_local_addr >= 128)
	L.parse_warning(
		"This subroutine so many parameters/auto variables "
		"that a stack overflow could result. "
		"Consider reducing parameters or "
		"declaring variables as \"static\".");
    }


}
