//
// NAME:
//   upl_expr.cpp
// TITLE:
//   UPL/Quetzalcoatl: Expressions.
// FUNCTION:
//   See header.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1998.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   July 17, 1998.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#include "upl.h"


void upl_Expr_result::set_constant_pointer(
	Flex&		L,
	upl_value_type 	Value_type,
	long 		Value)
{
  constant 	  = true;
  value    	  = Value;
  variable	  = NULL;
  transient       = upl_transient_none;
  is_pushed	  = false;

  value_type	  = upl_Compiler::convert_pointer(L, Value_type);
  value_bytes	  = 2;
}



void upl_Expr_result::set_constant(Flex& L, long Value)
{
  constant 	  = true;
  value    	  = Value;
  variable	  = NULL;
  transient       = upl_transient_none;
  is_pushed	  = false;

  Select(0 <= value and value <= 255)
      value_type  = upl_byte;
      value_bytes = 1;

    when(-127 <= value and value <= 128)
      value_type  = upl_char;
      value_bytes = 1;

    when(-32768L <= value and value <= 32767L)
      value_type  = upl_short;
      value_bytes = 2;

    when(0 <= value and value <= 65535)
      value_type  = upl_ushort;
      value_bytes = 2;

    otherwise
      L.parse_error("Number out of bounds");
  endsel

  indirection	=  0;
}




void upl_Expr_result::set_value_type(
	upl_value_type 	    Value_type,
	ushort		    Indirection,
	upl_transient_type  Transient,
	upl_Context_state  *Transient_state,
	upl_op		    Transient_op)

{
  value_type	= Value_type;
  value_bytes 	= upl_Compiler::value_bytes(Value_type);
  constant	= false;
  variable	= NULL;
  transient     = Transient;
  transient_op	= Transient_op;
  indirection	= Indirection;
  is_pushed	= false;

  if (Transient_state != NULL)
    transient_state = *Transient_state;
}




void upl_Expr_result::set_variable(const upl_Symbol& Variable)
{
  value_type	=  Variable.value_type;
  value_bytes 	=  Variable.value_bytes;
  constant	=  false;
  variable	= &Variable;
  transient     =  upl_transient_none;
  indirection	=  0;
  is_pushed	=  false;
}



void upl_Expr_result::set_transient_only(
	upl_transient_type  Transient,
	upl_Context_state  *Transient_state,
	upl_op		    Transient_op)
{
  transient     = Transient;
  transient_op	= Transient_op;

  if (Transient_state != NULL)
    transient_state = *Transient_state;
}

