//
// NAME:
//   upl_io.cpp
// TITLE:
//   UPL/Quetzalcoatl: Input/Output (Object Files).
// FUNCTION:
//   See header.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1998.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   September 19, 1998.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#include "upl.h"
#include "filehead.h"


#define	UPL_PATCH_MAGIC_BEGIN 0x070a9123
#define	UPL_PATCH_MAGIC_END   0x12e8089b

void upl_Patches::write(FILE *f, long Patches) const
{
  upl_Patch 	const *P;
  upl_Patch 	const *Q;
  long		count;
  byte		ch;
  long		ccount;
  ulong		magic;


  magic = UPL_PATCH_MAGIC_BEGIN;
#ifdef _sun__
  longswap(magic);
#endif
  bwrite1(&magic, f);


  ((upl_Patches *)this)->sort(Patches);


#ifdef _sun__
  longswap(Patches);
#endif
  bwrite1(&Patches, f);


  for (long i=0; i<Patches; )
    {
    P = &item[i];

    count = 1;
    for (long j=i+1; j<Patches; j++)
      {
      Q = &item[j];

      if (Q->external_id == P->external_id)
	count++;
      else
	break;
      }


#ifdef _sun__
    wordswap(P->external_id);
#endif
    bwrite1(&P->external_id, f);


//cerr << count << endl;
    ccount = count;
    do
      {
      ch = ccount bitand 0x7f;
      ccount >>= 7;
      if (ccount > 0)
        ch |= 0x80;

      bwrite1(&ch, f);
      }
    while (ccount > 0);


    for (long c=0; c<count; c++)
      {
      Q = &item[i+c];

#ifdef _sun__
    longswap(Q->addr);
#endif
      bwrite1(&Q->addr, f);
      bwrite1(&Q->patch_method, f);
      }

    i += count;
    }


  magic = UPL_PATCH_MAGIC_END;
#ifdef _sun__
    longswap(magic);
#endif
  bwrite1(&magic, f);
}




long upl_Patches::read(FILE *f)
{
  long patches;
  upl_Patch *P, temp;
  long	count;
  byte	ch;
  long  patch_i = 0;
  long	magic;

  bread1(&magic, f);
#ifdef FIXEND
  longswap(magic);
#endif
  assert(magic == UPL_PATCH_MAGIC_BEGIN);
  

  bread1(&patches, f);
#ifdef FIXEND
  longswap(patches);
#endif

  size(patches);


  while (patch_i < patches)
    {
    bread1(&temp.external_id, f);
#ifdef FIXEND
    wordswap(temp.external_id);
#endif
    count = 0;
    do
      {
      bread1(&ch, f);
      count = (count << 7) bitor (ch bitand 0x7f);
      }
    while (ch bitand 0x80);

    //cerr << count << endl;


    for (long c=0; c<count; c++)
      {
      assert(0 <= patch_i and patch_i < patches);

      // cerr << "patchi" << patch_i << ' ' << item[patch_i] << endl;

      P = &item[patch_i++];
      P->external_id = temp.external_id;
      bread1(&P->addr, f);
#ifdef FIXEND
	longswap(P->addr);
#endif
      bread1(&P->patch_method, f);
      }
    // cerr << patch_i << " < " << patches << " ==> " << (patch_i < patches) << endl;
    }


  bread1(&magic, f);
#ifdef FIXEND
  longswap(magic);
#endif
  assert(magic == UPL_PATCH_MAGIC_END);


  return patches;
}




int _cdecl compare_patch( const void *A, const void *B)
{
  const upl_Patch *PA = (const upl_Patch *)A;
  const upl_Patch *PB = (const upl_Patch *)B;


  Select(PA->external_id < PB->external_id)
      return -1;
    when(PA->external_id > PB->external_id)
      return  1;
    otherwise
      Select(PA->addr  < PB->addr)
	  return -1;
	when(PA->addr  > PB->addr)
	  return  1;
	otherwise
	  return  0;
      endsel
  endsel
}




void upl_Patches::sort(long Patches)
{
 qsort((void *)item, Patches, sizeof(upl_Patch), compare_patch);
}




void upl_Name::write(FILE *f) const
{
  boolean	found = false;
  ushort	name_length;

#ifdef NO_WARNINGS
  unsigned int name_i;
#else
  int name_i;
#endif

  for (name_i=0; name_i<=sizeof(name); name_i++)
    if (name[name_i] == 0)
      {
      found = true;
      break;
      }

  if (not found)
    name_i = sizeof(name);

  name_length = name_i;

#ifdef FIXEND
  wordswap(name_length);
#endif
  bwrite1(&name_length, f);
  bwrite(&name[0], name_i, f);
#ifdef FIXEND
  long addr2 = addr;
  longswap(addr2);
  bwrite1(&addr2, f);
#else
  bwrite1(&addr, f);
#endif
}




void upl_Name::read(FILE *f)
{
  ushort	name_length;

#ifdef NO_WARNINGS
  unsigned long		names;
#else
  long		names;
#endif

  bread1(&name_length, f);
#ifdef FIXEND
  wordswap(name_length);
#endif

  names = min(name_length, sizeof(name));

  bread(&name[0], names, f);

  if (names < sizeof(name))
    name[names] = 0;
  else if (names == sizeof(name))
    ;
  else if (names > sizeof(name))
    if (fseek(f, name_length-sizeof(name), SEEK_CUR) == 0)
      ;
    else
      abend(WHERE0, "Seek fail;  Corrupt OBJ file.");

  bread1(&addr, f);
#ifdef FIXEND
  longswap(addr);
#endif
}




void upl_Names::write(FILE *f, long Names) const
{
#ifdef FIXEND
  long Name2 = Names;
  longswap(Name2);
  bwrite1(&Name2, f);
#else
  bwrite1(&Names, f);
#endif

  for (long i=0; i<Names; i++)
    item[i].write(f);
}




long upl_Names::read(FILE *f)
{
  long 	names;

  bread1(&names, f);
#ifdef FIXEND
  longswap(names);
#endif

  size(names);

  for (long i=0; i<names; i++)
    item[i].read(f);

  return names;
}




void upl_Object::write(FILE *f) const
{

#ifdef FIXEND
  unsigned int rt=runtime_target;
  unsigned long fl=flags, ob=objects, rl=reloc_partners, aa=alignment_addr;
  wordswap(rt);
  longswap(fl);
  longswap(ob);
  longswap(rl);
  longswap(aa);
  bwrite1(&fl,	f);
  bwrite1(&rt,	f);
  bwrite1(&ob, 	f);
  bwrite1(&rl, 	f);
  bwrite1(&aa,	f);
#else
  bwrite1(&flags,		f);
  bwrite1(&runtime_target,	f);
  bwrite1(&objects, 		f);
  bwrite1(&reloc_partners, 	f);
  bwrite1(&alignment_addr,	f);
#endif
  bwrite1(&page_aligned,	f);
  bwrite1(&absolute_aligned,	f);

#ifdef NO_WARNINGS
  bwrite(object.item, (unsigned long)objects, 		   	f);
  bwrite(reloc.item, (unsigned long)objects, 		   	f);
  bwrite(reloc_partner.item, (unsigned long)reloc_partners, 	f);
#else
  bwrite(object.item, objects, 			   f);
  bwrite(reloc.item, objects, 			   f);
  bwrite(reloc_partner.item, reloc_partners, 	   f);
#endif

  names.write(f, names.size());
  external_names.write(f, external_names.size());

  patch.write(f, patches);

}




void upl_Object::read(FILE *f)
{
  bread1(&flags,		f);
  bread1(&runtime_target,	f);
  bread1(&objects, 		f);
  bread1(&reloc_partners, 	f);
  bread1(&alignment_addr,	f);
  bread1(&page_aligned,		f);
  bread1(&absolute_aligned,	f);
#ifdef FIXEND
  wordswap(runtime_target);
  longswap(flags);
  longswap(objects);
  longswap(reloc_partners);
  longswap(alignment_addr);
#endif

  object.size(objects);
  reloc.size(objects);
  reloc_partner.size(reloc_partners);

#ifdef NO_WARNINGS
  bread(object.item, (unsigned long)objects, 		  	f);
  bread(reloc.item, (unsigned long)objects, 			f);
  bread(reloc_partner.item, (unsigned long)reloc_partners, 	f);
#else
  bread(object.item, objects, 			  f);
  bread(reloc.item, objects, 			  f);
  bread(reloc_partner.item, reloc_partners, 	  f);
#endif

  names.read(f);
  external_names.read(f);

  patches = patch.read(f);
}




void upl_Segments::write(FILE *f) const
{
  bwrite(segment_name, sizeof(segment_name), f);
  code.write(f);
  data.write(f);

#ifdef FIXEND
  unsigned long ca=code_addr, da=data_addr;
  longswap(ca);
  longswap(da);
  bwrite1(&ca, 	f);
  bwrite1(&da, 	f);
#else
  bwrite1(&code_addr, 	f);
  bwrite1(&data_addr, 	f);
#endif
  bwrite1(&relocatable, f);
  bwrite1(&absolute, 	f);
}




void upl_Segments::read(FILE *f)
{
  bread(segment_name, sizeof(segment_name), f);
  code.read(f);
  data.read(f);
  bread1(&code_addr, 	f);
  bread1(&data_addr, 	f);
  bread1(&relocatable,  f);
  bread1(&absolute, 	f);
#ifdef FIXEND
  longswap(code_addr);
  longswap(data_addr);
#endif
}




void upl_Segments::write(const char *fn) const
{
  FILE *f;

  file_open(f, fn, "wb");

  co_File_header  header;
  header.magic	  = UPL_OBJ_MAGIC;
  header.version  = UPL_OBJ_VERSION;
  header.ready	  = false;

  bwrite1(&header, f);

  write(f);


  header.ready	  = true;
  if (fseek(f, 0, SEEK_SET) == 0)
    bwrite1(&header, f)
  else
    abend(WHERE0, "File seek error");


  fclose(f);
}



void upl_Segments::read(const char *fn)
{
  FILE *f;

  file_open(f, fn, "rb");

  co_File_header  header;
  bread1(&header, f);

  if (not header.ready)
    {
    cerr << "E: File \"" << fn << "\" is corrupted. "
	    "I suggest you delete the object file and recompile it.\n";
    exit(13);
    }


  if (header.magic != UPL_OBJ_MAGIC)
    {
    cerr << "E: File \"" << fn << "\" is not really a Quetzalcoatl OBJ file.\n";
    exit(11);
    }

  if (header.version < UPL_OBJ_COMPAT_VERSION)
    {
    cerr << "E: File \"" << fn << "\" was generated by an old, incompatible "
	    "version of Quetzalcoatl.  I suggest you delete the object file "
	    "and recompile it.\n";
    exit(12);
    }


  read(f);

  fclose(f);
}
