//
// NAME:
//   upl_link.h
// TITLE:
//   UPL/Quetzalcoatl: Linker.
// FUNCTION:
//   -
//   -
//   -
// OBJECTS:
//   -
// METHODS:
//   -
// PREREQUISITES:
//   Common.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1998.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   July 21, 1998.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#ifndef UPL_LINK_H
#define UPL_LINK_H
#include "upl.h"
class upl_Core
{
  public:
    Mantaray_long<byte>	core;
    long		cores;
    upl_addr		start_addr;
    upl_addr		entry_addr;
    byte   *physical_byte(upl_addr Target)
      {return &core[Target-start_addr];}
    ushort *physical_word(upl_addr Target)
      {return (ushort *)&core[Target-start_addr];}
    boolean save(const char *Exe_fn);
  public:
    upl_Core(void);
    void load(upl_addr Target, byte *Source, long Source_bytes); 
};
class upl_Link
{
  public:
    static boolean link(
	upl_Core&		     	Core,
	Stingray_long<upl_Segments>& 	Seg,
	int				Verbose,
	upl_addr&			Entry_addr,
	upl_addr			Default_start_addr,
	long&				Datastack);
    static void relocate(
	upl_Core&	Core,
	upl_addr	Reloc_addr,
	upl_Object&  	Map,
	upl_addr	Code_base_addr,
	upl_addr	Data_base_addr);
    static long patch_externals(
	upl_Core&	Core,
	upl_addr	Base_addr,
	upl_Object&	Object,
	common_Keys&	Names,
	const char     *Object_name);
    static
    boolean alignment_check(
	const char     *Object_name,
	const char     *Segment_name,
	upl_Object&	Object,
	long		Actual_addr);
};
#endif
