//
// NAME:
//   upl_obje.cpp
// TITLE:
//   UPL/Quetzalcoatl: Object Code.
// FUNCTION:
//   See header.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1998.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   July 6, 1998.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#include "upl.h"


#define	  UPL_OBJECT_CHUNK		(1024)
#define	  UPL_PATCH_CHUNK		(32)
#define	  UPL_RELOC_PARTNER_CHUNK	(32)


upl_Object::upl_Object(void)
{
  objects 	    =
  patches 	    =
  reloc_partners    =
  alignment_addr    = 0;
  page_aligned	    =
  absolute_aligned  = false;
  runtime_target    = 0;
  flags		    = 0;
}




upl_addr upl_Object::out(
	byte		Value,
	upl_reloc_type 	Reloc)
{
  if (objects+1 >= object.size())
    {
    object.size(object.size() + UPL_OBJECT_CHUNK);
    reloc.size( reloc.size()  + UPL_OBJECT_CHUNK);
    }

  object[objects] = Value;
  reloc[objects]  = Reloc;

  return objects++;
}


upl_addr upl_Object::out_word(
	word		Value,
	upl_reloc_type 	Reloc)
{
  upl_addr begin_addr = objects;

  switch (Reloc bitand upl_reloc_datatype)
    {
    case upl_reloc_byte_lo:
      if (reloc_partners+1 >= reloc_partner.size())
	reloc_partner.size(reloc_partner.size()+UPL_RELOC_PARTNER_CHUNK);

      reloc_partner[reloc_partners++] = (Value>>8);
      out((byte)(Value),    Reloc);
      break;

    case upl_reloc_byte_hi:
      if (reloc_partners+1 >= reloc_partner.size())
	reloc_partner.size(reloc_partner.size()+UPL_RELOC_PARTNER_CHUNK);

      reloc_partner[reloc_partners++] = (Value);
      out((byte)(Value>>8),    Reloc);
      break;

    default:
      out((byte)(Value),    Reloc);
      out((byte)(Value>>8));
    }


  return begin_addr;
}




upl_addr upl_Object::out_addr_code(ushort Addr)
{
  upl_addr begin_addr = objects;

  out((byte)(Addr),    upl_code_word);
  out((byte)(Addr>>8));

  return begin_addr;
}




upl_addr upl_Object::out_addr_data(ushort Addr)
{
  upl_addr begin_addr = objects;

  out((byte)(Addr),    upl_data_word);
  out((byte)(Addr>>8));

  return begin_addr;
}




upl_addr upl_Object::out_string(const char *String, const upl_Context& C)
{
  upl_addr	begin_addr = objects;

  const char *p=String;

  loop
    {
    if (C.string_conversion == upl_char_conversion_none)
      out((byte)*p);
    else
      out((byte)upl_Compiler::convert_char(*p, C.string_conversion));

    if (*p == 0)
      break;
    else
      p++;
    }

  return begin_addr;
}




// Generates code to push this value on the stack.
//
void upl_Object::push_value(long Value, boolean Force_word)
{
  if ((0 <= Value and Value <= 255) and not Force_word)
    {
    out(ASM_LDA_IMM);
    out(Value);
    out(ASM_JSR);
    out_word_patch(RUNTIME_PUSH_B);
    }
  else
    {
    out(ASM_LDA_IMM);
    out((byte)(Value));
    out(ASM_LDX_IMM);
    out((byte)(Value>>8));
    out(ASM_JSR);
    out_word_patch(RUNTIME_PUSH_W);
    }
}



void upl_Object::set_word(
	long 		Object_i,
	word 		Value,
	upl_reloc_type 	Reloc)
{
  object[Object_i] 	= Value;
  reloc[Object_i]  	= Reloc;

  object[Object_i+1]	= (Value >> 8);
  reloc[Object_i+1]  	= 0;
}




void upl_Object::set_byte(
	long 		Object_i,
	byte 		Value,
	upl_reloc_type 	Reloc)
{
  object[Object_i] 	= Value;
  reloc[Object_i]  	= Reloc;
}




void upl_Object::mark(upl_Object_state& State) const
{
  State.objects = objects;
  State.patches = patches;
}




void upl_Object::rollback(const upl_Object_state& State)
{
  objects = State.objects;
  patches = State.patches;
}




void upl_Object::add_patch(
	upl_external_id	 External_id,
	upl_patch_method Patch_method)
{
  if (patches+1 >= patch.size())
    patch.size(patch.size() + UPL_PATCH_CHUNK);


  patch[patches].external_id	= External_id;
  patch[patches].addr		= objects;
  patch[patches].patch_method	= Patch_method;


  patches++;
}



// Used to output a word to be linked.
//
void upl_Object::out_word_patch(
    upl_external_id	External_id,
    upl_patch_method 	Patch_method,
    ushort		Content)
{
  add_patch(External_id, Patch_method);
  switch (Patch_method)
    {
    case upl_patch_method_set_high:
    case upl_patch_method_set_low:
      out(External_id, upl_reloc_none);
      break;

    default:
      out_word(Patch_method == upl_patch_method_none ? External_id : Content,
	     upl_reloc_none);
    }
}




void upl_Object::add_name(Flex& L, const char *Name, upl_addr Addr)
{
  long name_i = names.size();

  for (long i=0; i<names.size(); i++)
    if (equal(Name, names[i].name))
      L.parse_error("Duplicate identifier");

  names.size(name_i+1);
  strcpy(names[name_i].name, Name);
  names[name_i++].addr = Addr;
}




void upl_Object::add_external_name(
	Flex& 		L,
	const char     *Name,
	upl_external_id External_id)
{
  long name_i = external_names.size();

  for (long i=0; i<external_names.size(); i++)
    if (equal(Name, external_names[i].name))
      L.parse_error("Duplicate identifier");

  external_names.size(name_i+1);
  strcpy(external_names[name_i].name, Name);
  external_names[name_i++].addr = External_id;
}
