//
// NAME:
//   upl_oprt.cpp
// TITLE:
//   Upl: Object: Print Method.
// FUNCTION:
//   See header.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1998.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   October 1, 1998.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#include "upl.h"
#include <ctype.h>


typedef	enum
	{
	upl_imm
	}
	upl_amode;


const char *opcode[] =
{
"BRK",				// 0
"ORA_IX",			// 1
NULL,				// 2
NULL,                           // 3
NULL,                           // 4
"ORA_Z",			// 5
"ASL_Z",			// 6
NULL,			 	// 7
"PHP",				// 8
"ORA_IMM",			// 9
"ASL_AA",			// 10
NULL,		  		// 11
NULL,                           // 12
"ORA_A",			// 13
"ASL_A",			// 14
NULL,				// 15
"BPL_REL",			// 16
"ORA_IY",			// 17
NULL,
NULL,
NULL,
"ORA_ZX",			// 21
"ASL_ZX",			// 22
NULL,
"CLC",				// 24
"ORA_Y",			// 25
NULL,
NULL,
NULL,
"ORA_X",			// 29
"ASL_X",			// 30
NULL,
"JSR_A",			// 32
"AND_IX",			// 33
NULL,
NULL,
"BIT_Z",			// 36
"AND_Z",			// 37
"ROL_Z",			// 38
NULL,
"PLP",				// 40
"AND_IMM",			// 41
"ROL_AA",
NULL,
"BIT_A",			// 44
"AND_A",			// 45
"ROL_A",			// 46
NULL,
"BMI_REL",			// 48
"AND_IY",			// 49
NULL,
NULL,
NULL,
"AND_ZX",			// 53
"ROL_ZX",			// 54
NULL,
"SEC",				// 56
"AND_Y",			// 57
NULL,
NULL,
NULL,
"AND_X",			// 61
"ROL_X",			// 62
NULL,
"RTI",				// 64
"EOR_IX",			// 65
NULL,
NULL,
NULL,
"EOR_Z",			// 69
"LSR_Z",			// 70
NULL,
"PHA",				// 72
"EOR_IMM",			// 73
"LSR_AA",			// 74
NULL,
"JMP_A",			// 76
"EOR_A",			// 77
"LSR_A",			// 78
NULL,
"BVC_REL",			// 80
"EOR_IY",			// 81
NULL,
NULL,
NULL,
"EOR_ZX",			// 85
"LSR_ZX",			// 86
NULL,
"CLI",				// 88
"EOR_Y",			// 89
NULL,
NULL,
NULL,
"EOR_X",			// 93
"LSR_X",			// 94
NULL,
"RTS",				// 96
"ADC_IX",			// 97
NULL,
NULL,
NULL,
"ADC_Z",			// 101
"ROR_Z",			// 102
NULL,
"PLA",				// 104
"ADC_IMM",			// 105
"ROR_AA",			// 106
NULL,
"JMP_I",			// 108
"ADC_A",			// 109
"ROR_A",			// 110
NULL,
"BVS_REL",			// 112
"ADC_IY",			// 113
NULL,
NULL,
NULL,
"ADC_ZX",			// 117
"ROR_ZX",			// 118
NULL,
"SEI",				// 120
"ADC_Y",			// 121
NULL,
NULL,
NULL,
"ADC_X",			// 125
"ROR_X",			// 126
NULL,
NULL,
"STA_IX",			// 129
NULL,
NULL,
"STY_Z",			// 132
"STA_Z",			// 133
"STX_Z",			// 134
NULL,
"DEY",				// 136
NULL,
"TXA",				// 138
NULL,
"STY_A",			// 140
"STA_A",			// 141
"STX_A",			// 142
NULL,
"BCC_REL",			// 144
"STA_IY",			// 145
NULL,
NULL,
"STY_ZX",			// 148
"STA_ZX",			// 149
"STX_ZY",			// 150
NULL,
"TYA",				// 152
"STA_Y",			// 153
"TXS",				// 154
NULL,
NULL,
"STA_X",			// 157
NULL,
NULL,
"LDY_IMM",			// 160
"LDA_IX",			// 161
"LDX_IMM",			// 162
NULL,
"LDY_Z",			// 164
"LDA_Z",			// 165
"LDX_Z",			// 166
NULL,
"TAY",				// 168
"LDA_IMM",			// 169
"TAX",				// 170
NULL,
"LDY_A",			// 172
"LDA_A",			// 173
"LDX_A",			// 174
NULL,
"BCS_REL",			// 176
"LDA_IY",			// 177
NULL,
NULL,
"LDY_ZX",			// 180
"LDA_ZX",			// 181
"LDX_ZY",			// 182
NULL,
"CLV",				// 184
"LDA_Y",			// 185
"TSX",				// 186
NULL,
"LDY_X",			// 188
"LDA_X",			// 189
"LDX_Y",			// 190
NULL,
"CPY_IMM",			// 192
"CMP_IX",			// 193
NULL,
NULL,
"CPY_Z",			// 196
"CMP_Z",			// 197
"DEC_Z",			// 198
NULL,
"INY",				// 200
"CMP_IMM",			// 201
"DEX",				// 202
NULL,
"CPY_A",			// 204
"CMP_A",			// 205
"DEC_A",			// 206
NULL,
"BNE_REL",			// 208
"CMP_IY",			// 209
NULL,
NULL,
NULL,
"CMP_ZX",			// 213
"DEC_ZX",			// 214
NULL,
"CLD",				// 216
"CMP_Y",			// 217
NULL,
NULL,
NULL,
"CMP_X",			// 221
"DEC_X",			// 222
NULL,
"CPX_IMM",			// 224
"SBC_IX",			// 225
NULL,
NULL,
"CPX_Z",			// 228
"SBC_Z",			// 229
"INC_Z",			// 230
NULL,
"INX",				// 232
"SBC_IMM",			// 233
"NOP",				// 234
NULL,
"CPX_A",			// 236
"SBC_A",			// 237
"INC_A",			// 238
NULL,
"BEQ_REL",			// 240
"SBC_IY",			// 241
NULL,
NULL,
NULL,
"SBC_ZX",			// 245
"INC_ZX",			// 246
NULL,
"SED",				// 248
"SBC_Y",			// 249
NULL,
NULL,
NULL,
"SBC_X",			// 253
"INC_X",			// 254
NULL
};




ostream& operator << (ostream& Str, const upl_Object& U)
{
  long	p;
  char const  *S;
  byte	o;
  byte 	parms;
  char  const *M;
  ushort w;

#ifdef NO_WARNINGS
  byte	rel = 0;
#else
  byte	rel;
#endif

  char  const *prefix, *suffix;
  long	patch_i = 0;
  upl_Patch const *P;
  ushort base;
  long	name_i  = 0;

#ifndef NEWCPP
  Str << hex;
#else
  Str << std::hex;
#endif

  char filler = Str.fill('0');


  for (p=0; p<U.objects; p++)
    {
    while (name_i < U.names.size() and U.names[name_i].addr == p)
      Str << p << "\t\"" << U.names[name_i++].name << "\":\n";


    Str << p << '\t';


    S = opcode[o=U.object[p]];


    if (S != NULL)
      {
      M = &S[3];

      parms  = 0;
      prefix =
      suffix = NULL;

      Select(equal(M, "_IMM"))
	  prefix = " #";
	  parms  = 1;

	when(equal(M, "_AA"))
	  prefix = " ";
	  parms  = 0;
	  suffix="a";

	when(equal(M, "_A"))
	  prefix = " ";
	  parms  = 2;

	when(equal(M, "_Z"))
	  prefix = " ";
	  parms  = 1;

	when(equal(M, "_X"))
	  parms  = 2;
	  prefix = " ";
	  suffix = ",x";

	when(equal(M, "_Y"))
	  parms  = 2;
	  prefix = " ";
	  suffix = ",y";

	when(equal(M, "_ZX"))
	  prefix = " ";
	  parms  = 1;
	  suffix = ",x";

	when(equal(M, "_ZY"))
	  prefix = " ";
	  parms  = 1;
	  suffix = " ,y";

	when(equal(M, "_IX"))
	  prefix = " (";
	  parms  = 1;
	  suffix = ",x)";

	when(equal(M, "_IY"))
	  prefix = " (";
	  parms  = 1;
	  suffix = "),y";

	when(equal(M, "_REL"))
	  prefix = " ";
	  parms  = 1;

	otherwise
	  ;
      endsel


      Str.width(2);
      Str << (ushort)U.object[p];

      for (int i=1; i<=2; i++)
	if (i<=parms)
	  {
	  Str << ' ';
	  Str.width(2);
	  Str << (ushort)U.object[p+i];
	  }
	else
	  Str << "   ";

      Str << "  ";


      base = p+1;
      if (parms > 0)
	rel = U.reloc[p+1];


      Str << (char)tolower(S[0])
	  << (char)tolower(S[1])
	  << (char)tolower(S[2]);
      if (prefix) Str << prefix;

      switch (parms)
	{
	case 0:
	  break;

	case 1:
	  {
	  boolean printed = false;

	  if (patch_i < U.patch.size() and base == U.patch[patch_i].addr)
	    {
	    P = &U.patch[patch_i];


	    switch (P->patch_method)
	      {
	      case upl_patch_method_set_high:	Str << "MSB("; break;
	      case upl_patch_method_set_low:	Str << "LSB("; break;
	      default:;
	      }

	    if (P->external_id <= RUNTIME_END)
	      Str << runtime[P->external_id];
	    else
	      Str << U.external_names[P->external_id-(RUNTIME_END+1)].name;


	    switch (P->patch_method)
	      {
	      case upl_patch_method_set_high:
	      case upl_patch_method_set_low:
		Str << ")";
		printed = true; p++;
		break;

	      case upl_patch_method_none:
		printed = true; p++;
		break;

	      case upl_patch_method_add:
		Str << '+';
		break;

	      default:;
	      }

	    patch_i++;
	    }


	  if (not printed)
	    if (equal(M, "_REL"))
	      {
	      Str.width(2);
	      Str << (ushort)(p+2+(signed char)U.object[p+1]);
	      p++;
	      }
	    else
	      {
	      Str.width(2);
	      Str << (ushort)U.object[++p];
	      }
	  break;
	  }

	case 2:
	  {
	  boolean printed = false;

	  if (patch_i < U.patch.size() and base == U.patch[patch_i].addr)
	    {
	    P = &U.patch[patch_i];


	    if (P->external_id <= RUNTIME_END)
	      Str << runtime[P->external_id];
	    else
	      Str << U.external_names[P->external_id-(RUNTIME_END+1)].name;


	    switch (P->patch_method)
	      {
	      case upl_patch_method_none:  printed = true; p += 2; break;
	      case upl_patch_method_add:  Str << '+'; break;
	      default:;
	      }

	    patch_i++;
	    }


	  if (not printed)
	    {
	    w = U.object[++p];
	    w = w bitor (((ushort)U.object[++p]) << 8);
            Str.width(4);
	    Str << (ushort)w;
	    }
	  }
	  break;

	default:;
	}

      if (suffix) Str << suffix;


      if (parms > 0 and rel != upl_reloc_none)
	{
	Str << "\t; Relocate ";

	switch (rel bitand upl_reloc_segment)
	  {
	  case upl_reloc_data:  Str << "data"; break;
	  case upl_reloc_code:  Str << "code"; break;
	  default:;
	  }

	switch (rel bitand upl_reloc_datatype)
	  {
	  case upl_reloc_word:	  Str << " word";	break;
	  case upl_reloc_byte_lo: Str << " low byte";   break;
	  case upl_reloc_byte_hi: Str << " high byte";  break;
	  default:;
	  }
	}

      Str << endl;
      }
    else
      Str << "E: Illegal Opcode (" << (ushort)o << ")\n";
    }


  Str.fill(filler);
#ifndef NEWCPP
  Str << dec;
#else
  Str << std::dec;
#endif


  return Str;
}
