//
// NAME:
//   upl_prt.cpp
// TITLE:
//   UPL/Quetzalcoatl: Print.
// FUNCTION:
//   See header.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1998.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   July 21, 1998.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#include "upl.h"


ostream& operator << (ostream& Str, const upl_Patch& P)
{
  char const *S = NULL;

#ifndef NO_WARNINGS
  char const *C = NULL;
#endif

  /*
  switch (P.reloc bitand upl_reloc_datatype)
    {
    case upl_reloc_word:	S = "word "; 		break;
    case upl_reloc_byte_lo:	S = "byte low "; 	break;
    case upl_reloc_byte_hi:	S = "byte high ";	break;
    default:      		S = "";
    }
    */

  switch (P.patch_method) // WAS [bj 08oct2006]: switch (P.patch_method == upl_patch_method_none)
    {
    case upl_patch_method_none:	    S = "Set "; break;
    case upl_patch_method_add:      S = "Add "; break;
    case upl_patch_method_set_high: S = "Set High Byte "; break;
    case upl_patch_method_set_low:  S = "Set Low  Byte "; break;

    }

  Str << S;

//HFD gcc2.95.2 says it "is always true due to limited range of data type"
#ifdef NO_WARNINGS
  if ((0 <= P.external_id) and (P.external_id <= RUNTIME_END))
#else
  if (0 <= P.external_id and P.external_id <= RUNTIME_END)
#endif

    Str << runtime[P.external_id];
  else
    Str << P.external_id;


  return Str << ' ' << "at " << P.addr;
}
