//
// NAME:
//   upl_runt.h
// TITLE:
//   UPL/Quetzalcoatl: Runtime Library Interface.
// FUNCTION:
//   -
//   -
//   -
// OBJECTS:
//   -
// METHODS:
//   -
// PREREQUISITES:
//   Common.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1998.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   July 17, 1998.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#ifndef UPL_RUNT_H
#define UPL_RUNT_H
#include "common.h"


extern char const *runtime[];



#define	 RUNTIME_CL	        251
#define	 RUNTIME_CH	        252
#define	 RUNTIME_BP		255



#define	 RUNTIME_INIT		 0

#define  RUNTIME_PUSH_B		 1
#define  RUNTIME_PUSH_W		 2
#define  RUNTIME_POP_B		 3
#define  RUNTIME_POP_W		 4

#define  RUNTIME_SWAP_BB         5
#define  RUNTIME_SWAP_WW	 6

#define  RUNTIME_CAST_B2W	 7
#define  RUNTIME_CAST_C2W	 8
#define  RUNTIME_CAST_W2B	 9
//#define  RUNTIME_CAST_W2B	 10

#define  RUNTIME_AND_BB         11
#define  RUNTIME_AND_WW         12
#define  RUNTIME_OR_BB          13
#define  RUNTIME_OR_WW          14
#define  RUNTIME_EQ_BB          15
#define  RUNTIME_EQ_WW          16
#define  RUNTIME_NE_BB          17
#define  RUNTIME_NE_WW          18
#define  RUNTIME_LE_BB          19
#define  RUNTIME_LE_WW          20
#define  RUNTIME_LT_BB          21
#define  RUNTIME_LT_WW          22
#define  RUNTIME_GT_BB          23
#define  RUNTIME_GT_WW          24
#define  RUNTIME_GE_BB          25
#define  RUNTIME_GE_WW          26
#define  RUNTIME_UMUL_WW        27
#define  RUNTIME_MUL_WW         28
#define  RUNTIME_UDIV_WW        29
#define  RUNTIME_DIV_WW         30
#define  RUNTIME_ADD_BB         31
#define  RUNTIME_ADD_WW         32
#define  RUNTIME_SUB_BB         33
#define  RUNTIME_SUB_WW         34
#define  RUNTIME_NOT_BB         35
#define  RUNTIME_NOT_WW         36
#define  RUNTIME_NEG_BB         37
#define  RUNTIME_NEG_WW         38

#define	 RUNTIME_PRINT_CH_B		41
#define	 RUNTIME_PRINT_INTEGER_W	42
#define	 RUNTIME_PRINT_STRING_W		43

#define	 RUNTIME_PRINT_CH_A		44
#define	 RUNTIME_PRINT_INTEGER_AX	45
#define	 RUNTIME_PRINT_STRING_AX	46

#define  RUNTIME_ULE_BB          47
#define  RUNTIME_ULE_WW          48
#define  RUNTIME_ULT_BB          49
#define  RUNTIME_ULT_WW          50
#define  RUNTIME_UGT_BB          51
#define  RUNTIME_UGT_WW          52
#define  RUNTIME_UGE_BB          53
#define  RUNTIME_UGE_WW          54


#define  RUNTIME_POP_W_C         55
#define  RUNTIME_POP_B_C         56
#define  RUNTIME_PUSH_W_C        57
#define  RUNTIME_PUSH_B_C        58

#define  RUNTIME_UMOD_WW        59
#define  RUNTIME_MOD_WW         60

#define	 RUNTIME_GET_CH_A	61
#define	 RUNTIME_GET_CH_B	62

#define	RUNTIME_PUSH_N          63
#define	RUNTIME_POP_N          	64
#define	RUNTIME_PROLOG          65
#define	RUNTIME_EPILOG		66

#define	RUNTIME_PEEK_W_B        67
#define	RUNTIME_POKE_W_B	68

#define	RUNTIME_IOCTL		69

#define	RUNTIME_DATASTACK	70

#define	RUNTIME_PRINT_INTEGER_AX_SIGNED	71
#define RUNTIME_EXTEND_AX	72

#define RUNTIME_PRINT_NL	73

#define	RUNTIME_PEEK_W_W        74
#define	RUNTIME_POKE_W_W	75

#define	 RUNTIME_END		200
#endif
