//
// NAME:
//   upl_symb.cpp
// TITLE:
//   UPL/Quetzalcoatl: Symbols.
// FUNCTION:
//   See header.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1998.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   July 6, 1998.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#include "upl.h"


#define	UPL_PATCH_CHUNK	(16)




upl_Symbol::upl_Symbol(
	const char       *Token,
	upl_value_type	  Token_type,
	upl_symbol_type	  Symbol_type,
	long		  Value,
	ushort		  Count,
	long		  External_id,
	const upl_Symbol *Type)
{
  strncpy(token, Token, sizeof(token));
  value_type	= Token_type;
  symbol_type	= Symbol_type;
  value		= Value;
  count		= Count;

  if (Type)
    value_bytes = Type->size_bytes;
  else
    value_bytes	= upl_Compiler::value_bytes(Token_type, false);

  size_bytes	= value_bytes * max(count, 1);
  external_id	= External_id;
  within_page	= true;
  indirection	= 0;
  type		= Type;
  is_local	= false;
  fast		= false;
  in_local_storage	= false;
}






const upl_Symbol *upl_Symbols::get(
	Flex&		L,
	const char     *Token,
	const boolean	Mandatory) const
{
  const upl_Symbol *result = symbols.get(Token);


  if (result == NULL)
    {
    for (long local_i=0; local_i<locals; local_i++)
      if (local.occupied(local_i))
	if (strncmp(local[local_i].token, Token,
	     sizeof(local[local_i].token)) == 0)
	  {
	  result = &local[local_i];
	  break;
	  }

    if (result == NULL)
      if (Mandatory)
	L.parse_error("Undeclared identifier");
    }


  return result;
}




upl_Symbol *upl_Symbols::declare(
	ostream		 *List_stream,
	Flex&		  L,
	const char       *Token,
	upl_value_type	  Token_type,
	upl_symbol_type	  Symbol_type,
	long		  Value,
	ushort		  Count,
	boolean		  Local,
	long		  External_id,
	const upl_Symbol *Type)
{
  upl_Symbol *S =
	new upl_Symbol(Token, Token_type, Symbol_type,
		       Value, Count, External_id, Type);
  mcheck(S);


  S->is_local = Local;
  if (Local)
    {
    for (long i=0; i<locals; i++)
      if (equal(local[i].token, Token))
	L.parse_error("Identifier already declared");

    if (locals >= local.size())
      local.size(locals+1);

    local.set(locals++, S);
    }
  else if (not symbols.insert(S))
    L.parse_error("Identifier already declared");

  if (not Local and List_stream != NULL)
    {
    char const *S;

    switch (Symbol_type)
      {
      case upl_variable:	S = "variable"; break;
      //case upl_function:        S = "function"; break;
      //case upl_procedure:       S = "procedure"; break;
      default:			S = NULL;
      }

    if (S != NULL)
#ifndef NEWCPP
      *List_stream << hex << Value << dec << "\t"
		   << Token << ":\t\t\t; " << S << endl;
#else
      *List_stream << std::hex << Value << std::dec << "\t"
		   << Token << ":\t\t\t; " << S << endl;
#endif

    }


  return S;
}



upl_Symbols::upl_Symbols(void)
{
  locals = 0;
  reset_locals();
}


void upl_Symbols::reset_locals(void)
{
  local.purge();
  locals = 0;
}



long upl_Symbols::release_locals(long Locals)
{
  for (long i=Locals; i<locals; i++)
    if (local.occupied(i))
      {
      delete &local[i];

      local.set(i, NULL);
      }

  locals = Locals;

  return locals;
}
