//
// NAME:
//   upl_util.h
// TITLE:
//   UPL/Quetzalcoatl: Utility Routines.
// FUNCTION:
//   See header.
//
// AUTHOR:
//   Brendan Jones. (Contact through www.kdef.com/geek/vic)
// RIGHTS:
//   (c) Copyright Brendan Jones, 1998.  All Rights Reserved.
// SECURITY:
//   Unclassified.  
// LEGAL NOTICE:
//   See legal.txt before viewing, modifying or using this software.
// CONTACT:
//   Web:	http://www.kdef.com/geek/vic
//   Email:	See www.kdef.com/geek/vic
// DATE:
//   July 17, 1998.
// RIGHTS:
//  This file is part of The Quetzalcoatl Compiler.
//  
//  The Quetzalcoatl Compiler is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//  
//  The Quetzalcoatl Compiler is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with The Quetzalcoatl Compiler; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
//
// MODIFICATIONS:
//   NAME  MOD  DATE     DESCRIPTION
//
//
#include "upl.h"


int upl_Utility::count_bits(ulong Value)
{
  int result_bits = 0;


  for (int i=0; i<32; i++)
    {
    if (Value bitand 1)
      result_bits++;

    Value >>= 1;
    }


  return result_bits;
}



int upl_Utility::log2(ulong Value)
{
  for (int i=0; i<32; i++)
    {
    if (Value bitand 1)
      return i;

    Value >>= 1;
    }


  abend(WHERE0, "Log2 of 0 is infinity");
  #ifdef COMMON_NOREACHED
  return 0;
  #endif
}
