Introduction to QDOS
--------------------

1) What is QDOS ?
    QDOS is an Operatingsystem designed for small 68000 computers,
    which provides multitasking, a virtual device interface for grafics,
    an easy to program device driver interface, and last, but not least
    a highly sophisticated structured and expandable resident command
    language interpreter called "SuperBASIC". Since it was first
    implemented on a computer with only 128K RAM and 48K ROM this
    operating system and its supporting Software and compilers are
    small and very efficient, mostly programmed directly in native
    68000 machinecode. This makes QDOS the ultimate operating system
    for all small computers like for example the Amiga 500 and single
    board controller computers, which can use a  real time operating
    system and the whole support software for their applications.
    QDOS was written by Tony Tebby, who has my deep respect for this.

2) Why QDOS ?
    You may now say, why bothering with QDOS when I have Amiga DOS, which
    provides multitasking too, and can use all the fuzzy features of the
    Amiga without any effort ?
    Okay, you are a real horsetrader. Take for example the pretty serial
    interface, isn't it nice ?  It looks really good, and the preferences
    can be set to any value, but this does not mean, that these values
    have anything to do with what is happening in the head of the Amiga.
    So the handshake lines have a really unsatisfactory live, allways
    ignored by the software. Or what's about getting rid of a task which
    has become superfluos, try throwing it in the nice Trashcan of your
    Workbench. But don't tell it to the Guru, he may get angry !
    Enough ? Oh no, There is another bill concerning the rundimentary
    command line interpreter, and this unbelievable stupid Amiga BASIC.
    ...I stop here, because I get headache when I think about it.
    But I can tell you, what are the real advantages:
    1) You can easily intervent in every software and datafiles, since
       QDOS is small and surveyly. QDOS is (at least on the QL) a higly
       reliable operating system, which is hardly crashed
    2) Software devellopment using Superbasic and a compiler is an easy
       interactive process.
       For small problems this is by far the fastest solution
    3) You have a very nice operating system for develloping realtime
       applications for single board computers for measurement and
       controll
    4) QDOS is (directliy behind MS-DOS) one of the mostly emulated
       Operating systems. It is implemented for example on the Atari ST,
       now on the Amiga, and on a series of dedicated computers:
       the Sinclair QL, the OPD, the Thor, and the Futura.


3) Introduction to SuperBASIC
  *) QDOS special keys
       <Ctrl><F5>    freezes the screen (Hold Screen on normal Terminals)
       <Ctrl><Space> Break for BASIC programms, Leaves EXEC_W programs
       <Ctrl><Alt><7> (N)MI BASIC Warmstart
       <Ctrl><Alt><Shift><Amiga><Return> QDOS 200K cold start

  a) general structure
       Superbasic programs consists of lines, which start with a positive
       non zero integer, and contain one or more statements, which are
       separated by ":". Identifiers are separated by any non zero
       number of spaces. Identifiers can  consist of letters, numbers
       and the underliner. The length of names is only restricted by
       the amount of typing work, you want to spend. Names  are not
       case sensitive.  Integer Functions and variables are identified
       by a trailing "%", String functions and Variables have a trailing
       "$". String constants can be enclosed in single or double qoute.
       The ":" has the function of a null statement and can therefore
       be the only statment on a line. Comments are introduced by a
       REMark statment, which can be abrieviated by REM.

       DATA items are separated by "," where String type items must be
       enclosed in single or double qoute. The DATA statement must be
       the first statement on a line. This line is treated as comment.
       You can read DATA by a READ var[,var2,...] statement. The DATA
       pointer can be restored to any linenumber by a RESTORE [n]
       statement

  b) structured loops
       There are only two types of loops, but they have powerfull extras:
       The First one is the FOR loop, which looks like follows:

       FOR index=start_expr TO end_expr [STEP expr]
          ....
          [NEXT index]
          ....
          [EXIT index]
          ....
       END FOR index

       index must be a floating point variable, the STEP expression
       can be non integer, default is 1.
       FOR loops are enclosed between FOR ... END FOR index.
       In a single line FOR loop, the END FOR terminator can be omitted
       The NEXT keyword jumps back to the FOR statement, whereas
       the EXIT statement forces a jump behind the END FOR statement.

       The second loop is the REPeat loop:
       REPeat loop_name
          ....
          [NEXT loop_name]
          ....
          [EXIT loop_name]
          ....
       END REPeat loop_name

       You can only escape from the loop with an EXIT statment.
       The NEXT statement will restart the loop at REPeat.
       You normally will test a termination condition at the
       start (WHILE) or at the end (REPEAT UNTIL) and EXIT.
       Example:
100    REPeat Read_data
110      IF EOF(#3) THEN EXIT Read_data
120      INPUT #3,a$
130      PRINT a$
140    END REPeat Read_data

  c) IF ... THEN ... ELSE ... END IF
       Single line IF statements do not need to be terminated with END IF.
       The operators AND,OR,XOR are logical, not bitwise !
       For Integer bitwise operators use &&,||,^^.

  d) selecting data (CASE OF,  SWITCH ON)
       Select variables must be Floating point type, and no formal
       parameters are allowed. The format then is:

       SELect ON Sel_var
         =1         : ...
         =3,6,8     : ...
         =10 TO 99  : ...
         =REMAINDER : ...
       END SELect

  e) procedures, functions and parameters
       PROCedures and FuNctions can be ordered top down or bottom up
       or free style. They can be recursive, Parameters can be modified.
       The definition is introduced with

       DEFine PROCedure name[(par1,par2...)]
          or
       DEFine FuNction name[(par1,par2...)]

       The formal parameters do not have a type !
       String FuNctions must end with a '$', integer FuNctions with '%'.
       The next line after the Definition contains the LOCal variable list
       which is introduced by the keyword LOCal. You  should not try to
       declare more than 9 local variables, since this may confuse the
       Interpreter. Arrays can be dimensioned at declaration time:

       LOCal var1,var2$,var3(100,10)

       FuNctions return theier result using the RETurn statement.
       The RETurn statement can be used without  any argument to
       escape from a procedure.

       RETurn result

       The FuNction and PROCedure is terminated using the END DEFine
       statement:

       END DEFine name

       Example:

100    DEFine FuNction FAK(n)
110    LOCal m
120    IF n=0 THEN
130       m=1
140    ELSE
150       m=n-1 : m=n*FAK(m)
160    END IF
170    RETurn m
180    END DEFine FAK

  f) !!! string handling and array slicing !!!
       String handling on Superbasic is very different from any other
       language !
       A string expression can consist of
         String constants enclosed in single quote or double quote
         String variables terminated with '$'
         String slices which consist of the name, and a range: A$(3 TO 6)
         String functions
         and the concanation operator, which is the ampersand: '&'
       Array and string slices need not to specify start and end:
         A(  TO 8)            will start with the first element
         A(3 TO)              will end with the last element.
       this can be wrong for strings, since the number of elements is not
       allways the length of a string !
       arrays and array slices can be passed to procedures, but
       slices are considered as expressions, and can therefore not
       return values from a procedure.
       INSTR is implemented as operator , not as Function !
       Example: N= "TEST" INSTR A$      return the position of "TEST"
       Strings can have a length of up to 32767 characters.
       Strings can be Dimensioned. If you need an Array of Strings, the
       last index specifies the length of the string

  g) error  processing
       There are different kinds of error processing for SUPERBASIC.
       The official one only works in the pure interpreter mode:

       10 WHEN ERROR
       20   PRINT 'sorry, there was an error:',ERNUM,'at ',ERLIN
       30 END WHEN

       or for debuging purposes:

       10 WHEN a=123
       20   PRINT 'The Value has reached the Limit !'
       30 END WHEN

       The WHEN statements must have been executed once, before they
       become active.
       If You compile programs with the Qliberator, you should use
       the QERR_ON 'function' , QERR_OFF 'function' procedure, which
       traps error returns and set a flag which can be read with Q_ERR.

  h) interfacing to assembler
       This is probably one of the biggest advantages of SUPERBASIC over
       nearly all other BASIC interpreters I know.
       You can easily add new functions and procedures to the interpreter,
       which then will behave as if they have ever belonged to it.
       The following VECTORED UTILITIES are designed to assist you:
       BP.INIT    $110  A1=pointer to definition list
         initialize procedures and functions
       CA.GTINT   $112  A1=pointer to stack , A3/A5=first/last parameter
         get any number of integer parameters from BASIC to stack
       CA.GTFP    $114  as above
         get floating point (6 bytes !)
       CA.GTSTR   $116  as above
         get string
       CA.GTLIN   $118  as above
         get long integer (4 byte)
       BV.CHRIX   $11A  D1.L=number of bytes
         allocate space on arithmetic stack
       BP.LET     $120  A3=pointer to name table entry
         return parameter value to BASIC
       The error is returned as negative Number in D0
       A normal RTS instruction should be used to return to BASIC.
       A6 should never be changed, since this is used as pointer to
       the BASIC memory area.
       For more Details have a look at some assembler sources.
  i) command summary (376 functions and procedures)
      *1 = T.Tebby toolkit 2
      *2 = Turbo Toolkit (supplied with TURBO basic compiler)
      *3 = Qliberator toolkit
      *4 = any other toolkit or program

      _R grafic commands refer to the last plotted point as origin.
      Graphic coordinates refer to a virtual device with non integer
      coordinates, which can be scaled using SCALE.
      This makes it possible  (in principle) to output graphics
      on any device with maximum resolution. You should not
      wonder about the strange factor between X and Y coordinates,
      this is the monitor X/Y relation, which makes circles round.

      PIXEL coordinates are physical coordinates (X=0..511, Y=0..255)

      With the T.Tebby Toolkit 2 #n is almost synonym with \filename,
      which will act on the file directly, instead on a channel.
      Job handling requires the name as string or the ID in the
      form Number,Tag.

ABS(F)          returns positive number
ACOS(F)         returns inverse of cosine
ACOT(F)         returns inverse of cotangent
ADATE n         advance date in seconds (+ or -)
AJOB ID% or NAME$, priority%
            *1  activates a job
ALARM h%,m%
            *1  can not work on the amiga, since sound is not emulated
ALCHP(n)    *1  allocates space (n bytes) in the common heap area
                and returns the address of the first byte to use
ALLOCATION  ?   sometimes I am wondering myself
ALTKEY Key$,String$
            *1  if you type the key in key$ together with the <ALT> key
                afterwards, the String in String$ will be displayed.
ARC [#n,]x,y TO x1,y1,angle
                draw an arc between x,y and x1,y1
ARC_R           same as ARC, but uses relative coordinates
ASIN(F)         returns the inverse sine
AT [#n,]y%,x%   set cursorusing character coordinates
ATAN(F)         returns the inverse tangent
AUTO n,i        old fashioned basic programming tool
BASIC_B%    *2  ??????????????????
BASIC_F     *2
BASIC_INDEX%
            *2
BASIC_L     *2
BASIC_NAME$
            *2
BASIC_POINTER
            *2
BASIC_TYPE%
            *2
BASIC_W%    *2  ???????????????????
BAUD n%         set baudrate for serial transmission
BEEP any number of parameters
                can not work on the amiga, since sound is not emulated
BEEPING         will return nonsense
BGET #n[\ptr],list_of_vars
            *1  get bytes from a file, refering to a pointer
BICOP       *my own toolkit, makes a hardcopy sideways
BIN(str$)   *1  binary conversion
BIN$(n,bits)
            *1  returns a string containing binary representation of n
BLOCK [#n,]x,y,bx,by,c
                draws a rectangle at x,y in colour c , PIXEL coordinates !
BLOOK(a$,adr)
            *my own toolkit, searches  for a  string in memory
BMOVE start,end,to
            *my own toolkit, memory block move
BORDER [#n,]w,c
                gives a border with thickness w in colour c
BPUT #n[\ptr],list_of_vars
            *1  but bytes into a  file, refering to a pointer
CALL PC[,D1,D2,D3,D4,D5,D6,D7,A0,A1,A2,A3,A4,A5]
                call a machine code programm
CATNAP      *2  ?????
CDEC$(value,field,ndp)
            *1  currency conversion
CHANNEL_ID(#n)
            *2  returns QDOS channel ID for basic channel #n
CHARGE      *2  should run the TURBO compiler. Crash system !
CHAR_INC [#n,]x_inc,y_innc
            *1  set character spacing
CHAR_USE [#n,]adr1,adr2
            *1  set address of new character font (first and second)
CHR$(n%)        returns character with ascii number n
CIRCLE [#n,]x,y,r[,eccentricity,angle]
                draw a circle or ellipse in graphic coordinates
CIRCLE_R [#n],x,y,r
                draw circle using relative origin
CLCHP       *1  clear all common heap allocations for BASIC
CLEAR           clear all variables, tidy BASIC stack
CLOCK [#n,][string$]
            *1  displays a clock (try %Y %D %H %M %S)
CLOSE [#n] [*1] close a[ll] channel[s]
CLR_SEALST  *RK00 don't use search list RAM1_, RAM2_, FLP1_, FLP2_
CLS [#n,][o%]   clears all or part of a window.
                o%= 0: whole screen
                    1: top excluding cursor line
                    2: bottom excluding cursor line
                    3: whole cursor line
                    4: right end of cursor line, including cursor
CODE(c$)        returns ASCII representation of character
COL(x512,y256)
            *my own toolkit.
                Returns colour of pixel using pixel coordinates
COMMAND_LINE
            *2  for compiler only
COMPILED    *2  for compiler only
CONNECT     *2  ???????????????????
CONTINUE        if a program has been stopped using STOP or <break>
COPY file1$ TO file2$
           [*1] copy a file. With TK2 default devices are provided
COPY_H file1$,file2$
            *1  copy file with header
COPY_N file1$ TO file2$
           [*1] copy file without header
COPY_O file1$,file2$
            *1  copy overwrite
COS(F)          returns cosine
COT(F)          returns cotangent
CSIZE [#n,]x,y  set characcter size. x=0,1,2,3 ; y=0,1
CURDIS [#n] *1  suppress cursor
CURSEN [#n] *1  enable cursor
CURSOR [#n],x,y set cursor position using PIXEL coordinates
                (relative to window origin)
CURSOR_OFF [#n]
            *2  use CURDIS, it is shorter and more reliable
CURSOR_ON  [#n]
            *2  use CURSEN, shorter and more reliable
DATAD$      *1  returns default data device
DATASPACE   *2
DATA_AREA   *2
DATA_USE drv$
            *1  set default data device
DATE            returns seconds since anno tobac
DATE$           returns a string containing actual time
DAY$            returns a string with actual day
DDOWN name$
            *1  kind  of subdirectory handling using default data device
                and the default program device in a rather obscure manner.
DEALLOCATE  *2
DEFAULT_DEVICE *2
DEF_INTEGER *2
DEG(F)          convert angle from radian to degree
DELETE file$
           [*1] delete a file
DEL_DEFB    *1  cure to large scale heap fragmentation,  deletes
                file definition blocks. Dangerous !
DESTD$      *1  returns default destination for SPL
DEST_USE name$
            *1  set default destination for SPL
DEVICE_SPACE *2
DEVICE_STATUS *2
DIMN(array(...))
                returns the dimension of an array, or vector in an array
DIR dev$   [*1] shows directory of device. With TK2 it uses defaults
DISK_ED     *4  nice Tool to edit single sectors on a floppy disk.
DLINE n1 [TO n2] old fashioned BASIC editor primitive
DLIST       *1  lists default devices
DNEXT name$
            *1  kind  of subdirectory handling using default data device
                and the default program device in a rather obscure manner.
DO file$    *1  executes a BASIC batch file, which must not contain
                line numbers !
DOTLIN per1,per2,per3,c,x1,y1,x2,y2
            *my own toolkit, draws a dotted line using pixel coordinates
DUP         *1  kind  of subdirectory handling using default data device
                and the default program device in a rather obscure manner.
ED [#n,][l] *1  full screen BASIC editor.
                Only works WITHOUT TAS instructions !
                <ESC> undo line or leave  editor
                <Shift> Up and down: page
                <F4> toggle insert/overwrite
                <Alt><Ctrl> left: delete line
EDIT n%         old  fashioned BASIC editor primitive
EDITF([#n,]F)
            *2  edits and returns a Floatingpoint number
EDITOR file$
            *4  Starts a new file editor session (Assembler Workbench)
EDIT$(str$) *2  edits and returns a string
EDIT%(n%)   *2  edits and returns an integer
ELLIPSE [#n,]x,y,r,e
                draw an ellipse using graphic coordinates
ELLIPSE_R [#n,]x,y,r,e
                draw an ellipse using relative origin
END_CMD     *2  when using MERGE instead of DO, last command in batchfile
END_WHEN ?????
EOF[(#n)]       boolean function EndOfFile
                (without channel refers to DATA in program)
ERLIN           returns line which produced the last error
ERLIN%
ERNUM           returns QDOS  number of last  error
ERNUM%
ERR_BL          returning corresponding QDOS error number
ERR_BN
ERR_BO
ERR_BP
ERR_DF
ERR_EF
ERR_EX
ERR_FE
ERR_FF
ERR_IU
ERR_NC
ERR_NF
ERR_NI
ERR_NJ
ERR_NO
ERR_OM
ERR_OR
ERR_OV
ERR_RO
ERR_TE
ERR_XP
ET file$    *1  execute for trace
EW [#n TO] prog_file$ [TO file2$] [TO #m] [; parameter$]
            *1  execute and wait
                set up pipes and pass parameters
EX [#n TO] prog_file$ [TO file2$] [TO #m] [; parameter$]
            *1  execute and ccontinue
                set up pipes and pass parameters
EXEC file$ [*1] execute and continue. With TK2 same as EX
EXECUTE     *2
EXECUTE_A   *2
EXECUTE_W   *2
EXEC_W file$
           [*1] execute and wait. With TK2 same as EW
EXP(F)          returns e^F
EXTERNAL    *2
EXTRAS [#n].*1. shows any non standard procedures
EXT_FN
EXT_PROC
FCO         *my own toolkit, Fast hardcopy
FDAT(#n)    *1  return dataspace of file
FDEC$(value,field,ndp)
            *1  fixed format decimal
FEXP$(value,field,ndp)
            *1  fixed exponent format
FILE_ED     *?? nice tool
FILL [#n,]b     enables (b=1) or disables (B=0) fill mode in this window
FILL$(c$,n)     returns c$ n times
FLASH [#n,]b    does not work on the Amiga, flashing not implemented
FLEN(#n)    *1  returns length of file
FLOAT$(F)   *2  returns a 6 byte internal representation of a FP number
FLP_OPT     *floppy controller, will not work on the Amiga yet.
FLP_USE str$
            *flp device redefinition (for example FLP_USE 'MDV' will
                emulate a microdrive on the floppy)
FLUSH [#n]  *1  flush file buffers
FNAME$(#n)  *1  returns the filename for this channel
FOPEN(#n,file$)
            *1  open file for read/write and return error status
FOP_DIR(#n,file$)
            *1  open directory and return error status (may be read only)
FOP_IN(#n,file$)
            *1  open file for input and return error status
FOP_NEW(#n,file$)
            *1  create and open new file for output, return error status
FOP_OVER(#n,file$)
            *1  open old file for overwrite, return error status
FORMAT name$    format a device (implemented only for FLP)
FPOS(#n)    *1  return actual file pointer
FREE_MEM    *1  a measure for the amount of available memory in bytes
FREE_MEMORY *2  long form, may differ in a few bytes
FSERVE      *1  Network server task, not implemented on the Amiga yet
FTEST(#n)   *1  check if file exists
FTYP(#n)    *1  returns file type: 0=text , 1=executable , 2=relocatable
FUNCTION    *2
FUPDT(#n)   *1  returns file update date
FXTRA(#n)   *1  returns file extra information
GET #n [\ptr,]var_list
            *1  unformatted input of variables. The type of the variables
                should agree with the corresponding items to read.
GETF(#n)    *2  unformatted input of floatingpoint variables
GETXY x%,y% *my own toolkit, starts a crosshair cursor and returns
                the PIXEL coordinates
GET$(#n)    *2  unformatted input of strings
GET%(#n)    *2  unformatted input of integer
GLOBAL      *2   ???
HCO         *my own toolkit, makes a hardcopy with grey steps
HEX(string$)
            *1  hexadecimal conversion
HEX$(n,bits)
            *1  returns hex representation
IDEC$(value,field,ndp)
            *1  number format conversion
IMPLICIT$   *2
IMPLICIT%   *2
INK [#n,] c     set colour [0..255 including stipples] for PRINT, LINE ...
INKEY$[#n,][time]
                input one character from channel, timeout in 1/50 sec
                Warnig ! the cursor must be enabled !
INPUT ("Last guess " & guess & "New guess?") ! guess
INPUT "Nice day,";isnt_it
                and advanced version of the goodigood INPUT
INPUT$      *2
INT(F)          returns the next bigger integer to F (+-32768)
INTEGER$    *2
INVXY x%,y% *my own toolkit, xors a cross at x%,y% using PIXEL coorrdinates
JOBS [#n]   *1  lists active jobs
JOB$(ID)    *1  return name of Job with ID
KEYROW(row)     returns a raw key matrix pattern in QL like  form:

                 1    2    4    8   16   32   64  128
                    ctrl
              7 shift     Alt   X   V    /    N    ,

              6  8    2    6    Q   E    O    T    U

              5  9    W    I   TAB  R    -    Y

              4  L    3    H    1   A    P    D    J
                     caps
              3  |   Lock  K    S   F    =    G    ;

              2  |    Z         C   B    `    M    ~
                enter                            down
              1      <-    up  ESC  ->   \  space

              0 F4   F1    5   F2   F3   F5   4    7

LBYTES file$,adr
                load a contents of a file to specified address
LDRAW x,y,x1,y1,c
            *my own toolkit, draw line using PIXEL coordinates
LEN(str$)       returns length of a string
LIBERATE filename$[;]
            *3  loads the QLIBerator BASIC compiler
LINE [#n,] [x,y] TO x1,y1 [TO...]
                draw line using graphic coordinates
LINE_R          same for relative origin
LINK_LOAD   *2
LINK_LOAD_A *2
LINK_LOAD_W *2
LIST [n] [TO m]
                old fashioned Basic editor primitive
LIST_TASKS  *2  If you like to type long stories...
LN(F)           natural logarithm
LOAD file$      loads a BASIC program
LOG10(F)        decadic logarithm
LRESPR file$
            *1  loads a RAM toolkit into the resident procedure area
LRUN file$      load and run a basic program
MERGE file$     merges a BASIC program to the current one
MODE n          8 selects low resolution (8 colour) mode,
                4 selects high resolution (4 colour) mode.
                The 8 colour mode is not emulated.  Future
                expansion to 640 x 512 is intended.
MOVE [#n,] distance
                Move turtle of turtle graphics
MOVE_MEMORY *2
MRUN file$      Merging can be programmed this way
NET n           set network station number. Not implemented on the
                Amiga yet. You are welcome to help us !
NEW             try it after you have written 3 hours on a BASIC program
NFS_USE str$
            *1  Network devicename redefinition, sorry, don't do anything.
NXJOB(ID,Top_job_id)
            *1  returns ID of next job in tree
OJOB(ID [or name])
            *1  find owner of Job
OPEN #n,file$
           [*1] opens a  file for read/write. With TK2 uses defaults
OPEN_DIR #n,dev$
                opens directory of given device (may be read only)
OPEN_IN #n,file$
           [*1] open file for read only
OPEN_NEW #n,file$
           [*1] create and open file
OPEN_OVER #n,file$
            *1  open file for output and rewrite
OPTION_CMD$ *2
OVER [#n,]switch
                0 : print ink on strip
                1 : print ink on transparent strip
               -1 : XOR data on screen
OV_OFF      *new ! disable overflow error. Be carefull !
OV_ON       *new ! enable overflow error
PAINT x,y,c
            *my own toolkit, fills a closed  figure on the screen
                at x,y in PIXEL coordinates with colour c
PAN [#n,]distance[,part]
                pan window #n distance pixel to the left (positive number)
                part = 0 : whole screen (default)
                     = 3 : whole cursor line
                     = 4 : right hand end of cursor line
PAPER [#n,]colour[,contrast,stipple]
                set background colour
PARNAM$(n)  *1  returns the name of the n'th formal parameter of a
                function (may not  work)
PARSTR$(parameter,n)
            *1  returns the name or the string if it is a string expr.
PARTYP(n)   *1  0 : null  , 1 : string   , 2 : floating , 3 : integer
PARUSE(n)   *1  0 : unset , 1 : variable , 2 : array
PAUSE n         suspend actual task (BASIC) for n/50 seconds
PEEK(adr)       1 byte peek
PEEK_F(adr) *2  6 byte peek
PEEK_L(adr)     4 byte peek
PEEK_W(adr)     2 byte peek
PEEK$(adr,n)
            *2  n byte peek
PENDOWN [#n]    draw turtle moves
PENUP [#n]      hide turtle moves
PI              =3.1415927
PJOB(id || name)
            *1  return priority of job
POINT [#n,]x,y[,x,y...]
                set a point in INK using graphic coordinates
POINT_R [#n,]x,y[,x,y...]
                set a point in INK relative to last position
POKE adr,n      1 byte poke
POKE_L adr,n    4 byte poke
POKE_W adr,n    2 byte poke
POKE$ adr,a$
            *2  n byte poke
POSITION(#n)
            *2  return file position
PRINT [#n,]item[s]
                print variables formatted. separators:
                !  intelligent space
                ,  8 columns tab
                ;  just separate. At the end prevents new line
                \  force new line
                TO n tabulate to column n
PRINT_USING [#n,]format$,item[s]
            *1  the formatting string can contain the following symbols:
                ####.##       fixed point decimal
                ##,###.##     separate thousands with commas
                -#.###!!!!    exponential form, optional sign
                +#.###!!!!    exponential form, including sign
PROCEDURE   *2
PROGD$      *1  return default program  device
PROG_USE dev$
            *1  set default program device
PUT [#n,]position,item[s]
            *1  unformatted output using filepointer.
                The pointer will be updated
QLOAD       *3  Fast load !!!!  does not work on RK00 !!!!
QLRUN       *3  Fast load and run !!!! does not work on RK00 !!!!
QREF name   *3  gives information about BASIC tokens
QREF_A name *3  token information , sort of wildcard
QREF_M      *3
QREF_P      *3
QREF_V      *3
QSAVE       *3  fas save (loading does not work anyway)
QW file;"str" any number of parameters
            *3  like EW (see there) but using _OBJ extension
QX file;"str" any number of parameters
            *3  like EX (see there) but using _OBJ extension
QX_JOB0 ... *3  execute job with owner BASIC
Q_CURSOFF [#n]
            *3  another cursor off utility
Q_CURSON [#n]
            *3  another cursor on utility
Q_ERR       *3  returns the last error number
Q_ERR_LIST  *3  list function and procedures with disabled error handling
Q_ERR_OFF name
            *3  switch off error handling for a procedure or function
Q_ERR_ON name
            *3  enable error handling for a procedure or fuunction
Q_L         *3
Q_MYJOB     *3  returns actual job id
Q_PIPE      *3
RAD(n)          convert degree to radian
RAM_USE dev$
            *4  mdv emulation for Ram disk
RANDOMISE [n]   reset random number generator
READ item[,item...]
                read data from program file
RECHP adr   *1  deallocate common heap (counterpart to ALCHPP)
RECOL [#n,]c0,c1,c2,c3,c4,c5,c6,c7
                recolour a window
REFERENCE   *2  forget it
RELEASE_TASK *2
REMOVE_TASK *2
RENAME file TO newname
           [*1] rename files. with TK2 you may use commas to separate
RENUM [start [TO end;] new][,step]
                renumber a basic program
REPORT
RESPR(n)        reserve n bytes in resident procedure area, return adress
RETRY           retry after error (repeat instruction)
RETRY_HERE
RJOB id or name
            *1  force remove job
RND[(n [TO n2]) return random number between 0 and 1 or n1 and n2
RUN [n]         start execution of BASIC program
SAVE file[,n1 TO n2]
           [*1] save BASIC program (as ASCII)
SAVE_O      *1  save overwrite
SBYTES file,adr,n
           [*1] save n bytes memory starting with adr as file
SBYTES_O file,adr,n
            *1  save memory overwrite
SCALE [#n,]scale,origin
                set width and origin for grafic coordinates
                default is 100 at 0,0 (Monitor X/Y is included !)
SCROLL [#n,]distance,part
                scroll window distance pixel
                part = 0  whole screen
                part = 1  top excluding cursor line
                part = 2  bottom excluding cursor line
SDATE year,month,day,hours,minutes,seconds
                set clock (does not affect battery buffered realtime clock)
SEARCH_MEMORY
SET x%,y%,c%
            *my own toolkit: set pixel using pixel ccoordinates
SET_CHANNEL
SET_FONT
SET_POSITION #n,p
            *2  set file pointer
SET_PRIORITY
SEXEC file,adr,size,dataspace
           [*1] save memory block as executable task
SEXEC_O file,adr,size,dataspace
            *1  save memory block as task, overwrite
SIN(x)          return sine
SNOOZE      *2
SPJOB id,priority
            *1  set new priority for job
SPL file    *1  file spooler (Background printing)
SPLF
SPL_USE dev$
            *1  set default spool device
SQRT(x)         return the square root of x
STAT [#n,]dev$  returns device statistics
STOP            stop basic program (continue with CONTINUE)
STRING$
STRIP [#n],c    set strip colour
SUSPEND_TASK *2
SYS_RESET   *new does not work on Amiga (CRASH !!!)
S_GPOS #n   *4  position of filepointer for screens
S_LOAD #n   *4  load compressed picture from file
S_SAVE #n[,size]
            *4  compress and save picure
S_SPOS      *4
TAN(x)          return tangent of x
THROW_AWAY  *2  do it
TK2_EXT     *1  force Toolkit 2 extensions
TK_VER$     *2
TRA adr         set translate table for output (to printer)
TRUNCATE #n *1  truncate overwrite file
TURN [#n],angle
                turn turtle specified angle
TURNTO [#n],angle
                turn turtle specified angle absolute
TYPE_IN #n,str$
            *2  writes string to a channel (a bit tricky, but usefull)
UNDER [#n,] 0 or 1
                turns underlining on (1) or off (0)
VER$            returns a string with the QDOS version
VIEW [#n,]file
            *1  a little bit like the usual TYPE
WCOPY file1,file2
            *1  wildcard copy. The Wildcard is the Underliner '_' !
WDEL file   *1  wildcard delete ( Wildcard='_' Underliner ! )
WDEL_F      *1  !!!! Danger !!!!
WDIR        *1  wildcard directory (Wildcard='_' Underliner !)
WHEN_ERROR  *2
WIDTH [#n,]line_width
                set default width of devices (AUTOMATIC LF !)
WINDOW [#n,]sx,sy,x,y
                specify window size (sx,sy) and origin (x,y) in pixel
WMON        *1  default monitor screen
WREN name1,name2
            *1  wildcard rename (Wildcard='_' Underliner !)
WSTAT files *1  wildcard file statistics
WTV         *1  default TV screen

4) Introduction to DOS-calls

  a) Supervisor TRAP (#0)
     Enter Supervisormode with TRAP #0

  b) Manager TRAPs  (#1)
     system calls [ MOVEQ #??,D0 .... TRAP #1]
     D0=$00 MT.INF     provide current job and system information
        Call parameters            Return parameters
        D1                         D1.L current Job ID
        D2                         D2.L ASCII version
        D3                         D3   preserved
        A0                         A0   pointer to system variables
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$01 MT.CJOB    create a job in transient prog. area
        Call parameters            Return parameters
        D1.L owner JOB ID          D1.L Job ID
        D2.L length of code(bytes) D2   preserved
        D3.L length of data space  D3   preserved
        A0                         A0   base of area allocated
        A1   start address or 0    A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : OM,NJ

     D0=$02 MT.JINF    Provide information on a job
        Call parameters            Return parameters
        D1.L JOB ID                D1.L next Job in tree
        D2.L Job at top of tree    D2.L owner of Job
        D3                         D3   MSB<0 if suspended, LSB=priority
        A0                         A0   base address of job
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NJ

     D0=$03 illegal system trap

     D0=$04 MT.RJOB    Remove job from transient prog. area
        Call parameters            Return parameters
        D1.L JOB ID                D1   ?
        D2                         D2   ?
        D3.L Error code            D3   ?
        A0                         A0   ?
        A1                         A1   ?
        A2                         A2   ?
        A3                         A3   ?
        Errors : NJ,NC

     D0=$05 MT.FRJOB   force remove job from transient prog. area
        Call parameters            Return parameters
        D1.L JOB ID                D1   ?
        D2                         D2   ?
        D3.L Error code            D3   ?
        A0                         A0   ?
        A1                         A1   ?
        A2                         A2   ?
        A3                         A3   ?
        Errors : NJ

     D0=$06 MT.FREE    finds largest contiguous free trans. prog. space
        Call parameters            Return parameters
        D1                         D1.L length of space
        D2                         D2   ?
        D3                         D3   ?
        A0                         A0   ?
        A1                         A1   ?
        A2                         A2   ?
        A3                         A3   ?

     D0=$07 MT.TRAPV   sets per job pointer to trap vectors
        Call parameters            Return parameters
        D1.L JOB ID                D1.L Job ID
        D2                         D2   preserved
        D3                         D3   preserved
        A0                         A0   base of job
        A1   pointer to table      A1   ?
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$08 MT.SUSJB   suspend job
        Call parameters            Return parameters
        D1.L JOB ID                D1.L Job ID
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0                         A0   base of job control area
        A1   address of flag byte  A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NJ

     D0=$09 MT.RELJB   Release job
        Call parameters            Return parameters
        D1.L JOB ID                D1.L Job ID
        D2                         D2   preserved
        D3                         D3   preserved
        A0                         A0   base of job control area
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NJ

     D0=$0A MT.ACTIV   activate job
        Call parameters            Return parameters
        D1.L JOB ID                D1.L Job ID
        D2.B priority (0-127)      D2   preserved
        D3.W timeout (-1,0)        D3   preserved
        A0                         A0   base of job control area
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NJ,NC

     D0=$0B MT.PRIOR   change a job's priority
        Call parameters            Return parameters
        D1.L JOB ID                D1.L Job ID
        D2.B priority (0-127)      D2   preserved
        D3                         D3   preserved
        A0                         A0   base of job control area
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NJ

     D0=$0C MT.ALLOC   allocate an area in a heap
        Call parameters            Return parameters
        D1.L required length       D1.L allocated length
        D2                         D2   ?
        D3                         D3   ?
        A0   pointer to pointer    A0   base of area allocated
             to free space
        A1                         A1   ?
        A2                         A2   ?
        A3                         A3   ?
        A6   base address          A6   preserved
        Errors : OM

     D0=$0D MT.LNKFR   link free space back into heap
        Call parameters            Return parameters
        D1.L length to link in     D1   ?
        D2                         D2   ?
        D3                         D3   ?
        A0   base of new space     A0   ?
        A1   pointer to pointer    A1   ?
             to free space
        A2                         A2   ?
        A3                         A3   ?
        A6   base address          A6   preserved

     D0=$0E MT.ALRES   allocate resident procedure area
        Call parameters            Return parameters
        D1.L no. of bytes required D1   ?
        D2                         D2   ?
        D3                         D3   ?
        A0                         A0   base address of area
        A1                         A1   ?
        A2                         A2   ?
        A3                         A3   ?
        Errors : OM,NC

     D0=$0F MT.RERES   release resident procedure area
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   ?
        D3                         D3   ?
        A0                         A0   ?
        A1                         A1   ?
        A2                         A2   ?
        A3                         A3   ?
        Errors : NC

     D0=$10 MT.DMODE   Sets or reads the display mode
        Call parameters            Return parameters
        D1.B -1 read mode          D1.B display mode
             0 : 512*256
             8 : 256*256
        D2.B -1 read display       D2.B display type
             0 : monitor
             1 : TV
        D3                         D3   preserved
        A0                         A0   preserved
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   ?

     D0=$11 MT.IPCOM   Sends a command to the IPC
        Call parameters            Return parameters
        D1                         D1.B IPC return parameter
        D2                         D2   preserved
        D3                         D3   preserved
        D5                         D5   ?
        D7                         D7   ?
        A0                         A0   preserved
        A1                         A1   preserved
        A2                         A2   preserved
        A3.L pointer to command    A3   preserved

     D0=$12 MT.BAUD    sets the baud rate
        Call parameters            Return parameters
        D1.W baud rate             D1   ?
        D2                         D2   preserved
        D3                         D3   preserved
        A0                         A0   preserved
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$13 MT.RCLCK   reads the clock
        Call parameters            Return parameters
        D1                         D1.L time in seconds
        D2                         D2   ?
        D3                         D3   preserved
        A0                         A0   ?
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$14 MT.SCLCK   sets the clock
        Call parameters            Return parameters
        D1.L time in seconds       D1.L time in seconds
        D2                         D2   ?
        D3                         D3   ?
        A0                         A0   ?
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$15 MT.ACLCK   adjust the clock
        Call parameters            Return parameters
        D1.L adjustment in seconds D1.L time in seconds
        D2                         D2   ?
        D3                         D3   ?
        A0                         A0   ?
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$16 MT.ALBAS   allocate Basic programm area
        Call parameters            Return parameters
        D1.L no. of bytes required D1.L number of bytes allocated
        D2                         D2   ?
        D3                         D3   ?
        A0                         A0   ?
        A1                         A1   ?
        A2                         A2   ?
        A3                         A3   ?
        A6   base address          A6   new base address
        A7   USP                   A7   new USP
        Errors : OM

     D0=$17 MT.REBAS   release Basic programm area
        Call parameters            Return parameters
        D1.L no. of bytes          D1.L number of bytes released
        D2                         D2   ?
        D3                         D3   ?
        A0                         A0   ?
        A1                         A1   ?
        A2                         A2   ?
        A3                         A3   ?
        A6   base address          A6   new base address
        A7   USP                   A7   new USP

     D0=$18 MT.ALCHP   allocate common heap area
        Call parameters            Return parameters
        D1.L no. of bytes required D1.L number of bytes allocated
        D2.L owner job ID          D2   ?
        D3                         D3   ?
        A0                         A0   base address of area
        A1                         A1   ?
        A2                         A2   ?
        A3                         A3   ?
        Errors : OM,NJ

     D0=$19 MT.RECHP   release common heap area
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   ?
        D3                         D3   ?
        A0.L base of area to free  A0   ?
        A1                         A1   ?
        A2                         A2   ?
        A3                         A3   ?

     D0=$1A MT.LXINT   links in an external interrupt service routine
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3                         D3   preserved
        A0.L address of link       A0   preserved
        A1.L entry address         A1   ?
             A1 -> 4(A0) !
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$1B MT.RXINT   remove external interrupt routine from list
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3                         D3   preserved
        A0.L address of link       A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$1C MT.LPOLL   link in 50/60 Hz poll routine
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3                         D3   preserved
        A0.L address of link       A0   preserved
        A1.L entry address         A1   ?
             A1 -> 4(A0) !
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$1D MT.RPOLL   remove 50/60 Hz routine from list
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3                         D3   preserved
        A0.L address of link       A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$1E MT.LSCHD   links in a scheduler loop task
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3                         D3   preserved
        A0.L address of link       A0   preserved
        A1.L entry address         A1   ?
             A1 -> 4(A0) !
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$1F MT.RSCHD   remove scheduler loop task from list
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3                         D3   preserved
        A0.L address of link       A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$20 MT.LIOD    links in I/O device driver
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3                         D3   preserved
        A0.L address of link       A0   preserved
        A1.L entry address         A1   ?
             A1 -> 4(A0) !
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$21 MT.RIOD    remove I/O device driver from list
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3                         D3   preserved
        A0.L address of link       A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$22 MT.LDD     links in directory device driver
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3                         D3   preserved
        A0.L address of link       A0   preserved
        A1.L entry address         A1   ?
             A1 -> 4(A0) !
        A2                         A2   preserved
        A3                         A3   preserved

     D0=$23 MT.RDD     remove directory device driver from list
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3                         D3   preserved
        A0.L address of link       A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved


  c) IO allocation  TRAPs (#2)
     D0=$01 IO.OPEN    opens a channel for I/O
        Call parameters            Return parameters
        D1.L job ID                D1   job ID
        D2                         D2   preserved
        D3.L code where bit:       D3   preserved
             0 = old exclusive
             1 = old shared
             2 = new exclusive
             3 = new overwrite
             4 = open Directory
        A0.L addresss of name      A0.L channel ID
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NO,NJ,OM,NF,EX,IU,BN

     D0=$02 IO.CLOSE   closes a channel
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3                         D3   preserved
        A0.L channel ID            A0   ?
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NO

     D0=$03 IO.FORMT   Format a sectored medium
        Call parameters            Return parameters
        D1                         D1.W good sectors
        D2                         D2.W total sectors
        D3                         D3   preserved
        A0.L pointer to name       A0   ?
        A1                         A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : OM,FF,NF,IU

     D0=$02 IO.CLOSE   closes a channel
        Call parameters            Return parameters
        D1.L job ID                D1   ?
        D2                         D2   preserved
        D3                         D3   ?
        A0.L pointer to name       A0   ?
        A1                         A1   ?
        A2                         A2   ?
        A3                         A3   preserved
        Errors : NO,OM,NF,BN

  d) IO utilisation TRAPs (#3)
     TRAP #3  IO calls [ MOVEQ #??,D0 .... TRAP #3 ]
     D0=$00 IO.PEND     Checks for pending input
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,EF

     D0=$01 IO.FBYTE    Fetch a byte
        Call parameters            Return parameters
        D1                         D1.B byte fetched
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,EF

     D0=$02 IO.FLINE    Fetch a line of character terminated by <LF>
        Call parameters            Return parameters
        D1                         D1.W number of bytes fetched
        D2.W length of buffer      D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1.L base of buffer        A1   updated pointer to buffer
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,EF,BO

     D0=$03 IO.FSTRG    Fetches a string of bytes
        Call parameters            Return parameters
        D1                         D1.W number of bytes fetched
        D2.W length of buffer      D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1.L base of buffer        A1   updated pointer to buffer
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,EF

     D0=$04 IO.EDLIN    edits a line of characters
        Call parameters            Return parameters
        D1.L cursor/line length    D1.L cursor/line length
        D2.W length of buffer      D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1.L pointer to EOL        A1   pointer to end of line
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,BO

     D0=$05 IO.SBYTE    sends a byte
        Call parameters            Return parameters
        D1.B byte to be sent       D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,DF,OR

     D0=$06 illegal System call
     D0=$07 IO.SSTRG    sends a string of bytes
        Call parameters            Return parameters
        D1                         D1.W number of bytes sent
        D2.W number of bytes       D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1.L base of buffer        A1   updated pointer to buffer
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,DF

     D0=$08 illegal System call
     D0=$09 IO.EXTOP    invoke additional routines as part of screen driver
     D0=$0A SD.PXENQ    return window size and cursor position (pixel)
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1.L base of buffer        A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        0(A1) = X-dimension of window
        2(A1) = Y-dimension of window
        4(A1) = X-position of cursor
        6(A1) = Y-position of cursor

     D0=$0B SD.CHENQ    return window size and cursor position (character)
        Call parameters            Return parameters
        D1                         D1   preserved
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1.L base of buffer        A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        0(A1) = X-dimension of window
        2(A1) = Y-dimension of window
        4(A1) = X-position of cursor
        6(A1) = Y-position of cursor

     D0=$0C SD.BORDR    sets the border with and colour
        Call parameters            Return parameters
        D1.B colour                D1   ?
        D2.W width                 D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1.L                       A1   preserved
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$0D SD.WDEF     redifines a window
        Call parameters            Return parameters
        D1.B border colour         D1   ?
        D2.W border width          D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1.L base of buffer        A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,OR
        0(A1) = X-dimension of window
        2(A1) = Y-dimension of window
        4(A1) = X-origin
        6(A1) = Y-origin

     D0=$0E SD.CURE     enables the cursor
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$0F SD.CURS     suppress the cursor
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$10 SD.POS      positionm cursor at row, column (character)
        Call parameters            Return parameters
        D1.W column number         D1   ?
        D2.W row number            D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,OR

     D0=$11 SD.TAB      position cursor at column
        Call parameters            Return parameters
        D1.W column number         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,OR

     D0=$12 SD.NL       new line
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,OR

     D0=$13 SD.PCOL     previus column
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,OR

     D0=$14 SD.NCOL     next column
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,OR

     D0=$15 SD.PROW     previus row
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,OR

     D0=$16 SD.NROW     next row
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,OR

     D0=$17 SD.PIXP     position cursor using pixel coordinates
        Call parameters            Return parameters
        D1.W X-coordinate          D1   ?
        D2.W Y-coordinate          D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,OR

     D0=$18 SD.SCROL    Scroll all of a window
        Call parameters            Return parameters
        D1.W distance to scroll    D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$19 SD.SCRTP    scroll the top of a window
        Call parameters            Return parameters
        D1.W distance to scroll    D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$1A SD.SCRBT    scroll the bottom of a window
        Call parameters            Return parameters
        D1.W distance to scroll    D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$1B SD.PAN      Pans all of a window
        Call parameters            Return parameters
        D1.W distance to pan       D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$1C illegal system call
     D0=$1D illegal system call
     D0=$1E SD.PANLN    pans cursor line
        Call parameters            Return parameters
        D1.W distance to pan       D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$1F SD.PANRT    pans right hand end of cursor line
        Call parameters            Return parameters
        D1.W distance to pan       D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$20 SD.CLEAR    clears all of a window
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$21 SD.CLRTP    clears the top of a window
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$22 SD.CLRBT    clears the bottom of a window
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$23 SD.CLRLN    clears the cursor line
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$24 SD.CLRRT    clears the right hand end of the cursor line
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$25 SD.FOUNT    sets or resets the character fount
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   base of font          A1   ?
        A2   base of second font   A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        Format of Font:
           $00      lowest valid character
           $01      number of valid characters-1
           $02..$0A 9 bytes of pixels for 1st character
           $0B..$13 9 bytes of pixels ...

     D0=$26 SD.RECOL    recolours a window
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   ptr to colour list    A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        The colour list consists of 8 bytes, which contain the new
        colour for each old colour

     D0=$27 SD.SETPA    sets Paper colour
        Call parameters            Return parameters
        D1.B colour                D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$28 SD.SETST    sets Strip colour
        Call parameters            Return parameters
        D1.B colour                D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$29 SD.SETIN    sets ink colour
        Call parameters            Return parameters
        D1.B colour                D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$2A SD.SETFL    sets flashing
        Call parameters            Return parameters
        D1.B flash attribute       D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$2B SD.SETUL    sets Underlining
        Call parameters            Return parameters
        D1.B underline attribute   D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$2C SD.SETMD    sets character writing or plotting mode
        Call parameters            Return parameters
        D1.W mode                  D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        modes: -1=XOR , 0=Ink on strip , 1=ink on transparent

     D0=$2D SD.SETSZ    set character size and spacing
        Call parameters            Return parameters
        D1.W char width/spacing    D1   ?
        D2.W char height/spacing   D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        D1 = 0..3 (5 in 6, 5 in 8 , 10 in 12, 10 in 16)
        D2 = 0..1 (9 in 10 , 18 in 20)

     D0=$2E SD.FILL     fills a rectangular block within a window
        Call parameters            Return parameters
        D1.B colour                D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   ptr to block def      A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        0(A1) = width in pixel
        2(A1) = height in pixel
        4(A1) = X origin (relative to window)
        6(A1) = Y origin

     D0=$2F illegal system call
     D0=$30 SD.POINT    plots a point
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   arithmetic stack ptr  A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        0(A1) = Y coordinate (6 byte Float)
        6(A1) = X coordinate

     D0=$31 SD.LINE     plots a line
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   arithmetic stack ptr  A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        0(A1) = Y coordinate end of line (6 byte Float)
        6(A1) = X coordinate EOL
        C(A1) = Y start
        12(A1) = X start

     D0=$32 SD.ARC      plots an arc
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   arithmetic stack ptr  A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        0(A1) = angle (6 byte Float)
        6(A1) = Y end
        C(A1) = X end
        12(A1) = Y start
        18(A1) = X start

     D0=$33 SD.ELLIPS   plots an ellipse
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   arithmetic stack ptr  A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        0(A1) = angle (6 byte Float)
        6(A1) = radius
        C(A1) = eccentricity
        12(A1) = Y centre
        18(A1) = X centre

     D0=$34 SD.SCALE    sets window scale
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   arithmetic stack ptr  A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        0(A1) = Y coordinate bottom line (6 byte Float)
        6(A1) = X coordinate left hand pixel
        C(A1) = length of Y axis

     D0=$35 SD.FLOOD    turns area flood on and off
        Call parameters            Return parameters
        D1.L 0/1                   D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$36 SD.GCUR     sets graphics cursor position
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   arithmetic stack ptr  A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        0(A1) = grafics X coordinate (6 byte Float)
        6(A1) = grafics Y coordinate
        C(A1) = pixel offset to the right
        12(A1) = piixel offset downwards

     D0=$37 illegal system call
     D0=$38 illegal system call
     D0=$39 illegal system call
     D0=$3A illegal system call
     D0=$3B illegal system call
     D0=$3C illegal system call
     D0=$3D illegal system call
     D0=$3E illegal system call
     D0=$3F illegal system call
     D0=$40 FS.CHECK    checks all pending operations on a file
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$41 FS.FLUSH    flushes buffer for file
        Call parameters            Return parameters
        D1                         D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$42 FS.POSAB    position file pointer absolute
        Call parameters            Return parameters
        D1.L position in file      D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,EF

     D0=$43 FS.POSRE    position file pointer relative
        Call parameters            Return parameters
        D1.L offset to file ptr    D1   ?
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1                         A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,EF

     D0=$44 illegal system call
     D0=$45 FS.MDINF    Gets information about storage medium
        Call parameters            Return parameters
        D1                         D1   empty/good sectors
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   ptr to 10 byte buffer A1   end of medium name
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO

     D0=$46 FS.HEADS    sets the file header
        Call parameters            Return parameters
        D1                         D1   lenght of header set
        D2                         D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   base of header block  A1   end of header definition
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO
        00 file length
        04 file access
        05 file type (0=data , 1=executable)
        06 8 byte type dependent information (size of dataspace)
        0E length of file name
        10 up to 36 characters of file name
        34 date information

     D0=$47 FS.HEADR    reads the file header
        Call parameters            Return parameters
        D1                         D1   ?
        D2.W bufer length          D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   ptr to read buffer    A1   ?
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NC,NO,BO

     D0=$48 FS.LOAD     loads a file into memory
        Call parameters            Return parameters
        D1                         D1   ?
        D2.L length of file        D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   address for load      A1   top address after load
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : NO

     D0=$49 FS.SAVE     saves a file from memory
        Call parameters            Return parameters
        D1                         D1   ?
        D2.L length of file        D2   preserved
        D3.W timeout               D3   preserved
        A0.L channel ID            A0   preserved
        A1   ptr to data           A1   top address of file
        A2                         A2   preserved
        A3                         A3   preserved
        Errors : DF,NO

  e) relative to A6 TRAP (#4)
        makes the next IO trap relative to A6 (for BASIC)

  f) Vectored utilities
     Vectored utilities [ MOVEA.W $???,An      JSR (An)]
!! Excuse me, I give up here. Everybody, who is interested is invited
!! to complete this Manual and send the updated Version to me.
     0C0 MM.ALCHP allocate common heap (D1)
     0C2 MM.RECHP release common heap
     0C4 UT.WINDW Set up window
     0C6 UT.CON   set up a console window
     0C8 UT.SCR   set up screen window
     0CA UT.ERR0  write error message to #0
     0CC UT.ERR   write error message to a channel
     0CE UT.MINT  convert integer to ASCII
     0D0 UT.MTEXT send message to a channel
     0D2 UT.LINK  link intem into list
     0D4 UT.UNLNK unlink item from list
     0D6 illegal Vector !
     0D8 MM.ALLOC allocate area in a  heap
     0DA MM.LNKFR Links free space into heap
     0DC IO.QSET  set up a queue
     0DE IO.QTEST test queue status
     0E0 IO.QIN   put byte into a queue
     0E2 IO.QOUT  Extract a byte frrom a queue
     0E4 IO.QEOF  put EOF marker into queue
     0E6 UT.CSTR  compare two strings
     0E8 IO.SERQ  direct queue handling
     0EA IO.SERIO General IO handling
     0EC CN.DATE  get date and time
     0EE CN.DAY   get day of week
     0F0 CN.FTOD  convert float to ASCII
     0F2 CN.ITOD  convert Integer to ASCII
     0F4 CN.ITOBB convert binary byte to ASCII
     0F6 CN.ITOBW convert binary word to ASCII
     0F8 CN.ITOBL convert binary long word to ASCII
     0FA CN.ITOHB convert hex byte to ASCII
     0FC CN.ITOHW convert hex word to ASCII
     0FE CN.ITOHL convert hex long word to ASCII
     100 CN.DTOF  convert ASCII to float
     102 CN.DTOI  convert ASCII to integer
     104 CN.BTOIB convert ASCII to binary byte
     106 CN.BTOIW convert ASCII to binary word
     108 CN.BTOIL convert ASCII to binary long word
     10A CN.HTOIB convert ASCII to hex byte
     10C CN.HTOIW convert ASCII to hex word
     10E CN.HTOIL convert ASCII to hex long word
     110 BP.INIT  basic procedure initialization
     112 CA.GTINT Get integers from basic
     114 CA.GTFP  Get floats from basic
     116 CA.GTSTR Get strings from basic
     118 CA.GTLIN Get long integers from basic
     11A BV.CHRIX reserve space on arithmetic stack
     11C RI.EXEC  Executes an arithmetic operation
     11E RI.EXECB execute list of arithmetic operations
     120 BP.LET   return basic parameter value
     122 IO.NAME  decode a device name
     124 MD.READ  read a sector on a microdrive
     126 MD.WRITE write a sector on a microdrive
     128 MD.VERIN verify a sector on a microdrrive
     12A MD.SECTR read a sector header on a microdrive
     12C ANA_SYNX basic syntax analyser
     12E TB_LIST  first syntax table
     130 EXP_SYNX expression syntax table
     132 FMT_LINE format precompiled line
     134 COMP_ERR error when compiling
     136 STO_LINE store precompiled line
     138 TKN_LIST convert precompiled line to ASCII
     13A INI_STCK initialize basic stacks


  g) System Variables ($28000+??)
     00 SV.IDENT Identification
     02          extension flag 0:open path,1:OV error,2:No Clear ALCHP
     03          CIA-A ICR
     04 SV.CHEAP Base of common heap
     08 SV.CHPFR First free space in common heap
     0C SV.FREE  Base of free area
     10 SV.BASIC Base of BASIC stack
     14 SV.TRNSP Base of transient program area
     18 SV.TRNFR First free space in TPA
     1C SV.RESPR Base of RESPR
     20 SV.RAMT Top of RAM(+1)
     2E SV.RAND Random number(constantly changing)
     30 SV.POLLM Count of poll interrupts missed
     32 SV.TVMOD 0 if not TV display
     34 SV.MCSTA MC status register
     35 SV.PCINT PC interrupt register
     37 SV.NETNR Network station number
     38 SV.I2LST list of INT2 drivers
     3C SV.PLIST list of 50 Hz routines
     40 SV.SHLIST List of scheduler tasks
     44 SV.DRLST list of device drivers
     48 SV.DDLST list of directory device drivers
     4C SV.KEYQ  keyboard queue
     50 SV.TRAPV trap redirection table
     54 SV.BTPNT most recent slave block entry
     58 SV.BTBAS base of slave block table
     5C SV.BTTOP top of slave block table
     60 SV.JBTAG Current value of job tag
     62 SV.JBMAX Highest current job number
     64 SV.JBPNT current job table entry
     68 SV.JBBAS base of job table
     6C SV.JBTOP top of job table
     70 SV.CHTAG value of channel tag
     72 SV.CHMAX current channel number
     74 SV.CHPNT Pointer to last channel checked
     78 SV.CHBAS Pointer to base of channel table
     7C SV.CHTOP Pointer to top of channel table
     88 SV.CAPS  Caps lock
     8A SV.ARBUF Auto repeat buffer
     8C SV.ARDEL Autorepeat delay
     8E SV.ARFRQ Autorepeat 1/frequency
     90 SV.ARCNT Autorepeat count
     92 SV.CQCH  Taskswitc character(^C)
     94 SV.WP Write protect
     96 SV.SOUND Sound status
     98 SV.SER1C SER1 queue address
     9C SV.SER2C SER2 queue address
     A0 SV.TMODE ZX8032 transmit mode
     A2 SV.CSUB CAPSLOCK routine ! now changed to Clock offset !
     A6 SV.TIMO  Timeout for transmit
     A8 SV.TIMOV Value of switching timeout (2 chars.)
     AA SV.FSTAT Flashing cursor status
     F2          Amiga screen priority
     F4          Blitter server

  h) Basic Variables (??(A6))
     00 BV.BFBAS buffer base
     04 BV.BFP buffer running pointer
     08 BV.TKBAS token list
     0C BV.TKP token list running pointer
     10 BV.PFBAS program file
     14 BV.PFP program running pointer
     18 BV.NBAS name table
     1C BV.NTP name table running pointer
     20 BV.NLBAS name list
     24 BV.NLP name list running pointer
     28 BV.VVBAS variable values
     2C BV.VVP variable values running pointer
     30 BV.CHBAS channel name
     34 BV.CHP channel name running pointer
     38 BV.RTBAS return table
     3C BV.RTP return table running pointer
     40 BV.LNBAS line number table
     44 BV.LNP line number running pointer
     48 BV.BTP backtrack stack
     4C BV.BTBAS backtrack running pointer
     50 BV.TGP temporary graph stack
     54 BV.TGBAS graph stack running pointer
     58 BV.RIP arithmetic stack
     5C BV.RIBAS arithmetic stack running pointer
     60 BV.SSP  system stack
     64 BV.SSBAS system stack running pointer
     68 BV.LINUM current line number
     6A BV.LENGTH current length
     6C BV.STMNT current statement on line
     6D BV.CONT  continue ($80) or stop (0) processing
     6E BV.INLIN Processing in the line clause or not
     6F BV.SING  Single line execution ON ($FF) or OFF (0)
     70 BV.INDEX Name tab row of last inlin lp index read
     72 BV.VVFREE First free space in vvtable
     76 BV.SSSAV Saved sp for out/mem to back to
     80 BV.RAND  Random number
     84 BV.COMCH Command channel
     88 BV.NXLIN Which line number to start after
     8A BV.NXSTM Which statement to start after
     8B BV.COMLN Command line saved ($ff) or not (0)
     8C BV.STOPN Which stop number set
     8E BV.EDIT  Program has been edited ($ff) or not (0)
     8F BV.BRK  There has been a break (0) or not ($80)
     90 BV.UNRVL Need to unravel ($ff) or not (0)
     91 BV.CNSTM Statement to CONTINUE from
     92 BV.CNLND Line to CONTINUE from
     94 BV.DALNO Current DATA line number
     96 BV.DASTM Current DATA statement number
     97 BV.DAITM Next DATA item to read
     98 BV.CNIND Inline loop index to CONTINUE with
     9A BV.CNINL Inline loop flag for CONTINUE
     9B BV.LSANY Whether checking list ($ff) or not (0)
     9C BV.LSBEF Invisible top line
     9E BV.LSBAS Bottom line in window
     A0 BV.LSAFT Invisible bottom line
     A2 BV.LENLN Length of window line
     A4 BV.MAXLN Max. number of window lines
     A6 BV.TOTLN Number of window line so far
     AA BV.AUTO  Whether AUTO/EDIT is on ($FF) or off (0)
     AB BV.PRINT Print from prtok ($ff) or leave in buffer
     AC BV.EDLIN Line number to edit next
     AE BV.EDINC Increment on edit range
     E0          Toolkit 2 ALCHP
     EC          QLIB_RUN

  i) error codes and messages
     Errors are returned in D0 throughout the whole system.
     If D0 is set to 0, then no error has occured. Any negative number
     means that the operation has errored.
     -1   ERR.NC  Not complete
     -2   ERR.NJ  Invalid Job
     -3   ERR.OM  out of memory
     -4   ERR.OR  out of range
     -5   ERR.BO  Buffer full
     -6   ERR.NO  Channel not open
     -7   ERR.NF  Not found
     -8   ERR.EX  already exists
     -9   ERR.IU  in use
     -10  ERR.EF  end of file
     -11  ERR.DF  drive full
     -12  ERR.BN  bad name
     -13  ERR.TE  Xmit error
     -14  ERR.FF  Format failed
     -15  ERR.BP  bad parameter
     -16  ERR.FE  bad medium
     -17  ERR.XP  error in expression
     -18  ERR.OV  overflow
     -19  ERR.NI  not implemented
     -20  ERR.RO  read only
     -21  ERR.BL  bad line
  j) Channel definition block
  k) File system channel definition blocck
  l) Job control block
  m) common heap header
  n) Window block definition



5) Software overview

  a) Toolkits

     T.Tebby Toolkit 2                  [Qjump]
        This Toolkit is allmost essential for Working with QDOS.
        You should not try to use QDOS without this particular
        Toolkit! It provides you with JOB handling and parameter passing
        facilities, a full screen BASIC editor, a command line stack,
        wildcard file functions, default devices, definable keys
        and many other usefull commands. QDOS without the Toolkit 2 is
        unusable. Unfortunately this Toolkit is NOT public domain,
        otherwise I would have included it in this Package.
        ---- IMPLEMENTATION  NOTES -----
        This Toolkit is available as pure and unprotected software
        package, but it contains !!!!! TAS instructions !!!!!
        First load this Toolkit with
        adr=RESPR(16*1024):LBYTES FLP1_toolkit_cde,adr:CALL adr
        then let TAS_REPLACER_BAS do its work:
        LRUN FLP1_TAS_REPLACER_BAS     (automatic replace will do)
        After this you will have a new version of the Toolkit, which
        does not contain the TAS instructions. Only use this version
        from now on.

    T.Tebby pointer interface and Window manager    [Qjump]
        For those, who miss the Workbench and the mousehandling on QDOS
        this programm may be the most important thing directly behind
        the 68000 CPU inside the Computer. For others it is only a hinderance.
        You have to decide on your own. But there are some programs
        available now, which would not work without the pointer interface.
        Mostly these programs are as redundant as the pointerinterface
        itself, but you may have another opinion.
        ---- IMPLEMENTATION NOTES ----
        You have to remove TAS instructions from PTR_GEN. (automatic mode)
        The other files (WMAN, PTK_BIN, QRAM) must not be changed !

    T.Tebby Ramdisk                                 [QJUMP]
        It comes normally together with the pointer environment and
        the QRAM kind of 'workbench'. I can not remember, if it
        contains TAS instructions, but it behaves a little bit
        strange, when you try to format the RAM disk. so only
        use it as dynamic ramdisk. If you really need a fixed
        ramdisk, try the commonly used RAM_bin.

    Giga-BASIC                                      [ABC elektronik]
        Some useful and a lot of superflous commands.
        Mostly concerned with mouse and menue handling.
        Problems with compiler

  b) Languages

    QLiberator (BASIC compiler)          [Liberation Software]
        This particular compiler has nearly the same degree of usefullness
        as the T.Tebby toolkit. The compiled programs are not among the
        fastest, but this compiler can compile allmost every program,
        it includes any M-Code toolkits in the object file, and produces
        small code when using the resident runtime library.
        The compiled programs can be linked as resident toolkits to the
        interpreter, the procedures can made accessable from BASIC
        including  parameterpassing.
        ---- IMPLEMENTATION  NOTES -----
        This compiler is available as pure and unprotected software
        package, but the library contains !!!!! TAS instructions !!!!!
        use TAS_REPLACER_BAS to get around this problem. Afterwards
        you can compile TAS_REPLACER_BAS.

    Turbo (BASIC compiler)               [Digital Precision]
        Is much faster than the Qliberator, but can not pass parameters
        back to the caller, and has a lot of small bugs and
        incompatibilities. Nevertheless it would be nice if the Turbo
        compiler would work with QDOS-Amiga, but up to now it
        does not work, and the reason is still unknown. Some Programs
        which are available for QDOS are compiled with Turbo, and
        these programs have often (but by far not allways) the same
        strange behaviour as the Turbo compiler itself.
        Supercharge was an ancestor of Turbo with a very remarkable
        copy protection 'device'. You must have seen it !
        Turbo itself is not protected anymore.

    FORTRAN 77 and PASCAL         [Prospero Software]
        These are the QDOS Versions of the widely used Prospero
        compilers, which give you access to all QDOS functions,
        and have only a few minor bugs (in my Version the Double
        Precision Arithmetic makes problems, when passed through
        Functions). They are using QDOS standard relocatable format
        and are linked with the same Linker which comes with the
        GST Macro assembler, and the GST QC compiler.
        Unfortunately there is a little handicap:
        The protection against copying consists of an EPROM which also
        contains parts of the runtime library.
        To get around this problem, you can use the supplied PRL
        (Prospero Resident Library) in RAM, but you have to
        reload it after every pass of the compiler. See example
        on the QDOS disk (F77_BAS). The supplied compiler supervisor
        does not work on the Amiga anyway.

    Computer one PASCAL                    [Computer one]
        It is in general a usefull PASAL compiler with a sort of
        integrated environment. It can generate executable Jobs
        in the new Version, but it is still a P-code Pascal.
        String handling is not implemented.
        This Compiler only works with !!! less than 1MB RAM  !!!

    Metacomco PASCAL                       [Metacomco]
        Forget it !

    Lattice C                              [Metacomco]
        The only full scale C implementation for the QL.
        Some Bugs are still alive, and the Floatingpoint  arithmetic
        is terribly slow. It uses QDOS standard relocatable format
        and not Metacomcos own format. As with Lattice standard #ASM
        is not allowed, you have to write M-Code programs separately.
        ---- IMPLEMENTATION  NOTES -----
        The protection against piracy consists of an 8K EPROM which
        occupies addresses $C000 - $FFFF, mirrored at $E000.
        Make a copy from a normal QL with
        SBYTES FLP1_QLC_ROM,48*1024,16*1024
        This file can then be loaded on the Amiga at the same address.
        Use ini_EPROM_BAS to initialize the EPROM.

    QC                                     [GST]
        An integer C without STRUCTures and and UNIONs, containing
        some bugs, but allows for #ASM to be used.
        I have written some procedures to implement Floatingpoint
        Arithmetic, but it is still a torture to work with FParithmetic.
        Consider it as an interesting alternative for Assembler. The
        GST macro assembler can be used to translate the output from
        this compiler. Not tested on QDOS-Amiga.

    Digital C                              [Digital Precision]
        Integer C without STRUCTures, UNIONs and #ASM. restricted to
        32 Kbyte code. Derived from a Public Domain C for CP/M.
        Superflous, Not tested on QDOS-Amiga.

    BCPL                                   [Metacomco]
        It was the first Compiler for QDOS. BCPL is an ancestor of C.
        Floatingpoint arithmetic is implemented using procedures,
        and thus is difficuld to use. For those who like such Veterans,
        it may well be worth to have a look at this compiler.
        It uses Metacomcos special linker.
        Runs without problems on QDOS-Amiga.

    LISP                                   [Metacomco]
        A very special Version of LISP. Don't ask me to which
        standard it belongs, but it is not related to common LISP.
        Graphics and QDOS facilities are implemented.
        Runs without problems on QDOS-Amiga.

    FORTH-83                               [Computer one]
        For those who like to work with pocket calculators on
        big computers, this may be the ultimate solution.
        Multitasking, graphics, floatingpoint arithmetics and
        QDOS access are integrated.
        Runs without problems on QDOS-Amiga.

    FORTH                                  [Digital Precision]
        Another Forth. Try which you like more. I have not
        tested it, since I'm not interested in Forth anyway.

    GST Macro Assembler                    [GST]
        The only really professional Assembler !
        Macro facilities far beyond the standard !
        Produces standard QDOS relocatable Format, is small and fast.
        The only assembler which was able to translate QDOS and
        produce a running program. Included in the Test were some
        Amiga assembler (for example the Atztec assembler).
        Runs without problems on QDOS-Amiga.

    Metacomco Assembler                    [Metacomco]
        Very big (3 overlays), very  slow, lots of bugs.
        The only reason for using this assembler may be to link
        M-Code routines to other Metacomco programs, since the
        Linker for all Metacomco programs are compatible.
        I have not tested this assembler on QDOS-Amiga.

    Computer one Assembler                 [Computer one]
        Fast, small, no Macros, no linker.
        Not tested on QDOS-Amiga.

    GenQL                                  [HiSoft]
        Together with the MonQL monitor and a special editor it
        is a kind of integrated environment. A usefull Program.
        Not tested on QDOS-Amiga.

  c) Utilities

    EDITOR                                    [Eddy Yeung]
        This editor comes together with the Assembler Workbench.
        It is related in most functions to the well known (at least
        for Amiga users) Metacomco ED, but much faster. Macros
        are not provided. It is my favorite Editor.
        Runs without problems on QDOS-Amiga.

    ED                                        [Metacomco]
        You should know it from the Amiga.
        Runs on QDOS-Amiga wihout problems.

    C1Edit                                    [Computer one]
        This editor is supplied with all Computer one programs.
        It is menue driven, but not very advanced. The only good
        reason for using it may be the error message include from
        Computer one compilers.
        Runs without problems on QDOS-Amiga.

    EDIT                                      [Digital Precision]
        Very advanced editor, including a lot of macro features.
        Compiled SuperBASIC, very big. I have heard of some hard
        Bugs, when it comes to save a file !
        Not tested on QDOS-Amiga.

    compiled Basic editors                    [weiss der Geier]
        there are a lot of other editors, which are mostly written
        in Superbasic and then compiled using the TURBO compiler.
        Among them are some, which make use of the Pointer interface.
        If you like to write programs with a mouse instead of the
        keyboard, try them.

    MAKE                                      [Qjump]
    Assembler Workbench                       [Eddy Yeung]
        Another kind of integrated environment for assembler programmers.
        It provides online Help and an inline assembler.
        Unfortunately protected against copying, and available only
        on Microdrive cartridges. The cracked Version runs on QDOS-Amiga.

    QMON monitor                              [Qjump]
        A nice M-Code monitor, available as ROM. It is a good tool
        to have allways by the hand, allthough I prefer the MONQL

    MonQL monitor                             [HiSoft]
        has a corresponding assembler (GenQL) and is in general
        the most usefull monitor/debugger for the QL. The only
        disadvantage with it is, that it can not cope with addresses
        longer than 20 bits. This means, that you can only debug
        programs in CHIP memory with the MonQL. Perhaps some day HiSoft
        makes a new Version for Atari/Amiga/Thor2 users. We will be
        gratefull.

    QL super sprite generator                  [Digital Precision]
    Super Media Manager                        [Digital Precision]
        Compiled SuperBASIC. May cause lots of troubles. The only
        usefull thing is the included description of how QDOS handles
        Disks. This is worth reading, the program is for nothing.

    Solution (MS-DOS emulator)                 [Digital Precision]
        Terribly slow ! But CGA graphics is included. It is said to
        be faster than the Amiga Transformer. There may be some trouble
        in reading disks. Not testet on QDOS-Amiga.

    CPMulator (CP/M emulator)
        Think of an 0.5 MHz Z80. Apart for some bugs, thats it.
        Not tested on QDOS-Amiga.

  d) custom software

    Quill                                      [Psion]
        The original wordprocessor for QDOS. It was standard software,
        included in the price of the QL. I have written a Patch, which
        enables it to use any kind of character set. You can print your
        formatted text to a file and use any program for advanced
        character printing on normal matrix printers. I prefer the
        Public domain NLQ package.
        Runs on QDOS-Amiga without problems.

    Archive                                    [Psion]
        The original Data Base for QDOS. It was standard software,
        included in the price of the QL. Allthough not very advanced,
        and of course not able to handle pictures or sound, it may
        still be sufficient for most applications. (This is the kind
        of Data Base, which makes use of a special Language, which looks
        a litle bit like BASIC)
        Runs on QDOS-Amiga without problems.

    Easel                                      [Psion]
        The original Buisiness Graphic program for QDOS, included in
        the price of the QL. Allthough you may find better programs
        on the IBM (for example Boing graph) it is still state of the art.
        Runs on QDOS-Amiga without problems.

    Abacus                                     [Psion]
        The original Spreadsheet for QDOS, included in the price of
        the QL. It is not able to handle graphics, but still state
        of the art.
        Runs on QDOS-Amiga without problems.

    Exchange                                   [Psion]
        The combined Quill/Easel/Abacus/Archive program, able to
        multitask, including a 'Task Sequency Language', which allows
        to write macros for all 4  programs. You need memory expansion
        for using this program.
        Runs on QDOS-Amiga without problems.

    Text 87
        Advanced Word processor for QDOS. The new version runs without
        problemms on QDOS-Amiga, older Versions may cause trouble, since
        the zero divide trap is now handled  by QDOS, and it allways
        occured on the first versions.

    GraphiQL                                   [Talent]
        A picture drawing program for the low resolution mode.
        Protected against piracy. The cracked Version runs on QDOS-Amiga

    TechniQL                                   [Talent]
        Another drawing program for high resolution mode. It has
        interesting features, includes a plotter driver, and may
        well be worth using. But there is a little handicap.
        The cracked Version runs on QDOS-Amiga (with problems).

    QL Art
        It is a nice picture drawing program, but it will not run on
        QDOS-Amiga. This stupid copy protection...

    MPaint                                     [Medic Datasystems]
        The first picture drawing program for the QL which supported
        the mouse. It is a Basic program with some M-code extensions.
        The cracked and compiled Version runs on QDOS-Amiga (with problems)

    Page Designer
    Professional Desktop

  e) Games

    Games are mostly protected against copying, and are available only
    on Microdrive cartriges. But if you get a cracked Version of a game
    on a Floppydisk, here is a List of games, which may give you a survey.

   Chess                                       [Psion]
        Really good, a classic, but as far as I have tested it, it will
        never run on the Amiga. It contains TAS instructions and attempts
        to change the contents of the operatingsystem ROM,
        which is now RAM !!!

   Match (Tennis)                              [Psion]
        Another classic, it works on the Amiga, but is too fast
        for playing, since the QL had only 1/4 of the Speed.

   QL Cavern                                   [JMF]
        Grafic adventure (not comparable of course to Amiga games)
        Not too stuid, runs with modifications (Interrupts must be
        enabled !!!!!)  on the Amiga

   QL Flight  simulator                         [I don't know]
        HaHaHa

   QL Hyperdrive                                [doesn't matter]
        Is running but boring
